/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.gamestate;

import es.eucm.eadventure.common.data.chapter.Exit;
import es.eucm.eadventure.common.data.chapter.scenes.GeneralScene;
import es.eucm.eadventure.common.data.chapter.scenes.Scene;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalScene;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffects;
import es.eucm.eadventure.engine.core.control.gamestate.GameState;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;

public class GameStateNextScene
extends GameState {
    public void mainLoop(long l, int n) {
        MultimediaManager.getInstance().flushImagePool(0);
        System.gc();
        Exit exit = this.game.getNextScene();
        GeneralScene generalScene = this.game.getCurrentChapterData().getGeneralScene(exit.getNextSceneId());
        switch (generalScene.getType()) {
            case 0: {
                Object object;
                GUI.getInstance().setTransition(exit.getTransitionTime(), exit.getTransitionType(), l);
                if (this.game.getFunctionalScene() != null && !GUI.getInstance().hasTransition()) {
                    this.game.getFunctionalScene().draw();
                }
                if (GUI.getInstance().hasTransition()) {
                    GUI.getInstance().drawScene(null, l);
                }
                GUI.getInstance().clearBackground();
                Scene scene = (Scene)generalScene;
                this.game.setState(0);
                long l2 = -1L;
                if (this.game.getFunctionalScene() != null) {
                    object = null;
                    for (int i = 0; i < this.game.getFunctionalScene().getScene().getResources().size() && object == null; ++i) {
                        if (!new FunctionalConditions(this.game.getFunctionalScene().getScene().getResources().get(i).getConditions()).allConditionsOk()) continue;
                        object = this.game.getFunctionalScene().getScene().getResources().get(i).getAssetPath("bgmusic");
                    }
                    String string = null;
                    for (int i = 0; i < scene.getResources().size() && string == null; ++i) {
                        if (!new FunctionalConditions(scene.getResources().get(i).getConditions()).allConditionsOk()) continue;
                        string = scene.getResources().get(i).getAssetPath("bgmusic");
                    }
                    if (object != null && string != null && ((String)object).equals(string)) {
                        l2 = this.game.getFunctionalScene().getBackgroundMusicId();
                    } else {
                        this.game.getFunctionalScene().stopBackgroundMusic();
                    }
                }
                this.game.setPlayerLayer(scene.getPlayerLayer());
                object = new FunctionalScene(scene, this.game.getFunctionalPlayer(), l2);
                this.game.setFunctionalScene((FunctionalScene)object);
                if (exit.hasPlayerPosition()) {
                    if (scene.getTrajectory() == null) {
                        this.game.getFunctionalPlayer().setX(exit.getDestinyX());
                        this.game.getFunctionalPlayer().setY(exit.getDestinyY());
                        this.game.getFunctionalPlayer().setScale(scene.getPlayerScale());
                    } else {
                        this.game.getFunctionalScene().getTrajectory().changeInitialNode(exit.getDestinyX(), exit.getDestinyY());
                    }
                } else if (scene.getTrajectory() != null) {
                    this.game.getFunctionalScene().getTrajectory().changeInitialNode(scene.getTrajectory().getInitial().getX(), scene.getTrajectory().getInitial().getY());
                } else if (scene.hasDefaultPosition()) {
                    this.game.getFunctionalPlayer().setX(scene.getPositionX());
                    this.game.getFunctionalPlayer().setY(scene.getPositionY());
                    this.game.getFunctionalPlayer().setScale(scene.getPlayerScale());
                } else {
                    this.game.getFunctionalPlayer().setX(GUI.getInstance().getGameAreaWidth() / 2);
                    this.game.getFunctionalPlayer().setY(GUI.getInstance().getGameAreaHeight() / 2);
                    this.game.getFunctionalPlayer().setScale(scene.getPlayerScale());
                }
                this.game.getFunctionalPlayer().cancelActions();
                this.game.getFunctionalPlayer().cancelAnimations();
                this.game.getActionManager().setActionSelected(6);
                FunctionalEffects.storeAllEffects(exit.getPostEffects());
                break;
            }
            case 1: {
                GUI.getInstance().setTransition(exit.getTransitionTime(), exit.getTransitionType(), l);
                if (this.game.getFunctionalScene() != null && !GUI.getInstance().hasTransition()) {
                    this.game.getFunctionalScene().draw();
                }
                if (GUI.getInstance().hasTransition()) {
                    GUI.getInstance().drawScene(null, l);
                }
                GUI.getInstance().clearBackground();
                this.game.setState(2);
                break;
            }
            case 2: {
                if (this.game.getFunctionalScene() != null) {
                    this.game.getFunctionalScene().stopBackgroundMusic();
                }
                this.game.setState(4);
            }
        }
    }
}

