/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.gamestate;

import es.eucm.eadventure.common.data.chapter.conversation.line.ConversationLine;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.DialogueConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.OptionConversationNode;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.engine.core.control.DebugLog;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalPlayer;
import es.eucm.eadventure.engine.core.control.functionaldata.TalkingElement;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffects;
import es.eucm.eadventure.engine.core.control.gamestate.GameState;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class GameStateConversation
extends GameState {
    private final int RESPONSE_TEXT_NUMBER_LINES = GUI.getInstance().getResponseTextNumberLines();
    private final int RESPONSE_TEXT_HEIGHT;
    private final int RESPONSE_TEXT_ASCENT = GUI.getInstance().getGraphics().getFontMetrics().getAscent();
    private ConversationNode currentNode;
    private int currentLine = 0;
    private int firstLineDisplayed = 0;
    private int optionHighlighted = -1;
    private int mouseClickedButton = 0;
    private boolean firstTime;
    private int optionSelected;
    private boolean isOptionSelected = false;
    private boolean keyPressed;
    private int numberDisplayedOptions;
    private ArrayList<Integer> correspondingIndex;
    private ArrayList<ConversationLine> optionsToShow;
    private boolean generalKeepShowing;
    private String convID;
    private ConversationLine lastConversationLine = null;
    private long audioId = -1L;
    private int linePreHearing = -1;

    public GameStateConversation() {
        this.RESPONSE_TEXT_HEIGHT = this.RESPONSE_TEXT_ASCENT + 2;
        this.currentNode = this.game.getConversation().getRootNode();
        this.optionsToShow = new ArrayList();
        this.convID = new String();
        this.generalKeepShowing = Game.getInstance().getGameDescriptor().isKeepShowing();
    }

    public synchronized void mainLoop(long l, int n) {
        Graphics2D graphics2D = this.setUpGUI(l);
        if (this.currentNode.getType() == 0) {
            this.processDialogNode();
        } else if (this.currentNode.getType() == 1) {
            this.processOptionNode(graphics2D);
        }
        GUI.getInstance().endDraw();
        graphics2D.dispose();
    }

    private Graphics2D setUpGUI(long l) {
        GUI.getInstance().toggleHud(false);
        GUI.getInstance().setDefaultCursor();
        this.game.getFunctionalScene().update(l);
        GUI.getInstance().update(l);
        Graphics2D graphics2D = GUI.getInstance().getGraphics();
        graphics2D.clearRect(0, 0, 800, 600);
        this.game.getFunctionalScene().draw();
        GUI.getInstance().drawScene(graphics2D, l);
        return graphics2D;
    }

    private void processDialogNode() {
        if (this.mouseClickedButton == 0) {
            if (this.game.getCharacterCurrentlyTalking() == null || this.game.getCharacterCurrentlyTalking() != null && !this.game.getCharacterCurrentlyTalking().isTalking()) {
                this.playNextLine();
            }
        } else if (this.mouseClickedButton == 1) {
            DebugLog.user("Skipped line in conversation");
            this.playNextLine();
            this.mouseClickedButton = 0;
        } else if (this.mouseClickedButton == 3) {
            DebugLog.user("Skipped conversation");
            this.currentLine = this.currentNode.getLineCount();
            this.playNextLine();
            this.mouseClickedButton = 0;
        }
        this.firstTime = true;
    }

    private void processOptionNode(Graphics2D graphics2D) {
        if (!this.isOptionSelected) {
            this.showPlayerQuestion();
            this.optionNodeNoOptionSelected(graphics2D);
        } else {
            this.optionNodeWithOptionSelected();
        }
    }

    private void showPlayerQuestion() {
        if (((OptionConversationNode)this.currentNode).isKeepShowing().booleanValue()) {
            FunctionalPlayer functionalPlayer = this.game.getFunctionalPlayer();
            if (this.firstTime) {
                if (this.lastConversationLine.isValidAudio()) {
                    functionalPlayer.speak(this.lastConversationLine.getText(), this.lastConversationLine.getAudioPath(), true);
                } else if (this.lastConversationLine.getSynthesizerVoice().booleanValue() || functionalPlayer.isAlwaysSynthesizer()) {
                    functionalPlayer.speakWithFreeTTS(this.lastConversationLine.getText(), functionalPlayer.getPlayerVoice(), true);
                }
            } else {
                functionalPlayer.speak(this.lastConversationLine.getText(), true);
            }
            this.game.setCharacterCurrentlyTalking(functionalPlayer);
        }
    }

    private void optionNodeNoOptionSelected(Graphics2D graphics2D) {
        if (this.firstTime) {
            ((OptionConversationNode)this.currentNode).doRandom();
            this.firstTime = false;
        }
        this.numberDisplayedOptions = 0;
        this.storeOKConditionsConversationLines();
        if (this.optionsToShow.size() <= this.RESPONSE_TEXT_NUMBER_LINES) {
            for (int i = 0; i < this.optionsToShow.size(); ++i) {
                this.drawLine(graphics2D, this.optionsToShow.get(i).getText(), i, i);
                ++this.numberDisplayedOptions;
            }
        } else {
            int n;
            int n2 = Math.min(this.firstLineDisplayed + this.RESPONSE_TEXT_NUMBER_LINES - 1, this.optionsToShow.size());
            for (n = this.firstLineDisplayed; n < n2; ++n) {
                this.drawLine(graphics2D, this.optionsToShow.get(n).getText(), n - this.firstLineDisplayed, n);
                ++this.numberDisplayedOptions;
            }
            this.drawLine(graphics2D, TC.get("GameText.More"), n - this.firstLineDisplayed, n);
        }
        if (this.numberDisplayedOptions == 0) {
            this.endConversation();
        }
    }

    private void storeOKConditionsConversationLines() {
        this.optionsToShow = new ArrayList();
        this.correspondingIndex = new ArrayList();
        for (int i = 0; i < this.currentNode.getLineCount(); ++i) {
            if (!new FunctionalConditions(this.currentNode.getLine(i).getConditions()).allConditionsOk()) continue;
            this.optionsToShow.add(this.currentNode.getLine(i));
            this.correspondingIndex.add(i);
        }
    }

    private void drawLine(Graphics2D graphics2D, String string, int n, int n2) {
        int n3;
        int n4;
        int n5;
        Color color = Game.getInstance().getFunctionalPlayer().getTextFrontColor();
        if (n == this.optionHighlighted) {
            n5 = color.getRed();
            n4 = color.getGreen();
            n3 = color.getBlue();
            color = new Color(255 - n5, 255 - n4, 255 - n3);
            if (((OptionConversationNode)this.currentNode).isPreListening().booleanValue() && this.linePreHearing != n + this.firstLineDisplayed) {
                if (this.optionsToShow.size() <= this.RESPONSE_TEXT_NUMBER_LINES) {
                    this.linePreHearing = n;
                    this.setAudio(((OptionConversationNode)this.currentNode).getLine(n).getAudioPath());
                } else {
                    this.linePreHearing = n + this.firstLineDisplayed;
                    int n6 = Math.min(this.firstLineDisplayed + this.RESPONSE_TEXT_NUMBER_LINES - 1, this.currentNode.getLineCount());
                    if (this.linePreHearing != n6) {
                        this.setAudio(((OptionConversationNode)this.currentNode).getLine(this.linePreHearing).getAudioPath());
                    }
                }
            }
        }
        n5 = GUI.getInstance().getResponseTextY() + n * this.RESPONSE_TEXT_HEIGHT + this.RESPONSE_TEXT_ASCENT;
        n4 = GUI.getInstance().getResponseTextX();
        if ((string.startsWith(ConversationLine.Type.THOUGHT.toString()) || string.startsWith(ConversationLine.Type.YELL.toString()) || string.startsWith(ConversationLine.Type.WHISPER.toString())) && (n3 = string.indexOf(32)) != -1) {
            string = string.substring(n3 + 1);
        }
        String string2 = n2 + 1 + ".- " + string;
        GUI.drawStringOnto(graphics2D, string2, n4, n5, false, color, Game.getInstance().getFunctionalPlayer().getTextBorderColor(), true);
    }

    private void optionNodeWithOptionSelected() {
        if (this.game.getCharacterCurrentlyTalking() != null && this.game.getCharacterCurrentlyTalking().isTalking()) {
            if (this.mouseClickedButton == 1) {
                DebugLog.user("Skipped line in conversation");
                this.game.getCharacterCurrentlyTalking().stopTalking();
                this.mouseClickedButton = 0;
            } else if (this.mouseClickedButton == 3) {
                DebugLog.user("Skipped conversation");
                this.game.getCharacterCurrentlyTalking().stopTalking();
            } else {
                return;
            }
        }
        if (this.currentNode.hasValidEffect() && !this.currentNode.isEffectConsumed()) {
            this.currentNode.consumeEffect();
            this.game.pushCurrentState(this);
            FunctionalEffects.storeAllEffects(this.currentNode.getEffects(), true);
            GUI.getInstance().toggleHud(true);
        } else if ((!this.currentNode.hasValidEffect() || this.currentNode.isEffectConsumed()) && this.currentNode.isTerminal()) {
            this.endConversation();
        } else if (!this.currentNode.isTerminal() && this.optionSelected >= 0 && this.optionSelected < this.currentNode.getChildCount()) {
            this.currentNode.resetEffect();
            this.currentNode = this.currentNode.getChild(this.correspondingIndex.get(this.optionSelected));
            this.isOptionSelected = false;
        }
    }

    private void endConversation() {
        for (ConversationNode conversationNode : this.game.getConversation().getAllNodes()) {
            conversationNode.resetEffect();
        }
        GUI.getInstance().toggleHud(true);
        this.game.endConversation();
    }

    private void selectDisplayedOption() {
        if (this.optionSelected >= 0 && this.optionSelected < this.optionsToShow.size()) {
            if (this.game.getCharacterCurrentlyTalking() != null && this.game.getCharacterCurrentlyTalking().isTalking()) {
                this.game.getCharacterCurrentlyTalking().stopTalking();
            }
            FunctionalPlayer functionalPlayer = this.game.getFunctionalPlayer();
            ConversationLine conversationLine = this.currentNode.getLine(this.correspondingIndex.get(this.optionSelected));
            if (((OptionConversationNode)this.currentNode).isShowUserOption().booleanValue()) {
                if (conversationLine.isValidAudio()) {
                    functionalPlayer.speak(conversationLine.getText(), conversationLine.getAudioPath(), this.generalKeepShowing);
                } else if (conversationLine.getSynthesizerVoice().booleanValue() || functionalPlayer.isAlwaysSynthesizer()) {
                    functionalPlayer.speakWithFreeTTS(conversationLine.getText(), functionalPlayer.getPlayerVoice(), this.generalKeepShowing);
                } else {
                    functionalPlayer.speak(conversationLine.getText(), this.generalKeepShowing);
                }
            } else {
                functionalPlayer.speak("");
            }
            this.game.setCharacterCurrentlyTalking(functionalPlayer);
            this.isOptionSelected = true;
            this.keyPressed = false;
        }
    }

    private void selectNoAllDisplayedOption() {
        int n;
        if (!this.keyPressed) {
            this.optionSelected += this.firstLineDisplayed;
        }
        if (this.optionSelected == (n = Math.min(this.firstLineDisplayed + this.RESPONSE_TEXT_NUMBER_LINES - 1, this.currentNode.getLineCount()))) {
            this.firstLineDisplayed += this.RESPONSE_TEXT_NUMBER_LINES - 1;
            if (this.firstLineDisplayed >= this.currentNode.getLineCount()) {
                this.firstLineDisplayed = 0;
            }
        } else {
            this.selectDisplayedOption();
        }
    }

    public synchronized void mouseClicked(MouseEvent mouseEvent) {
        if (this.currentNode.getType() == 1 && GUI.getInstance().getResponseTextY() <= mouseEvent.getY() && GUI.getInstance().getResponseTextY() + this.currentNode.getLineCount() * this.RESPONSE_TEXT_HEIGHT + this.RESPONSE_TEXT_ASCENT >= mouseEvent.getY() && !this.isOptionSelected) {
            if (MultimediaManager.getInstance().isPlaying(this.audioId)) {
                MultimediaManager.getInstance().stopPlaying(this.audioId);
            }
            this.optionSelected = (mouseEvent.getY() - GUI.getInstance().getResponseTextY()) / this.RESPONSE_TEXT_HEIGHT;
            if (this.optionsToShow.size() <= this.RESPONSE_TEXT_NUMBER_LINES) {
                this.selectDisplayedOption();
            } else {
                this.selectNoAllDisplayedOption();
            }
        } else if (this.currentNode.getType() == 0 || this.isOptionSelected) {
            if (mouseEvent.getButton() == 1) {
                this.mouseClickedButton = 1;
            } else if (mouseEvent.getButton() == 3) {
                this.mouseClickedButton = 3;
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.currentNode.getType() == 1 && !this.isOptionSelected) {
            if (MultimediaManager.getInstance().isPlaying(this.audioId)) {
                MultimediaManager.getInstance().stopPlaying(this.audioId);
            }
            this.optionSelected = keyEvent.getKeyCode() >= 49 && keyEvent.getKeyCode() <= 57 ? keyEvent.getKeyCode() - 49 : -1;
            this.keyPressed = true;
            if (this.optionsToShow.size() <= this.RESPONSE_TEXT_NUMBER_LINES) {
                this.selectDisplayedOption();
            } else if (this.optionSelected >= this.firstLineDisplayed && this.optionSelected <= this.numberDisplayedOptions + this.firstLineDisplayed) {
                this.selectNoAllDisplayedOption();
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.optionHighlighted = GUI.getInstance().getResponseTextY() <= mouseEvent.getY() ? (mouseEvent.getY() - GUI.getInstance().getResponseTextY()) / this.RESPONSE_TEXT_HEIGHT : -1;
    }

    private void playNextLine() {
        if (this.game.getCharacterCurrentlyTalking() != null && this.game.getCharacterCurrentlyTalking().isTalking()) {
            this.game.getCharacterCurrentlyTalking().stopTalking();
        }
        if (this.currentLine < this.currentNode.getLineCount()) {
            this.playNextLineInNode();
        } else {
            this.skipToNextNode();
        }
    }

    private void playNextLineInNode() {
        if (this.currentLine + 1 == this.currentNode.getLineCount() && !this.currentNode.isTerminal() && this.currentNode.getChild(0).getType() == 1 && ((OptionConversationNode)this.currentNode.getChild(0)).isKeepShowing().booleanValue()) {
            ++this.currentLine;
            this.skipToNextNode();
        } else {
            ConversationLine conversationLine = this.currentNode.getLine(this.currentLine);
            FunctionalElement functionalElement = null;
            if (new FunctionalConditions(this.currentNode.getLine(this.currentLine).getConditions()).allConditionsOk()) {
                functionalElement = conversationLine.isPlayerLine() ? this.game.getFunctionalPlayer() : (conversationLine.getName().equals("NPC") ? this.game.getCurrentNPC() : this.game.getFunctionalScene().getNPC(conversationLine.getName()));
                if (functionalElement != null) {
                    boolean bl = false;
                    if (this.generalKeepShowing || conversationLine.isKeepShowing() || ((DialogueConversationNode)this.currentNode).isKeepShowing().booleanValue()) {
                        bl = true;
                    }
                    if (conversationLine.isValidAudio()) {
                        functionalElement.speak(conversationLine.getText(), conversationLine.getAudioPath(), bl);
                    } else if (conversationLine.getSynthesizerVoice().booleanValue() || functionalElement.isAlwaysSynthesizer()) {
                        functionalElement.speakWithFreeTTS(conversationLine.getText(), functionalElement.getPlayerVoice(), bl);
                    } else {
                        functionalElement.speak(conversationLine.getText(), bl);
                    }
                }
                this.game.setCharacterCurrentlyTalking((TalkingElement)((Object)functionalElement));
            }
            ++this.currentLine;
        }
    }

    private void skipToNextNode() {
        this.lastConversationLine = this.currentLine != 0 ? this.currentNode.getConversationLine(this.currentLine - 1) : new ConversationLine("fake", "");
        if (this.currentNode.hasValidEffect() && !this.currentNode.isEffectConsumed()) {
            this.currentNode.consumeEffect();
            this.game.pushCurrentState(this);
            FunctionalEffects.storeAllEffects(this.currentNode.getEffects(), true);
            GUI.getInstance().toggleHud(true);
        } else if ((!this.currentNode.hasValidEffect() || this.currentNode.isEffectConsumed()) && this.currentNode.isTerminal()) {
            this.endConversation();
        } else if (!this.currentNode.isTerminal()) {
            this.currentNode.resetEffect();
            this.currentNode = this.currentNode.getChild(0);
            this.firstLineDisplayed = 0;
            this.currentLine = 0;
        }
    }

    public void setAudio(String string) {
        if (string != null) {
            if (MultimediaManager.getInstance().isPlaying(this.audioId)) {
                MultimediaManager.getInstance().stopPlaying(this.audioId);
            }
            this.audioId = MultimediaManager.getInstance().loadSound(string, false);
            MultimediaManager.getInstance().startPlaying(this.audioId);
            while (!MultimediaManager.getInstance().isPlaying(this.audioId)) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void setConvID(String string) {
        this.convID = string;
    }

    public String getConvID() {
        return this.convID;
    }
}

