/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.gamestate;

import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalBook;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalStyledBook;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalTextBook;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffects;
import es.eucm.eadventure.engine.core.control.gamestate.GameState;
import es.eucm.eadventure.engine.core.gui.GUI;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;

public class GameStateBook
extends GameState {
    private FunctionalBook book;

    public GameStateBook() {
        if (this.game.getBook().getType() == 0) {
            this.book = new FunctionalTextBook(this.game.getBook());
        } else if (this.game.getBook().getType() == 1) {
            this.book = new FunctionalStyledBook(this.game.getBook());
        }
    }

    public void mainLoop(long l, int n) {
        if (this.book.getBook().getType() == 0) {
            Graphics2D graphics2D = GUI.getInstance().getGraphics();
            graphics2D.clearRect(0, 0, 800, 600);
            ((FunctionalTextBook)this.book).draw(graphics2D);
            graphics2D.setColor(Color.WHITE);
            GUI.getInstance().endDraw();
            graphics2D.dispose();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            if (this.book.isInPreviousPage(mouseEvent.getX(), mouseEvent.getY())) {
                this.book.previousPage();
            } else if (this.book.isInNextPage(mouseEvent.getX(), mouseEvent.getY())) {
                if (this.book.isInLastPage()) {
                    GUI.getInstance().restoreFrame();
                    FunctionalEffects.storeAllEffects(new Effects());
                } else {
                    this.book.nextPage();
                }
            }
        } else if (mouseEvent.getButton() == 3) {
            GUI.getInstance().restoreFrame();
            FunctionalEffects.storeAllEffects(new Effects());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        boolean bl = this.book.isInPreviousPage(mouseEvent.getX(), mouseEvent.getY());
        this.book.mouseOverPreviousPage(bl);
        boolean bl2 = this.book.isInNextPage(mouseEvent.getX(), mouseEvent.getY());
        this.book.mouseOverNextPage(bl2);
    }
}

