/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects;

import es.eucm.eadventure.common.data.chapter.effects.ShowTextEffect;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffect;
import es.eucm.eadventure.engine.core.gui.GUI;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.util.Hashtable;
import javax.swing.Timer;

public class FunctionalShowTextEffect
extends FunctionalEffect {
    private String text;
    private int timeShown;
    private boolean isStillRunning;
    private Timer timer;
    private boolean skipByUser;

    FunctionalShowTextEffect(ShowTextEffect showTextEffect) {
        super(showTextEffect);
        this.text = showTextEffect.getText();
        float f = 1.0f;
        if (Game.getInstance().getOptions().getTextSpeed() == 0) {
            f = 1.5f;
        }
        if (Game.getInstance().getOptions().getTextSpeed() == 2) {
            f = 0.8f;
        }
        this.timeShown = (int)((float)(300 * showTextEffect.getText().split(" ").length) * f);
        if (this.timeShown < (int)(1400.0f * f)) {
            this.timeShown = (int)(1400.0f * f);
        }
        this.isStillRunning = false;
        this.skipByUser = false;
    }

    public boolean isInstantaneous() {
        return false;
    }

    public boolean isStillRunning() {
        return this.isStillRunning;
    }

    public void triggerEffect() {
        this.timer = new Timer(this.timeShown * 2, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionalShowTextEffect.this.finish();
            }
        });
        this.isStillRunning = true;
        this.timer.start();
    }

    public void draw() {
        GUI.getInstance().getGraphics().setFont(GUI.getInstance().getGraphics().getFont().deriveFont(18.0f));
        Hashtable<TextAttribute, Float> hashtable = new Hashtable<TextAttribute, Float>();
        hashtable.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
        GUI.getInstance().getGraphics().setFont(GUI.getInstance().getGraphics().getFont().deriveFont(hashtable));
        GUI.getInstance().addTextToDraw(this.text, ((ShowTextEffect)this.effect).getX() - Game.getInstance().getFunctionalScene().getOffsetX(), ((ShowTextEffect)this.effect).getY(), new Color(((ShowTextEffect)this.effect).getRgbFrontColor()), new Color(((ShowTextEffect)this.effect).getRgbBorderColor()));
    }

    private void finish() {
        if (Game.getInstance().getGameDescriptor().isKeepShowing().booleanValue() && !this.skipByUser) {
            this.timer.restart();
        } else {
            this.isStillRunning = false;
            this.timer.stop();
        }
    }

    public boolean canSkip() {
        return true;
    }

    public void skip() {
        this.skipByUser = true;
        this.finish();
    }
}

