/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects;

import es.eucm.eadventure.common.data.chapter.effects.RandomEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffect;
import java.util.Random;

public class FunctionalRandomEffect
extends FunctionalEffect {
    private static final Random r = new Random();
    private FunctionalEffect positiveEffect;
    private FunctionalEffect negativeEffect;
    private boolean positive;
    private FunctionalEffect effectTriggered;

    public FunctionalRandomEffect(RandomEffect randomEffect) {
        super(randomEffect);
        this.positiveEffect = FunctionalEffect.buildFunctionalEffect(randomEffect.getPositiveEffect());
        this.negativeEffect = FunctionalEffect.buildFunctionalEffect(randomEffect.getNegativeEffect());
    }

    private FunctionalEffect getEffectToBeTriggered() {
        int n = r.nextInt(100);
        boolean bl = this.positive = n < ((RandomEffect)this.effect).getProbability();
        if (this.positive) {
            // empty if block
        }
        if (this.positive) {
            return this.positiveEffect;
        }
        return this.negativeEffect;
    }

    public boolean isInstantaneous() {
        if (this.effectTriggered != null) {
            return this.effectTriggered.isInstantaneous();
        }
        return false;
    }

    public boolean isStillRunning() {
        if (this.effectTriggered != null) {
            return this.effectTriggered.isStillRunning();
        }
        return false;
    }

    public void triggerEffect() {
        this.effectTriggered = this.getEffectToBeTriggered();
        if (this.effectTriggered != null && this.effectTriggered.isAllConditionsOK()) {
            this.effectTriggered.triggerEffect();
        }
    }

    public FunctionalEffect getTriggerEffect() {
        return this.effectTriggered;
    }
}

