/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects;

import es.eucm.eadventure.common.data.chapter.effects.AbstractEffect;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffect;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionalEffects {
    private boolean hasCancelAction = false;
    private ArrayList<FunctionalEffect> functionalEffects = new ArrayList();

    public FunctionalEffects() {
    }

    public FunctionalEffects(Effects effects) {
        this();
        for (AbstractEffect abstractEffect : effects.getEffects()) {
            FunctionalEffect functionalEffect = FunctionalEffect.buildFunctionalEffect(abstractEffect);
            if (functionalEffect == null) continue;
            this.functionalEffects.add(functionalEffect);
        }
        this.hasCancelAction = effects.hasCancelAction();
    }

    public FunctionalEffect getEffect(int n) {
        return this.functionalEffects.get(n);
    }

    public void setHasCancelAction(boolean bl) {
        this.hasCancelAction = bl;
    }

    public boolean hasCancelAction() {
        return this.hasCancelAction;
    }

    public static void storeAllEffects(Effects effects) {
        Game.getInstance().storeEffectsInQueue(new FunctionalEffects(effects).getEffects(), false);
    }

    public static void storeAllEffects(Effects effects, boolean bl) {
        Game.getInstance().storeEffectsInQueue(new FunctionalEffects(effects).getEffects(), bl);
    }

    public static void storeAllEffects(FunctionalEffects functionalEffects) {
        Game.getInstance().storeEffectsInQueue(functionalEffects.getEffects(), false);
    }

    public ArrayList<FunctionalEffect> getEffects() {
        return this.functionalEffects;
    }

    public void addEffect(FunctionalEffect functionalEffect) {
        this.functionalEffects.add(functionalEffect);
    }
}

