/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata.functionalactions;

import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.engine.core.control.DebugLog;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.animations.Animation;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalPlayer;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalAction;
import es.eucm.eadventure.engine.core.data.GameText;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;

public class FunctionalUse
extends FunctionalAction {
    private FunctionalElement element;
    private long totalTime;
    private boolean canUse = false;

    public FunctionalUse(FunctionalElement functionalElement) {
        super(null);
        this.type = 4;
        this.element = functionalElement;
        this.originalAction = functionalElement.getFirstValidAction(4);
        if (functionalElement.isInInventory() || this.originalAction == null) {
            this.needsGoTo = false;
        } else {
            this.needsGoTo = this.originalAction.isNeedsGoTo();
            this.keepDistance = this.originalAction.getKeepDistance();
        }
    }

    public void drawAditionalElements() {
    }

    public void setAnotherElement(FunctionalElement functionalElement) {
    }

    public void start(FunctionalPlayer functionalPlayer) {
        this.functionalPlayer = functionalPlayer;
        this.needsGoTo = true;
        this.finished = false;
        this.totalTime = 0L;
        Resources resources = functionalPlayer.getResources();
        MultimediaManager multimediaManager = MultimediaManager.getInstance();
        Animation[] animationArray = new Animation[4];
        animationArray[2] = resources.getAssetPath("useright") != null && !resources.getAssetPath("useright").equals("assets/special/EmptyAnimation") && !resources.getAssetPath("useright").equals("assets/special/EmptyAnimation.eaa") ? multimediaManager.loadAnimation(resources.getAssetPath("useright"), false, 2) : multimediaManager.loadAnimation(resources.getAssetPath("useleft"), true, 2);
        animationArray[3] = resources.getAssetPath("useleft") != null && !resources.getAssetPath("useleft").equals("assets/special/EmptyAnimation") && !resources.getAssetPath("useleft").equals("assets/special/EmptyAnimation.eaa") ? multimediaManager.loadAnimation(resources.getAssetPath("useleft"), false, 2) : multimediaManager.loadAnimation(resources.getAssetPath("useright"), true, 2);
        animationArray[0] = multimediaManager.loadAnimation(resources.getAssetPath("useright"), false, 2);
        animationArray[1] = multimediaManager.loadAnimation(resources.getAssetPath("useright"), true, 2);
        if (functionalPlayer.getX() < this.element.getX()) {
            functionalPlayer.setDirection(2);
        } else {
            functionalPlayer.setDirection(3);
        }
        functionalPlayer.setAnimation(animationArray, -1);
    }

    public void stop() {
        this.finished = true;
    }

    public void update(long l) {
        this.totalTime += l;
        if (!this.finished && !this.canUse) {
            this.canUse = this.element.use();
            if (!this.canUse) {
                DebugLog.player("Can't use " + this.element.getElement().getId());
                if (this.functionalPlayer.isAlwaysSynthesizer()) {
                    this.functionalPlayer.speakWithFreeTTS(GameText.getTextUseCannot(), this.functionalPlayer.getPlayerVoice());
                } else {
                    this.functionalPlayer.speak(GameText.getTextUseCannot(), Game.getInstance().getGameDescriptor().isKeepShowing());
                }
                this.functionalPlayer.popAnimation();
                this.finished = true;
            }
        } else if (!this.finished && this.totalTime > 1000L) {
            DebugLog.player("Used " + this.element.getElement().getId());
            this.finished = true;
            this.functionalPlayer.popAnimation();
        }
    }
}

