/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata.functionalactions;

import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.engine.core.control.DebugLog;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalNPC;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalPlayer;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalAction;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffects;
import es.eucm.eadventure.engine.core.data.GameText;
import java.util.List;

public class FunctionalTalk
extends FunctionalAction {
    public static final int DEFAULT_DISTANCE_TO_KEEP = 35;
    FunctionalNPC npc;
    private boolean anyConversation;

    public FunctionalTalk(Action action, FunctionalElement functionalElement) {
        super(action);
        this.npc = (FunctionalNPC)functionalElement;
        this.type = 2;
        this.keepDistance = this.functionalPlayer != null ? this.functionalPlayer.getWidth() / 2 : 35;
        this.keepDistance += functionalElement.getWidth() / 2;
        List<Action> list = this.npc.getNPC().getActions();
        Action action2 = null;
        this.anyConversation = false;
        for (int i = 0; i < list.size() && !this.anyConversation; ++i) {
            if (list.get(i).getType() != 7 || !new FunctionalConditions(list.get(i).getConditions()).allConditionsOk()) continue;
            action2 = list.get(i);
            this.anyConversation = true;
        }
        if (this.anyConversation) {
            this.needsGoTo = true;
            if (action2 != null) {
                this.needsGoTo = action2.isNeedsGoTo();
            }
        } else {
            this.needsGoTo = false;
        }
    }

    public void drawAditionalElements() {
    }

    public void setAnotherElement(FunctionalElement functionalElement) {
    }

    public void start(FunctionalPlayer functionalPlayer) {
        this.functionalPlayer = functionalPlayer;
        if (this.anyConversation) {
            if (this.npc != null) {
                if (this.npc.getX() > functionalPlayer.getX()) {
                    functionalPlayer.setDirection(2);
                } else {
                    functionalPlayer.setDirection(3);
                }
            }
            this.finished = false;
        } else {
            if (functionalPlayer.isAlwaysSynthesizer()) {
                functionalPlayer.speakWithFreeTTS(GameText.getTextTalkCannot(), functionalPlayer.getPlayerVoice());
            } else {
                functionalPlayer.speak(GameText.getTextTalkCannot(), Game.getInstance().getGameDescriptor().isKeepShowing());
            }
            this.finished = true;
        }
        DebugLog.player("Start talk : " + this.npc.getNPC().getId());
    }

    public void stop() {
        this.finished = true;
    }

    public void update(long l) {
        List<Action> list = this.npc.getNPC().getActions();
        boolean bl = false;
        for (int i = 0; i < list.size() && !bl; ++i) {
            if (list.get(i).getType() != 7 || !new FunctionalConditions(list.get(i).getConditions()).allConditionsOk()) continue;
            Game.getInstance().setCurrentNPC(this.npc);
            FunctionalEffects.storeAllEffects(list.get(i).getEffects());
            bl = true;
        }
        if (!bl) {
            if (this.functionalPlayer.isAlwaysSynthesizer()) {
                this.functionalPlayer.speakWithFreeTTS(GameText.getTextTalkCannot(), this.functionalPlayer.getPlayerVoice());
            } else {
                this.functionalPlayer.speak(GameText.getTextTalkCannot(), Game.getInstance().getGameDescriptor().isKeepShowing());
            }
        }
        this.finished = true;
    }
}

