/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata.functionalactions;

import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.engine.core.control.DebugLog;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.animations.Animation;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalPlayer;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalTrajectory;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalAction;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;

public class FunctionalGoTo
extends FunctionalAction {
    private int posX;
    private int posY;
    private int originalPosX;
    private int originalPosY;
    private float speedX;
    private float speedY;
    private boolean hasAnimation = false;
    private FunctionalTrajectory trajectory;
    private Resources resources;
    private MultimediaManager multimedia;
    private boolean trajectoryUpdated;

    public FunctionalGoTo(Action action, int n, int n2) {
        super(action);
        this.originalPosX = n;
        this.originalPosY = n2;
        this.trajectory = Game.getInstance().getFunctionalScene().getTrajectory();
        int[] nArray = Game.getInstance().getFunctionalScene().checkPlayerAgainstBarriers(n, n2);
        if (this.trajectory.hasTrajectory()) {
            this.trajectory.setDestinationElement(null);
            this.trajectory.updatePathToNearestPoint(Game.getInstance().getFunctionalPlayer().getX(), Game.getInstance().getFunctionalPlayer().getY(), n, n2);
            this.trajectoryUpdated = true;
        }
        this.posX = nArray[0];
        this.posY = nArray[1];
        this.trajectoryUpdated = false;
        this.type = 6;
        this.keepDistance = 0;
    }

    public FunctionalGoTo(Action action, int n, int n2, int n3) {
        this(action, n, n2);
        this.keepDistance = n3;
    }

    public FunctionalGoTo(Action action, int n, int n2, FunctionalPlayer functionalPlayer, FunctionalElement functionalElement) {
        this(action, n, n2);
        if (this.trajectory.hasTrajectory()) {
            this.trajectory.setDestinationElement(functionalElement);
            this.trajectory.updatePathToNearestPoint(functionalPlayer.getX(), functionalPlayer.getY(), this.originalPosX, this.originalPosY);
            this.trajectoryUpdated = true;
        }
    }

    public void start(FunctionalPlayer functionalPlayer) {
        this.functionalPlayer = functionalPlayer;
        this.finished = false;
        this.needsGoTo = false;
        this.resources = functionalPlayer.getResources();
        this.multimedia = MultimediaManager.getInstance();
        if (!this.trajectory.hasTrajectory()) {
            if (functionalPlayer.getX() < (float)this.posX) {
                functionalPlayer.setDirection(2);
                this.speedX = 120.0f;
            } else {
                functionalPlayer.setDirection(3);
                this.speedX = -120.0f;
            }
            Animation[] animationArray = new Animation[4];
            animationArray[2] = this.resources.getAssetPath("walkright") != null && !this.resources.getAssetPath("walkright").equals("assets/special/EmptyAnimation") && !this.resources.getAssetPath("walkright").equals("assets/special/EmptyAnimation.eaa") ? this.multimedia.loadAnimation(this.resources.getAssetPath("walkright"), false, 2) : this.multimedia.loadAnimation(this.resources.getAssetPath("walkleft"), true, 2);
            animationArray[3] = this.resources.getAssetPath("walkleft") != null && !this.resources.getAssetPath("walkleft").equals("assets/special/EmptyAnimation") && !this.resources.getAssetPath("walkleft").equals("assets/special/EmptyAnimation.eaa") ? this.multimedia.loadAnimation(this.resources.getAssetPath("walkleft"), false, 2) : this.multimedia.loadAnimation(this.resources.getAssetPath("walkright"), true, 2);
            functionalPlayer.setAnimation(animationArray, -1);
        } else if (!this.trajectoryUpdated) {
            this.trajectory.updatePathToNearestPoint(functionalPlayer.getX(), functionalPlayer.getY(), this.posX, this.posY);
        }
        DebugLog.player("Player moves: hasTrajectory=" + this.trajectory.hasTrajectory() + " destination=" + this.posX + "," + this.posY);
    }

    public void update(long l) {
        if (!this.trajectory.hasTrajectory() && !this.finished) {
            boolean bl = false;
            boolean bl2 = true;
            if (this.speedX > 0.0f && this.functionalPlayer.getX() < (float)(this.posX - this.keepDistance) || this.speedX <= 0.0f && this.functionalPlayer.getX() >= (float)(this.posX + this.keepDistance)) {
                float f = this.functionalPlayer.getX();
                float f2 = f + this.speedX * (float)l / 1000.0f;
                this.functionalPlayer.setX(f2);
            } else {
                bl = true;
            }
            if (bl && bl2) {
                this.finished = true;
                this.functionalPlayer.popAnimation();
            }
        } else if (!this.finished) {
            float f = this.trajectory.getSpeedX();
            float f3 = this.trajectory.getSpeedY();
            this.trajectory.updateSpeeds(l, this.functionalPlayer.getX(), this.functionalPlayer.getY(), 120.0f);
            if (this.trajectory.getSpeedX() != 0.0f || this.trajectory.getSpeedY() != 0.0f) {
                this.setAnimation(f, f3, this.trajectory.getSpeedX(), this.trajectory.getSpeedY());
                this.functionalPlayer.setScale(this.trajectory.getScale());
                float f4 = this.functionalPlayer.getX();
                float f5 = f4 + this.trajectory.getSpeedX() * (float)l / 1000.0f;
                this.functionalPlayer.setX(f5);
                float f6 = this.functionalPlayer.getY();
                float f7 = f6 + this.trajectory.getSpeedY() * (float)l / 1000.0f;
                this.functionalPlayer.setY(f7);
            } else {
                this.finished = true;
                this.functionalPlayer.popAnimation();
            }
        }
    }

    private void setAnimation(float f, float f2, float f3, float f4) {
        Animation[] animationArray = new Animation[4];
        animationArray[2] = this.multimedia.loadAnimation(this.resources.getAssetPath("walkright"), false, 2);
        animationArray[3] = this.resources.getAssetPath("walkleft") != null && !this.resources.getAssetPath("walkleft").equals("assets/special/EmptyAnimation") && !this.resources.getAssetPath("walkleft").equals("assets/special/EmptyAnimation.eaa") ? this.multimedia.loadAnimation(this.resources.getAssetPath("walkleft"), false, 2) : this.multimedia.loadAnimation(this.resources.getAssetPath("walkright"), true, 2);
        animationArray[0] = this.multimedia.loadAnimation(this.resources.getAssetPath("walkup"), false, 2);
        animationArray[1] = this.multimedia.loadAnimation(this.resources.getAssetPath("walkdown"), false, 2);
        int n = 2;
        if (Game.getInstance().isIsometric()) {
            double d = Math.atan2(f4, f3);
            System.out.println(d);
            n = d < -1.5707963267948966 ? 3 : (d < 0.0 ? 0 : (d < 1.5707963267948966 ? 2 : 1));
        } else {
            n = Math.abs(f4) > Math.abs(f3) ? (f4 > 0.0f ? 1 : 0) : (f3 > 0.0f ? 2 : 3);
        }
        if (!this.hasAnimation) {
            this.hasAnimation = true;
            this.functionalPlayer.setDirection(n);
            this.functionalPlayer.setAnimation(animationArray, -1);
        } else if (n != this.functionalPlayer.getDirection()) {
            this.functionalPlayer.popAnimation();
            this.functionalPlayer.setDirection(n);
            this.functionalPlayer.setAnimation(animationArray, -1);
        }
    }

    public boolean canGetTo() {
        if (!this.trajectory.hasTrajectory()) {
            return this.posX == this.originalPosX && this.posY == this.originalPosY;
        }
        return this.trajectory.canGetTo();
    }

    public void drawAditionalElements() {
    }

    public void stop() {
        this.finished = true;
    }

    public void setAnotherElement(FunctionalElement functionalElement) {
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }
}

