/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata.functionalactions;

import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalItem;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalNPC;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalPlayer;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalAction;
import es.eucm.eadventure.engine.core.data.GameText;

public class FunctionalDragTo
extends FunctionalAction {
    private FunctionalElement element;
    private FunctionalElement anotherElement;
    private long totalTime;

    public FunctionalDragTo(FunctionalElement functionalElement) {
        super(null);
        this.type = 8;
        this.originalAction = functionalElement.getFirstValidAction(8);
        this.element = functionalElement;
        this.requiersAnotherElement = true;
        this.needsGoTo = false;
        this.finished = false;
    }

    public void drawAditionalElements() {
    }

    public void setAnotherElement(FunctionalElement functionalElement) {
        this.anotherElement = functionalElement;
        this.requiersAnotherElement = false;
        if (this.originalAction != null) {
            this.needsGoTo = this.originalAction.isNeedsGoTo();
            this.keepDistance = this.originalAction.getKeepDistance();
        }
    }

    public void start(FunctionalPlayer functionalPlayer) {
        if (!this.requiersAnotherElement) {
            this.functionalPlayer = functionalPlayer;
            this.totalTime = 0L;
        }
    }

    public void stop() {
        this.finished = true;
    }

    public void update(long l) {
        if (this.anotherElement != null) {
            this.totalTime += l;
            if (this.totalTime > 1000L) {
                if (this.element instanceof FunctionalItem) {
                    this.spreadDrag((FunctionalItem)this.element);
                } else if (this.element instanceof FunctionalNPC) {
                    this.spreadDrag((FunctionalNPC)this.element);
                }
                this.finished = true;
            }
        }
    }

    private void spreadDrag(FunctionalItem functionalItem) {
        FunctionalElement functionalElement;
        if (this.anotherElement instanceof FunctionalItem && !functionalItem.dragTo((FunctionalItem)(functionalElement = (FunctionalItem)this.anotherElement))) {
            if (this.functionalPlayer.isAlwaysSynthesizer()) {
                this.functionalPlayer.speakWithFreeTTS(GameText.getTextCustomCannot(), this.functionalPlayer.getPlayerVoice());
            } else {
                this.functionalPlayer.speak(GameText.getTextCustomCannot(), Game.getInstance().getGameDescriptor().isKeepShowing());
            }
        }
        if (this.anotherElement instanceof FunctionalNPC && !functionalItem.dragTo((FunctionalNPC)(functionalElement = (FunctionalNPC)this.anotherElement))) {
            if (this.functionalPlayer.isAlwaysSynthesizer()) {
                this.functionalPlayer.speakWithFreeTTS(GameText.getTextCustomCannot(), this.functionalPlayer.getPlayerVoice());
            } else {
                this.functionalPlayer.speak(GameText.getTextCustomCannot(), Game.getInstance().getGameDescriptor().isKeepShowing());
            }
        }
    }

    private void spreadDrag(FunctionalNPC functionalNPC) {
        FunctionalElement functionalElement;
        if (this.anotherElement instanceof FunctionalItem && !functionalNPC.dragTo((FunctionalItem)(functionalElement = (FunctionalItem)this.anotherElement))) {
            if (this.functionalPlayer.isAlwaysSynthesizer()) {
                this.functionalPlayer.speakWithFreeTTS(GameText.getTextCustomCannot(), this.functionalPlayer.getPlayerVoice());
            } else {
                this.functionalPlayer.speak(GameText.getTextCustomCannot(), Game.getInstance().getGameDescriptor().isKeepShowing());
            }
        }
        if (this.anotherElement instanceof FunctionalNPC && !functionalNPC.dragTo((FunctionalNPC)(functionalElement = (FunctionalNPC)this.anotherElement))) {
            if (this.functionalPlayer.isAlwaysSynthesizer()) {
                this.functionalPlayer.speakWithFreeTTS(GameText.getTextCustomCannot(), this.functionalPlayer.getPlayerVoice());
            } else {
                this.functionalPlayer.speak(GameText.getTextCustomCannot(), Game.getInstance().getGameDescriptor().isKeepShowing());
            }
        }
    }
}

