/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata;

import es.eucm.eadventure.common.data.chapter.InfluenceArea;
import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalBarrier;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalPath;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalSide;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionalTrajectory {
    private Trajectory trajectory;
    private Trajectory.Side currentSide;
    private List<FunctionalSide> currentPath;
    private int nearestX;
    private int nearestY;
    private float speedX;
    private float speedY;
    private float scale = 1.0f;
    private boolean getsTo;
    private List<FunctionalBarrier> barriers;
    private List<FunctionalSide> sides;
    private FunctionalElement destinationElement;

    public FunctionalTrajectory(Trajectory trajectory, ArrayList<FunctionalBarrier> arrayList) {
        this.trajectory = trajectory;
        this.sides = new ArrayList<FunctionalSide>();
        this.barriers = arrayList;
        if (trajectory != null) {
            for (Trajectory.Side object : trajectory.getSides()) {
                FunctionalSide functionalSide = new FunctionalSide(object, trajectory, false);
                if (!this.sides.contains(functionalSide)) {
                    this.sides.add(functionalSide);
                }
                if (this.sides.contains(functionalSide = new FunctionalSide(object, trajectory, true))) continue;
                this.sides.add(functionalSide);
            }
            for (FunctionalSide functionalSide : this.sides) {
                if (functionalSide.getStartNode() != trajectory.getInitial()) continue;
                this.currentSide = functionalSide.getSide();
            }
        }
    }

    public boolean hasTrajectory() {
        return this.trajectory != null;
    }

    public void updatePathToNearestPoint(float f, float f2, int n, int n2) {
        this.currentPath = this.pathToNearestPoint(f, f2, n, n2);
    }

    private List<FunctionalSide> pathToNearestPoint(float f, float f2, int n, int n2) {
        Cloneable cloneable;
        List<FunctionalSide> list = this.getCurrentValidSides();
        ArrayList<FunctionalPath> arrayList = new ArrayList<FunctionalPath>();
        for (FunctionalSide object2 : list) {
            cloneable = new ArrayList<FunctionalSide>();
            cloneable.add(object2);
            float f3 = FunctionalTrajectory.getDistanceFast(f, f2, object2.getEndNode().getX(), object2.getEndNode().getY());
            float functionalSide = object2.getLenght() / object2.getRealLength() * f3;
            FunctionalPath functionalPath = new FunctionalPath(functionalSide, Float.MAX_VALUE, (List<FunctionalSide>)((Object)cloneable));
            arrayList.add(functionalPath);
        }
        List<FunctionalPath> list2 = this.getFullPathList(arrayList);
        FunctionalPath functionalPath = this.getValidPaths(list2, f, f2, n, n2);
        if (functionalPath != null) {
            this.nearestX = (int)functionalPath.getDestX();
            this.nearestY = (int)functionalPath.getDestY();
            this.currentSide = functionalPath.getSides().get(0).getSide();
            this.getsTo = functionalPath.isGetsTo();
            return functionalPath.getSides();
        }
        cloneable = this.trajectory.getInitial();
        this.nearestX = ((Trajectory.Node)cloneable).getX();
        this.nearestY = ((Trajectory.Node)cloneable).getY();
        for (FunctionalSide functionalSide : this.sides) {
            if (functionalSide.getStartNode() != cloneable) continue;
            this.currentSide = functionalSide.getSide();
        }
        this.getsTo = false;
        return new ArrayList<FunctionalSide>();
    }

    public static float getDistance(float f, float f2, float f3, float f4) {
        return (float)Math.sqrt(Math.pow(f - f3, 2.0) + Math.pow(f2 - f4, 2.0));
    }

    static float getDistanceFast(float f, float f2, float f3, float f4) {
        return (f - f3) * (f - f3) + (f2 - f4) * (f2 - f4);
    }

    private FunctionalPath getValidPaths(List<FunctionalPath> list, float f, float f2, int n, int n2) {
        FunctionalPath functionalPath = null;
        for (FunctionalSide object : this.sides) {
            object.updateMinimunDistance(n, n2, this.destinationElement, this.barriers);
        }
        for (FunctionalPath functionalPath2 : list) {
            FunctionalPath functionalPath3 = new FunctionalPath(0.0f, Float.MAX_VALUE, new ArrayList<FunctionalSide>());
            float f3 = FunctionalTrajectory.getDistance(f, f2, functionalPath2.getSides().get(0).getEndNode().getX(), functionalPath2.getSides().get(0).getEndNode().getY()) / functionalPath2.getSides().get(0).getRealLength() * functionalPath2.getSides().get(0).getLenght();
            functionalPath3.addSide(f3, Float.MAX_VALUE, functionalPath2.getSides().get(0));
            float f4 = f;
            float f5 = f2;
            boolean bl = false;
            for (int i = 1; !bl && i <= functionalPath2.getSides().size(); ++i) {
                Object object;
                if (i == 1) {
                    object = functionalPath3.getSides().get(i - 1).getEndNode();
                    float f6 = (float)((Trajectory.Node)object).getX() - f4;
                    float f7 = (float)((Trajectory.Node)object).getY() - f5;
                    int n3 = (int)(Math.abs(f6) > Math.abs(f7) ? Math.abs(f6) : Math.abs(f7));
                    for (int j = 0; j < n3 && !bl; ++j) {
                        float f8;
                        if (this.inBarrier(f4 += f6 / (float)n3, f5 += f7 / (float)n3)) {
                            bl = true;
                            continue;
                        }
                        if (this.destinationElement != null && this.inInfluenceArea(f4, f5)) {
                            f8 = 0.0f;
                            functionalPath3.updateUpTo(f8, f4, f5);
                            functionalPath3.setGetsTo(true);
                            bl = true;
                            continue;
                        }
                        if (this.destinationElement != null) continue;
                        f8 = FunctionalTrajectory.getDistanceFast(f4, f5, n, n2);
                        functionalPath3.updateUpTo(f8, f4, f5);
                    }
                } else {
                    object = functionalPath3.getSides().get(i - 1);
                    bl = ((FunctionalSide)object).end;
                    functionalPath3.updateUpTo(((FunctionalSide)object).dist, ((FunctionalSide)object).posX, ((FunctionalSide)object).posY);
                    functionalPath3.setGetsTo(((FunctionalSide)object).getsTo);
                    f4 = ((FunctionalSide)object).posX;
                    f5 = ((FunctionalSide)object).posY;
                }
                if (functionalPath == null) {
                    functionalPath = functionalPath3;
                } else if (functionalPath.compareTo(functionalPath3) < 0) {
                    functionalPath = functionalPath3;
                }
                if (i >= functionalPath2.getSides().size()) continue;
                functionalPath3 = functionalPath3.newFunctionalPath(functionalPath2.getSides().get(i).getLenght(), Float.MAX_VALUE, functionalPath2.getSides().get(i));
                f4 = functionalPath2.getSides().get(i).getStartNode().getX();
                f5 = functionalPath2.getSides().get(i).getStartNode().getY();
            }
        }
        return functionalPath;
    }

    private boolean inBarrier(float f, float f2) {
        boolean bl = false;
        for (FunctionalBarrier functionalBarrier : this.barriers) {
            bl = bl || functionalBarrier.isInside(f, f2);
        }
        return bl;
    }

    private boolean inInfluenceArea(float f, float f2) {
        if (this.destinationElement == null) {
            return false;
        }
        InfluenceArea influenceArea = this.destinationElement.getInfluenceArea() != null ? this.destinationElement.getInfluenceArea() : new InfluenceArea(-20, -20, this.destinationElement.getWidth() + 40, this.destinationElement.getHeight() + 40);
        int n = (int)(this.destinationElement.getX() - (float)this.destinationElement.getWidth() * this.destinationElement.getScale() / 2.0f);
        int n2 = (int)(this.destinationElement.getY() - (float)this.destinationElement.getHeight() * this.destinationElement.getScale());
        int n3 = 0;
        int n4 = 0;
        if (!influenceArea.isExists()) {
            n3 = (int)((float)(n -= 20) + (float)this.destinationElement.getWidth() * this.destinationElement.getScale() + 40.0f);
            n4 = (int)((float)(n2 -= 20) + (float)this.destinationElement.getHeight() * this.destinationElement.getScale() + 40.0f);
        } else {
            n3 = (n += influenceArea.getX()) + influenceArea.getWidth();
            n4 = (n2 += influenceArea.getY()) + influenceArea.getHeight();
        }
        return f > (float)n && f < (float)n3 && f2 > (float)n2 && f2 < (float)n4;
    }

    private List<FunctionalPath> getFullPathList(List<FunctionalPath> list) {
        ArrayList<FunctionalPath> arrayList = new ArrayList<FunctionalPath>();
        while (!list.isEmpty()) {
            FunctionalPath functionalPath = list.get(0);
            list.remove(0);
            FunctionalSide functionalSide = functionalPath.getSides().get(functionalPath.getSides().size() - 1);
            boolean bl = false;
            for (FunctionalSide functionalSide2 : this.sides) {
                FunctionalPath functionalPath2;
                if (functionalSide2.getStartNode() != functionalSide.getEndNode() || functionalSide2.getEndNode() == functionalSide.getStartNode() || (functionalPath2 = functionalPath.newFunctionalPath(functionalSide2.getLenght(), 0.0f, functionalSide2)) == null) continue;
                list.add(functionalPath2);
                bl = true;
            }
            if (bl) continue;
            arrayList.add(functionalPath);
        }
        return arrayList;
    }

    private List<FunctionalSide> getCurrentValidSides() {
        ArrayList<FunctionalSide> arrayList = new ArrayList<FunctionalSide>();
        for (FunctionalSide functionalSide : this.sides) {
            if (functionalSide.getSide() != this.currentSide) continue;
            arrayList.add(functionalSide);
        }
        return arrayList;
    }

    public void updateSpeeds(long l, float f, float f2, float f3) {
        if (this.currentPath != null) {
            Trajectory.Node node = this.getNextNode();
            if (node != null) {
                this.moveInDirectionToTheNode(l, f, f2, f3, node);
            }
        } else {
            this.speedX = 0.0f;
            this.speedY = 0.0f;
        }
    }

    private void moveInDirectionToTheNode(long l, float f, float f2, float f3, Trajectory.Node node) {
        Object object;
        double d = FunctionalTrajectory.getDistance(node.getX(), node.getY(), f, f2);
        float f4 = (float)node.getX() - f;
        float f5 = (float)node.getY() - f2;
        double d2 = Math.abs(f4) + Math.abs(f5);
        double d3 = FunctionalTrajectory.getDistance(this.nearestX, this.nearestY, f, f2);
        if (d3 <= 10.0) {
            this.speedX = 0.0f;
            this.speedY = 0.0f;
            this.currentPath = null;
            this.nearestX = (int)f;
            this.nearestY = (int)f2;
        } else if (d >= (double)(f3 * (float)l / 1000.0f)) {
            f3 = f3 * this.currentSide.getRealLength() / this.currentSide.getLength();
            this.speedX = (float)((double)f4 / d2 * (double)f3);
            this.speedY = (float)((double)f5 / d2 * (double)f3);
        } else {
            object = null;
            for (FunctionalSide functionalSide : this.currentPath) {
                if (functionalSide.getSide() != this.currentSide) continue;
                object = functionalSide;
            }
            if (this.currentPath.indexOf(object) < this.currentPath.size() - 1) {
                this.currentSide = this.currentPath.get(this.currentPath.indexOf(object) + 1).getSide();
            } else {
                this.currentPath = null;
            }
            this.updateSpeeds(l, f, f2, f3);
        }
        object = node;
        Trajectory.Node node2 = this.currentSide.getIDEnd().equals(node.getID()) ? this.trajectory.getNodeForId(this.currentSide.getIDStart()) : this.trajectory.getNodeForId(this.currentSide.getIDEnd());
        this.updateScale(d, node2, (Trajectory.Node)object);
    }

    private void updateScale(double d, Trajectory.Node node, Trajectory.Node node2) {
        this.scale = (float)((double)node.getScale() * d / (double)this.currentSide.getRealLength() + (double)node2.getScale() * (1.0 - d / (double)this.currentSide.getRealLength()));
    }

    private Trajectory.Node getNextNode() {
        FunctionalSide functionalSide = null;
        for (FunctionalSide functionalSide2 : this.currentPath) {
            if (functionalSide2.getSide() != this.currentSide) continue;
            functionalSide = functionalSide2;
        }
        if (functionalSide == null) {
            return null;
        }
        return functionalSide.getEndNode();
    }

    public float getSpeedX() {
        return this.speedX;
    }

    public float getSpeedY() {
        return this.speedY;
    }

    public float getScale() {
        return this.scale;
    }

    public void setDestinationElement(FunctionalElement functionalElement) {
        this.destinationElement = functionalElement;
    }

    public boolean canGetTo() {
        return this.getsTo;
    }

    public Trajectory.Node changeInitialNode(int n, int n2) {
        this.currentSide = null;
        Trajectory.Node object = null;
        float f = Float.MAX_VALUE;
        for (Trajectory.Node object2 : this.trajectory.getNodes()) {
            float f2 = FunctionalTrajectory.getDistance(object2.getX(), object2.getY(), n, n2);
            if (!(f2 < f)) continue;
            object = object2;
            f = f2;
        }
        for (FunctionalSide functionalSide : this.sides) {
            if (functionalSide.getStartNode() != object) continue;
            this.currentSide = functionalSide.getSide();
            Game.getInstance().getFunctionalPlayer().setX(object.getX() + 1);
            Game.getInstance().getFunctionalPlayer().setY(object.getY() + 1);
            Game.getInstance().getFunctionalPlayer().setScale(object.getScale());
            break;
        }
        return object;
    }
}

