/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata;

import es.eucm.eadventure.common.data.chapter.InfluenceArea;
import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalBarrier;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalTrajectory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionalSide {
    private Trajectory.Side side;
    private float length;
    private float realLength;
    private Trajectory.Node startNode;
    private Trajectory.Node endNode;
    public boolean end;
    public float dist;
    public float posX;
    public float posY;
    public boolean getsTo;

    public FunctionalSide(Trajectory.Side side, Trajectory trajectory, boolean bl) {
        this.side = side;
        this.length = side.getLength();
        if (!bl) {
            this.startNode = trajectory.getNodeForId(side.getIDStart());
            this.endNode = trajectory.getNodeForId(side.getIDEnd());
        } else {
            this.startNode = trajectory.getNodeForId(side.getIDEnd());
            this.endNode = trajectory.getNodeForId(side.getIDStart());
        }
        double d = this.endNode.getX() - this.startNode.getX();
        double d2 = this.endNode.getY() - this.startNode.getY();
        this.realLength = (float)Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0));
    }

    public float getLenght() {
        return this.length;
    }

    public Trajectory.Node getStartNode() {
        return this.startNode;
    }

    public Trajectory.Node getEndNode() {
        return this.endNode;
    }

    public Trajectory.Side getSide() {
        return this.side;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FunctionalSide)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        FunctionalSide functionalSide = (FunctionalSide)object;
        return functionalSide.getStartNode() == this.getStartNode() && functionalSide.getEndNode() == this.getEndNode();
    }

    public void updateMinimunDistance(int n, int n2, FunctionalElement functionalElement, List<FunctionalBarrier> list) {
        this.end = false;
        this.dist = Float.MAX_VALUE;
        this.getsTo = false;
        this.posX = this.startNode.getX();
        this.posY = this.startNode.getY();
        float f = this.startNode.getX();
        float f2 = this.startNode.getY();
        float f3 = this.endNode.getX() - this.startNode.getX();
        float f4 = this.endNode.getY() - this.startNode.getY();
        int n3 = (int)(Math.abs(f3) > Math.abs(f4) ? Math.abs(f3) : Math.abs(f4));
        for (int i = 0; i < n3 && !this.end; ++i) {
            float f5;
            if (this.inBarrier(f += f3 / (float)n3, f2 += f4 / (float)n3, list)) {
                this.end = true;
                continue;
            }
            if (functionalElement != null && this.inInfluenceArea(f, f2, functionalElement)) {
                this.dist = 0.0f;
                this.posX = f;
                this.posY = f2;
                this.getsTo = true;
                this.end = true;
                continue;
            }
            if (functionalElement != null || !((f5 = FunctionalTrajectory.getDistanceFast(f, f2, n, n2)) < this.dist)) continue;
            this.dist = f5;
            this.posX = f;
            this.posY = f2;
        }
    }

    private boolean inBarrier(float f, float f2, List<FunctionalBarrier> list) {
        boolean bl = false;
        for (FunctionalBarrier functionalBarrier : list) {
            bl = bl || functionalBarrier.isInside(f, f2);
        }
        return bl;
    }

    private boolean inInfluenceArea(float f, float f2, FunctionalElement functionalElement) {
        if (functionalElement == null) {
            return false;
        }
        InfluenceArea influenceArea = functionalElement.getInfluenceArea() != null ? functionalElement.getInfluenceArea() : new InfluenceArea(-20, -20, functionalElement.getWidth() + 40, functionalElement.getHeight() + 40);
        int n = (int)(functionalElement.getX() - (float)functionalElement.getWidth() * functionalElement.getScale() / 2.0f);
        int n2 = (int)(functionalElement.getY() - (float)functionalElement.getHeight() * functionalElement.getScale());
        int n3 = 0;
        int n4 = 0;
        if (!influenceArea.isExists()) {
            n3 = (int)((float)(n -= 20) + (float)functionalElement.getWidth() * functionalElement.getScale() + 40.0f);
            n4 = (int)((float)(n2 -= 20) + (float)functionalElement.getHeight() * functionalElement.getScale() + 40.0f);
        } else {
            n3 = (n += influenceArea.getX()) + influenceArea.getWidth();
            n4 = (n2 += influenceArea.getY()) + influenceArea.getHeight();
        }
        return f > (float)n && f < (float)n3 && f2 > (float)n2 && f2 < (float)n4;
    }

    public float getRealLength() {
        return this.realLength;
    }
}

