/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata;

import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.common.data.chapter.CustomAction;
import es.eucm.eadventure.common.data.chapter.Exit;
import es.eucm.eadventure.common.data.chapter.InfluenceArea;
import es.eucm.eadventure.common.data.chapter.elements.Element;
import es.eucm.eadventure.common.data.chapter.elements.Player;
import es.eucm.eadventure.common.data.chapter.resources.Asset;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.engine.core.control.DebugLog;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.animations.Animation;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.TalkingElement;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalAction;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalCustom;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalCustomInteract;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalDragTo;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalExamine;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalGive;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalGoTo;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalGrab;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalLook;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalNullAction;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalSpeak;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalTalk;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalUse;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalUseWith;
import es.eucm.eadventure.engine.core.data.GameText;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;

public class FunctionalPlayer
extends FunctionalElement
implements TalkingElement {
    public static final float DEFAULT_SPEED = 120.0f;
    public static final float SPEED_TRANSPARENT_MODE = 5000.0f;
    protected float speedX;
    protected float speedY;
    private Player player;
    private Color textFrontColor;
    private Color textBorderColor;
    private Color bubbleBkgColor;
    private Color bubbleBorderColor;
    private Resources resources;
    private Exit targetExit;
    private int currentDirection = -1;
    public List<FunctionalAction> actionPool;
    public List<Animation[]> animationPool;
    private boolean isTransparent = false;
    private float oldScale = -1.0f;
    private Image oldImage = null;
    private Image oldOriginalImage = null;
    private boolean keepShowingGlobal;

    public boolean isTransparent() {
        return this.isTransparent;
    }

    public void setTransparent(boolean bl) {
        this.isTransparent = bl;
    }

    public FunctionalPlayer(Player player) {
        super(0, 0);
        this.player = player;
        this.speedX = 0.0f;
        this.speedY = 0.0f;
        this.layer = -1;
        this.scale = 1.0f;
        this.currentDirection = 2;
        this.resources = this.createResourcesBlock();
        this.actionPool = new ArrayList<FunctionalAction>();
        this.animationPool = new ArrayList<Animation[]>();
        this.animationPool.add(this.loadPlayerAnimations());
        this.textFrontColor = this.generateColor(player.getTextFrontColor());
        this.textBorderColor = this.generateColor(player.getTextBorderColor());
        this.bubbleBkgColor = this.generateColor(player.getBubbleBkgColor());
        this.bubbleBorderColor = this.generateColor(player.getBubbleBorderColor());
        this.keepShowingGlobal = Game.getInstance().getGameDescriptor().isKeepShowing();
    }

    private Animation[] loadPlayerAnimations() {
        MultimediaManager multimediaManager = MultimediaManager.getInstance();
        Animation[] animationArray = new Animation[4];
        animationArray[2] = this.resources.getAssetPath("standright") != null && !this.resources.getAssetPath("standright").equals("assets/special/EmptyAnimation") && !this.resources.getAssetPath("standright").equals("assets/special/EmptyAnimation.eaa") ? multimediaManager.loadAnimation(this.resources.getAssetPath("standright"), false, 2) : multimediaManager.loadAnimation(this.resources.getAssetPath("standleft"), true, 2);
        animationArray[3] = this.resources.getAssetPath("standleft") != null && !this.resources.getAssetPath("standleft").equals("assets/special/EmptyAnimation") && !this.resources.getAssetPath("standleft").equals("assets/special/EmptyAnimation.eaa") ? multimediaManager.loadAnimation(this.resources.getAssetPath("standleft"), false, 2) : multimediaManager.loadAnimation(this.resources.getAssetPath("standright"), true, 2);
        animationArray[0] = multimediaManager.loadAnimation(this.resources.getAssetPath("standup"), false, 2);
        animationArray[1] = multimediaManager.loadAnimation(this.resources.getAssetPath("standdown"), false, 2);
        return animationArray;
    }

    public boolean isAlwaysSynthesizer() {
        return this.player.isAlwaysSynthesizer();
    }

    public String getPlayerVoice() {
        return this.player.getVoice();
    }

    public void updateResources() {
        Resources resources = this.createResourcesBlock();
        if (this.resources != resources) {
            this.resources = resources;
            MultimediaManager.getInstance().flushImagePool(2);
            this.animationPool.clear();
            this.animationPool.add(this.loadPlayerAnimations());
        }
    }

    public Element getElement() {
        return this.player;
    }

    public int getWidth() {
        return this.getCurrentAnimation().getImage().getWidth(null);
    }

    public int getHeight() {
        return this.getCurrentAnimation().getImage().getHeight(null);
    }

    public void addAction(FunctionalAction functionalAction) {
        this.actionPool.add(functionalAction);
    }

    public void cancelActions() {
        this.getCurrentAction().stop();
        this.actionPool.clear();
        this.cancelAnimations();
    }

    public FunctionalAction getCurrentAction() {
        if (this.actionPool.size() > 0) {
            return this.actionPool.get(this.actionPool.size() - 1);
        }
        return new FunctionalNullAction();
    }

    public void popAction() {
        if (this.actionPool.size() > 0) {
            this.actionPool.remove(this.actionPool.size() - 1);
        }
    }

    public void setAnimation(Animation[] animationArray, int n) {
        if (n != -1) {
            this.animationPool.add(animationArray);
        } else {
            if (this.animationPool.size() > 1) {
                this.animationPool.remove(this.animationPool.size() - 1);
            }
            this.animationPool.add(animationArray);
        }
    }

    public void popAnimation() {
        if (this.animationPool.size() > 1) {
            this.animationPool.remove(this.animationPool.size() - 1);
        }
    }

    public Animation getCurrentAnimation() {
        if (this.currentDirection >= 0 && this.currentDirection < 4) {
            return this.animationPool.get(this.animationPool.size() - 1)[this.currentDirection];
        }
        return this.animationPool.get(this.animationPool.size() - 1)[0];
    }

    public void cancelAnimations() {
        if (this.animationPool.size() > 0) {
            Animation[] animationArray = this.animationPool.get(0);
            this.animationPool.clear();
            this.animationPool.add(animationArray);
        }
    }

    public void performActionInElement(FunctionalElement functionalElement) {
        Game game = Game.getInstance();
        int n = Game.getInstance().getActionManager().getActionSelected();
        if (n == 0) {
            this.addAction(new FunctionalLook(functionalElement));
            return;
        }
        FunctionalAction functionalAction = new FunctionalNullAction();
        switch (n) {
            case 3: {
                this.cancelActions();
                functionalAction = new FunctionalExamine(null, functionalElement);
                break;
            }
            case 5: {
                if (functionalElement.canPerform(n)) {
                    if (functionalElement.isInInventory()) {
                        this.cancelActions();
                        functionalAction = new FunctionalGive(null, functionalElement);
                        game.getActionManager().setActionSelected(8);
                        break;
                    }
                    if (this.player.isAlwaysSynthesizer().booleanValue()) {
                        this.speakWithFreeTTS(GameText.getTextGiveObjectNotInventory(), this.player.getVoice());
                        break;
                    }
                    this.speak(GameText.getTextGiveObjectNotInventory(), this.keepShowingGlobal);
                    break;
                }
                if (this.player.isAlwaysSynthesizer().booleanValue()) {
                    this.speakWithFreeTTS(GameText.getTextGiveNPC(), this.player.getVoice());
                    break;
                }
                this.speak(GameText.getTextGiveNPC(), this.keepShowingGlobal);
                break;
            }
            case 8: {
                if (functionalElement.canPerform(n)) {
                    if (this.getCurrentAction().getType() != 5) break;
                    functionalAction = this.getCurrentAction();
                    this.popAction();
                    ((FunctionalGive)functionalAction).setAnotherElement(functionalElement);
                    break;
                }
                this.popAction();
                this.speak(GameText.getTextGiveCannot(), this.keepShowingGlobal);
                break;
            }
            case 1: {
                this.cancelActions();
                if (functionalElement.canPerform(n)) {
                    if (!functionalElement.isInInventory()) {
                        functionalAction = new FunctionalGrab(null, functionalElement);
                        break;
                    }
                    this.speak(GameText.getTextGrabObjectInventory(), this.keepShowingGlobal);
                    break;
                }
                this.speak(GameText.getTextGrabNPC(), this.keepShowingGlobal);
                break;
            }
            case 2: {
                this.cancelActions();
                if (functionalElement.canPerform(n)) {
                    functionalAction = new FunctionalTalk(null, functionalElement);
                    break;
                }
                this.speak(GameText.getTextTalkObject(), this.keepShowingGlobal);
                break;
            }
            case 4: {
                if (functionalElement.canPerform(n)) {
                    if (functionalElement.canBeUsedAlone()) {
                        this.cancelActions();
                        functionalAction = new FunctionalUse(functionalElement);
                        break;
                    }
                    this.cancelActions();
                    functionalAction = new FunctionalUseWith(null, functionalElement);
                    game.getActionManager().setActionSelected(7);
                    break;
                }
                this.popAction();
                this.speak(GameText.getTextUseNPC(), this.keepShowingGlobal);
                break;
            }
            case 11: {
                if (this.getCurrentAction().getType() == 8) {
                    functionalAction = this.getCurrentAction();
                    this.popAction();
                    if (functionalAction == null || functionalElement == null || !(functionalAction instanceof FunctionalDragTo)) break;
                    ((FunctionalDragTo)functionalAction).setAnotherElement(functionalElement);
                    break;
                }
                functionalAction = new FunctionalDragTo(functionalElement);
                game.getActionManager().setActionSelected(11);
                break;
            }
            case 9: {
                functionalAction = new FunctionalCustom(functionalElement, Game.getInstance().getActionManager().getCustomActionName());
                break;
            }
            case 10: {
                if (this.getCurrentAction().getType() == 6) {
                    functionalAction = this.getCurrentAction();
                    this.popAction();
                    if (functionalAction == null || functionalElement == null || !(functionalAction instanceof FunctionalCustomInteract)) break;
                    ((FunctionalCustomInteract)functionalAction).setAnotherElement(functionalElement);
                    break;
                }
                functionalAction = new FunctionalCustomInteract(functionalElement, Game.getInstance().getActionManager().getCustomActionName());
                break;
            }
            case 7: {
                if (functionalElement.canPerform(n)) {
                    if (this.getCurrentAction().getType() != 7) break;
                    functionalAction = this.getCurrentAction();
                    this.popAction();
                    ((FunctionalUseWith)functionalAction).setAnotherElement(functionalElement);
                    break;
                }
                this.popAction();
                this.speak(GameText.getTextUseNPC(), this.keepShowingGlobal);
            }
        }
        if (functionalAction.isNeedsGoTo() && !this.isTransparent) {
            FunctionalGoTo functionalGoTo = new FunctionalGoTo(null, (int)functionalElement.getX(), (int)functionalElement.getY(), this, functionalElement);
            if (functionalGoTo.canGetTo()) {
                this.addAction(functionalAction);
                functionalGoTo.setKeepDistance(functionalAction.getKeepDistance());
                this.addAction(functionalGoTo);
            }
            return;
        }
        this.addAction(functionalAction);
    }

    public void draw() {
        if (!this.isTransparent) {
            Image image = this.getCurrentAnimation().getImage();
            int n = (int)(this.x - (float)image.getWidth(null) * this.scale / 2.0f - (float)Game.getInstance().getFunctionalScene().getOffsetX());
            int n2 = (int)(this.y - (float)image.getHeight(null) * this.scale);
            if (image == this.oldOriginalImage && this.scale == this.oldScale) {
                image = this.oldImage;
            } else if (this.scale != 1.0f) {
                this.oldOriginalImage = image;
                image = GUI.getInstance().getGraphicsConfiguration().createCompatibleImage(Math.round((float)image.getWidth(null) * this.scale), Math.round((float)image.getHeight(null) * this.scale), 3);
                ((Graphics2D)image.getGraphics()).drawImage(this.oldOriginalImage, AffineTransform.getScaleInstance(this.scale, this.scale), null);
            } else {
                this.oldOriginalImage = image;
            }
            this.oldScale = this.scale;
            this.oldImage = image;
            if (this.layer == -1 || this.layer == -2) {
                GUI.getInstance().addPlayerToDraw(image, n, n2, Math.round(this.y), Math.round(this.y));
            } else {
                GUI.getInstance().addElementToDraw(image, n, n2, this.layer, Math.round(this.y), null, null);
            }
        }
        if (this.getCurrentAction().isStarted() && !this.getCurrentAction().isFinished()) {
            this.getCurrentAction().drawAditionalElements();
        }
    }

    public void update(long l) {
        while (this.getCurrentAction().isFinished()) {
            this.popAction();
        }
        if (!this.getCurrentAction().isStarted()) {
            this.getCurrentAction().start(this);
        } else {
            this.getCurrentAction().update(l);
        }
        this.getCurrentAnimation().update(l);
    }

    public boolean isPointInside(float f, float f2) {
        return this.x - (float)(this.getWidth() / 2) < f && f < this.x + (float)(this.getWidth() / 2) && this.y - (float)this.getHeight() < f2 && f2 < this.y;
    }

    public boolean canPerform(int n) {
        boolean bl = false;
        switch (n) {
            case 0: 
            case 3: 
            case 9: {
                bl = true;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                bl = false;
            }
        }
        return bl;
    }

    public void speak(String string, boolean bl) {
        if (string != null) {
            DebugLog.player("Player says " + string);
            FunctionalSpeak functionalSpeak = new FunctionalSpeak(null, string, bl);
            this.addAction(functionalSpeak);
        }
    }

    public void speak(String string) {
        this.speak(string, false);
    }

    public void speak(String string, String string2, boolean bl) {
        DebugLog.player("Player says " + string + " with audio");
        FunctionalSpeak functionalSpeak = new FunctionalSpeak(null, string, string2, bl);
        this.addAction(functionalSpeak);
    }

    public void speak(String string, String string2) {
        this.speak(string, string2, false);
    }

    public void speakWithFreeTTS(String string, String string2, boolean bl) {
        if (string != null) {
            DebugLog.player("Player speaks with text-to-speech");
            FunctionalSpeak functionalSpeak = new FunctionalSpeak(null, string, bl);
            if (string2 != null && !string2.equals("")) {
                functionalSpeak.setSpeakFreeTTS(string, string2);
            }
            this.addAction(functionalSpeak);
        }
    }

    public void speakWithFreeTTS(String string, String string2) {
        this.speakWithFreeTTS(string, string2, false);
    }

    public void stopTalking() {
        if (this.getCurrentAction().getType() == 2) {
            this.getCurrentAction().stop();
            this.cancelActions();
        }
    }

    public boolean isTalking() {
        return this.getCurrentAction().getType() == 2;
    }

    public boolean isWalking() {
        return this.getCurrentAction().getType() == 6;
    }

    public void setTargetExit(Exit exit) {
        this.targetExit = exit;
    }

    public Exit getTargetExit() {
        return this.targetExit;
    }

    public void setDirection(int n) {
        this.currentDirection = n;
    }

    public int getDirection() {
        return this.currentDirection;
    }

    public float getSpeedX() {
        return this.speedX;
    }

    public void setSpeedX(float f) {
        this.speedX = !this.isTransparent ? f : (f < 0.0f ? -5000.0f : (f > 0.0f ? 5000.0f : 0.0f));
    }

    public float getSpeedY() {
        return this.speedY;
    }

    public void setSpeedY(float f) {
        this.speedY = f;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Color getTextFrontColor() {
        return this.textFrontColor;
    }

    public Color getTextBorderColor() {
        return this.textBorderColor;
    }

    public Resources getResources() {
        return this.resources;
    }

    public Resources createResourcesBlock() {
        Resources resources = null;
        for (int i = 0; i < this.player.getResources().size() && resources == null; ++i) {
            if (!new FunctionalConditions(this.player.getResources().get(i).getConditions()).allConditionsOk()) continue;
            resources = this.player.getResources().get(i);
        }
        if (resources == null) {
            resources = new Resources();
            resources.addAsset(new Asset("speakdown", "gui/defaultassets/NRB_animation_01.png"));
            resources.addAsset(new Asset("speakup", "gui/defaultassets/NRB_animation_01.png"));
            resources.addAsset(new Asset("speakright", "gui/defaultassets/NRB_animation_01.png"));
            resources.addAsset(new Asset("walkdown", "gui/defaultassets/NRB_animation_01.png"));
            resources.addAsset(new Asset("walkup", "gui/defaultassets/NRB_animation_01.png"));
            resources.addAsset(new Asset("walkright", "gui/defaultassets/NRB_animation_01.png"));
            resources.addAsset(new Asset("useright", "gui/defaultassets/NRB_animation_01.png"));
            resources.addAsset(new Asset("standup", "gui/defaultassets/NRB_animation_01.png"));
            resources.addAsset(new Asset("standdown", "gui/defaultassets/NRB_animation_01.png"));
            resources.addAsset(new Asset("standright", "gui/defaultassets/NRB_animation_01.png"));
        }
        return resources;
    }

    public Action getFirstValidAction(int n) {
        return null;
    }

    public CustomAction getFirstValidCustomAction(String string) {
        return null;
    }

    public CustomAction getFirstValidCustomInteraction(String string) {
        return null;
    }

    public InfluenceArea getInfluenceArea() {
        return null;
    }

    public Color getBubbleBkgColor() {
        return this.bubbleBkgColor;
    }

    public Color getBubbleBorderColor() {
        return this.bubbleBorderColor;
    }

    public boolean getShowsSpeechBubbles() {
        return this.player.getShowsSpeechBubbles();
    }
}

