/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata;

import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.common.data.chapter.CustomAction;
import es.eucm.eadventure.common.data.chapter.ElementReference;
import es.eucm.eadventure.common.data.chapter.InfluenceArea;
import es.eucm.eadventure.common.data.chapter.elements.Element;
import es.eucm.eadventure.common.data.chapter.elements.Item;
import es.eucm.eadventure.common.data.chapter.resources.Asset;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalNPC;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffects;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class FunctionalItem
extends FunctionalElement {
    protected Resources resources;
    protected Image image;
    private Image icon;
    protected Item item;
    protected InfluenceArea influenceArea;
    private Image oldOriginalImage = null;
    private Image oldImage = null;
    private int width;
    private int height;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private float oldScale = -1.0f;
    private ElementReference reference;

    public FunctionalItem(Item item, ElementReference elementReference) {
        this(item, elementReference.getInfluenceArea(), elementReference.getX(), elementReference.getY());
        this.scale = elementReference.getScale();
        this.layer = elementReference.getLayer();
        this.reference = elementReference;
    }

    protected FunctionalItem(Item item, InfluenceArea influenceArea, int n, int n2) {
        super(n, n2);
        this.item = item;
        this.influenceArea = influenceArea;
        Image image = null;
        this.image = null;
        this.icon = null;
        this.resources = this.createResourcesBlock();
        MultimediaManager multimediaManager = MultimediaManager.getInstance();
        if (this.resources.existAsset("image")) {
            image = multimediaManager.loadImageFromZip(this.resources.getAssetPath("image"), 0);
            this.removeTransparentParts(image);
            image = null;
            Runtime.getRuntime().gc();
        }
        if (this.resources.existAsset("icon")) {
            this.icon = multimediaManager.loadImageFromZip(this.resources.getAssetPath("icon"), 0);
        }
    }

    private void removeTransparentParts(Image image) {
        this.x1 = image.getWidth(null);
        this.y1 = image.getHeight(null);
        this.x2 = 0;
        this.y2 = 0;
        this.width = this.x1;
        this.height = this.y1;
        for (int i = 0; i < image.getWidth(null); ++i) {
            boolean bl = true;
            for (int j = 0; j < image.getHeight(null); ++j) {
                boolean bl2 = true;
                BufferedImage bufferedImage = (BufferedImage)image;
                int n = bufferedImage.getRGB(i, j) >>> 24;
                if (n <= 0) continue;
                if (bl) {
                    this.x1 = Math.min(this.x1, i);
                }
                if (bl2) {
                    this.y1 = Math.min(this.y1, j);
                }
                bl = false;
                bl2 = false;
                this.x2 = Math.max(this.x2, i);
                this.y2 = Math.max(this.y2, j);
            }
        }
        this.image = GUI.getInstance().getGraphicsConfiguration().createCompatibleImage(this.x2 - this.x1, this.y2 - this.y1, 3);
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        graphics2D.drawImage(image, 0, 0, this.x2 - this.x1, this.y2 - this.y1, this.x1, this.y1, this.x2, this.y2, null);
        graphics2D.dispose();
    }

    public FunctionalItem(Item item, InfluenceArea influenceArea) {
        this(item, influenceArea, 0, 0);
    }

    public void updateResources() {
        Resources resources = this.createResourcesBlock();
        if (this.resources != resources) {
            this.resources = resources;
            MultimediaManager multimediaManager = MultimediaManager.getInstance();
            Image image = null;
            if (this.resources.existAsset("image")) {
                image = multimediaManager.loadImageFromZip(this.resources.getAssetPath("image"), 0);
                this.removeTransparentParts(image);
                image = null;
                Runtime.getRuntime().gc();
            }
            if (this.resources.existAsset("icon")) {
                this.icon = multimediaManager.loadImageFromZip(this.resources.getAssetPath("icon"), 0);
            }
        }
    }

    public Item getItem() {
        return this.item;
    }

    public Image getIconImage() {
        return this.icon;
    }

    public Element getElement() {
        return this.item;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void update(long l) {
    }

    public void draw() {
        int n = Math.round(this.x + (float)this.x1 * this.scale - (float)this.getWidth() * this.scale / 2.0f) - Game.getInstance().getFunctionalScene().getOffsetX();
        int n2 = Math.round(this.y + (float)this.y1 * this.scale - (float)this.getHeight() * this.scale);
        if (this.scale != 1.0f) {
            Image image;
            if (this.image == this.oldOriginalImage && this.scale == this.oldScale) {
                image = this.oldImage;
            } else {
                image = GUI.getInstance().getGraphicsConfiguration().createCompatibleImage(Math.round((float)this.image.getWidth(null) * this.scale), Math.round((float)this.image.getHeight(null) * this.scale), 3);
                ((Graphics2D)image.getGraphics()).drawImage(this.image, AffineTransform.getScaleInstance(this.scale, this.scale), null);
                this.oldImage = image;
                this.oldOriginalImage = this.image;
                this.oldScale = this.scale;
            }
            if (this.layer == -1) {
                GUI.getInstance().addElementToDraw(image, n, n2, Math.round(this.y), Math.round(this.y), this.highlight, this);
            } else {
                GUI.getInstance().addElementToDraw(image, n, n2, this.layer, Math.round(this.y), this.highlight, this);
            }
        } else if (this.layer == -1) {
            GUI.getInstance().addElementToDraw(this.image, n, n2, Math.round(this.y), Math.round(this.y), this.highlight, this);
        } else {
            GUI.getInstance().addElementToDraw(this.image, n, n2, this.layer, Math.round(this.y), this.highlight, this);
        }
    }

    public boolean isPointInside(float f, float f2) {
        boolean bl = false;
        int n = (int)(f - (this.x - (float)this.getWidth() * this.scale / 2.0f));
        int n2 = (int)(f2 - (this.y - (float)this.getHeight() * this.scale));
        if ((float)n < (float)this.x1 * this.scale || (float)n2 < (float)this.y1 * this.scale || (float)n >= (float)this.x2 * this.scale || (float)n2 >= (float)this.y2 * this.scale) {
            return false;
        }
        if ((n -= (int)((float)this.x1 * this.scale)) >= 0 && (float)n < (float)(this.x2 - this.x1) * this.scale && (n2 -= (int)((float)this.y1 * this.scale)) >= 0 && (float)n2 < (float)(this.y2 - this.y1) * this.scale) {
            BufferedImage bufferedImage = (BufferedImage)this.image;
            int n3 = bufferedImage.getRGB((int)((float)n / this.scale), (int)((float)n2 / this.scale)) >>> 24;
            bl = n3 > 128;
        }
        return bl;
    }

    public boolean canPerform(int n) {
        boolean bl = false;
        switch (n) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                bl = true;
                break;
            }
            case 2: 
            case 8: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isInInventory() {
        return Game.getInstance().getItemSummary().isItemGrabbed(this.item.getId());
    }

    public boolean examine() {
        Action action;
        int n;
        boolean bl = false;
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 0 || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            FunctionalEffects.storeAllEffects(action.getEffects());
            bl = true;
        }
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 0 || !action.isActivatedNotEffects()) continue;
            FunctionalEffects.storeAllEffects(action.getNotEffects());
            bl = true;
        }
        return bl;
    }

    public boolean canBeUsedAlone() {
        boolean bl;
        boolean bl2;
        boolean bl3 = false;
        Action action = this.getFirstValidAction(1);
        Action action2 = this.getFirstValidAction(3);
        Action action3 = this.getFirstValidAction(2);
        if (action == null) {
            bl2 = true;
        } else {
            boolean bl4 = bl2 = !action.isConditionsAreMeet();
        }
        if (action2 == null) {
            bl = true;
        } else {
            boolean bl5 = bl = !action2.isConditionsAreMeet();
        }
        boolean bl6 = action3 == null ? true : !action3.isConditionsAreMeet();
        boolean bl7 = bl2 && bl && bl6;
        for (int i = 0; i < this.item.getActions().size() && !bl3; ++i) {
            Action action4 = this.item.getAction(i);
            if (action4.getType() != 4) continue;
            if (new FunctionalConditions(action4.getConditions()).allConditionsOk()) {
                bl3 = true;
                continue;
            }
            if (!action4.isActivatedNotEffects() || !bl7) continue;
            bl3 = true;
        }
        return bl3;
    }

    public boolean canBeDragged() {
        boolean bl = false;
        for (int i = 0; i < this.item.getActions().size() && !bl; ++i) {
            Action action = this.item.getAction(i);
            if (action.getType() != 8) continue;
            if (new FunctionalConditions(action.getConditions()).allConditionsOk()) {
                bl = true;
                continue;
            }
            if (!action.isActivatedNotEffects()) continue;
            bl = true;
        }
        return bl;
    }

    public Action getFirstValidAction(int n) {
        for (Action action : this.item.getActions()) {
            if (action.getType() != n || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            action.setConditionsAreMeet(true);
            return action;
        }
        for (Action action : this.item.getActions()) {
            if (action.getType() != n || !action.isActivatedNotEffects()) continue;
            action.setConditionsAreMeet(false);
            return action;
        }
        return null;
    }

    public CustomAction getFirstValidCustomAction(String string) {
        for (Action action : this.item.getActions()) {
            if (action.getType() != 5 || !((CustomAction)action).getName().equals(string) || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            return (CustomAction)action;
        }
        for (Action action : this.item.getActions()) {
            if (action.getType() != 5 || !((CustomAction)action).getName().equals(string) || !action.isActivatedNotEffects()) continue;
            return (CustomAction)action;
        }
        return null;
    }

    public CustomAction getFirstValidCustomInteraction(String string) {
        for (Action action : this.item.getActions()) {
            if (action.getType() != 6 || !((CustomAction)action).getName().endsWith(string) || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            return (CustomAction)action;
        }
        for (Action action : this.item.getActions()) {
            if (action.getType() != 6 || !((CustomAction)action).getName().endsWith(string) || !action.isActivatedNotEffects()) continue;
            return (CustomAction)action;
        }
        return null;
    }

    public boolean grab() {
        Action action;
        int n;
        boolean bl = false;
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 1 || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            if (!action.getEffects().hasCancelAction()) {
                Game.getInstance().grabItem(this.item.getId());
            }
            FunctionalEffects.storeAllEffects(action.getEffects());
            bl = true;
        }
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 1 || !action.isActivatedNotEffects()) continue;
            FunctionalEffects.storeAllEffects(action.getNotEffects());
            bl = true;
        }
        return bl;
    }

    public boolean use() {
        Action action;
        int n;
        boolean bl = false;
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 4 || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            FunctionalEffects.storeAllEffects(action.getEffects());
            bl = true;
        }
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 4 || !action.isActivatedNotEffects()) continue;
            FunctionalEffects.storeAllEffects(action.getNotEffects());
            bl = true;
        }
        return bl;
    }

    public boolean custom(String string) {
        Action action;
        int n;
        boolean bl = false;
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 5 || !((CustomAction)action).getName().equals(string) || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            FunctionalEffects.storeAllEffects(action.getEffects());
            bl = true;
        }
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 5 || !((CustomAction)action).getName().equals(string) || !action.isActivatedNotEffects()) continue;
            FunctionalEffects.storeAllEffects(action.getNotEffects());
            bl = true;
        }
        return bl;
    }

    public boolean useWith(FunctionalItem functionalItem) {
        Action action;
        int n;
        boolean bl = false;
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 3 || !action.getTargetId().equals(functionalItem.getItem().getId()) || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            FunctionalEffects.storeAllEffects(action.getEffects());
            bl = true;
        }
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 3 || !action.getTargetId().equals(functionalItem.getItem().getId()) || !action.isActivatedNotEffects()) continue;
            FunctionalEffects.storeAllEffects(action.getNotEffects());
            bl = true;
        }
        return bl;
    }

    public boolean dragTo(FunctionalItem functionalItem) {
        Action action;
        int n;
        boolean bl = false;
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 8 || !action.getTargetId().equals(functionalItem.getItem().getId()) || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            FunctionalEffects.storeAllEffects(action.getEffects());
            bl = true;
        }
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 8 || !action.getTargetId().equals(functionalItem.getItem().getId()) || !action.isActivatedNotEffects()) continue;
            FunctionalEffects.storeAllEffects(action.getNotEffects());
            bl = true;
        }
        return bl;
    }

    public boolean dragTo(FunctionalNPC functionalNPC) {
        Action action;
        int n;
        boolean bl = false;
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 8 || !action.getTargetId().equals(functionalNPC.getNPC().getId()) || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            FunctionalEffects.storeAllEffects(action.getEffects());
            bl = true;
        }
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 8 || !action.getTargetId().equals(functionalNPC.getNPC().getId()) || !action.isActivatedNotEffects()) continue;
            FunctionalEffects.storeAllEffects(action.getNotEffects());
            bl = true;
        }
        return bl;
    }

    public boolean customInteract(String string, FunctionalItem functionalItem) {
        Action action;
        int n;
        boolean bl = false;
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 6 || !((CustomAction)action).getName().equals(string) || action.getTargetId() == null || !action.getTargetId().equals(functionalItem.getItem().getId()) || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            FunctionalEffects.storeAllEffects(action.getEffects());
            bl = true;
        }
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 6 || !((CustomAction)action).getName().equals(string) || action.getTargetId() == null || !action.getTargetId().equals(functionalItem.getItem().getId()) || !action.isActivatedNotEffects()) continue;
            FunctionalEffects.storeAllEffects(action.getNotEffects());
            bl = true;
        }
        return bl;
    }

    public boolean customInteract(String string, FunctionalNPC functionalNPC) {
        Action action;
        int n;
        boolean bl = false;
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 6 || !action.getTargetId().equals(functionalNPC.getNPC().getId()) || !((CustomAction)action).getName().equals(string) || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            FunctionalEffects.storeAllEffects(action.getEffects());
            bl = true;
        }
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 6 || !action.getTargetId().equals(functionalNPC.getNPC().getId()) || !((CustomAction)action).getName().equals(string) || !action.isActivatedNotEffects()) continue;
            FunctionalEffects.storeAllEffects(action.getNotEffects());
            bl = true;
        }
        return bl;
    }

    public boolean giveTo(FunctionalNPC functionalNPC) {
        Action action;
        int n;
        boolean bl = false;
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 2 || !action.getTargetId().equals(functionalNPC.getElement().getId()) || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            if (!action.getEffects().hasCancelAction()) {
                Game.getInstance().consumeItem(this.item.getId());
            }
            FunctionalEffects.storeAllEffects(action.getEffects());
            bl = true;
        }
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 2 || !action.getTargetId().equals(functionalNPC.getElement().getId()) || !action.isActivatedNotEffects()) continue;
            FunctionalEffects.storeAllEffects(action.getNotEffects());
            bl = true;
        }
        return bl;
    }

    public Resources createResourcesBlock() {
        Resources resources = null;
        for (int i = 0; i < this.item.getResources().size() && resources == null; ++i) {
            if (!new FunctionalConditions(this.item.getResources().get(i).getConditions()).allConditionsOk()) continue;
            resources = this.item.getResources().get(i);
        }
        if (resources == null) {
            resources = new Resources();
            resources.addAsset(new Asset("icon", "gui/defaultassets/NRB_icon.png"));
            resources.addAsset(new Asset("image", "gui/defaultassets/NRB_image.png"));
        }
        return resources;
    }

    public InfluenceArea getInfluenceArea() {
        return this.influenceArea;
    }

    public ElementReference getReference() {
        return this.reference;
    }
}

