/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.book.BookPage;
import es.eucm.eadventure.common.gui.BookEditorPane;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalStyledBook;
import es.eucm.eadventure.engine.core.gui.editorpane.BookEditorPaneEngine;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import es.eucm.eadventure.engine.resourcehandler.ResourceHandler;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.rtf.RTFEditorKit;

public class FunctionalBookPage
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BookPage bookPage;
    private boolean isValid;
    private Image background;
    private Image currentArrowLeft;
    private Image currentArrowRight;
    private Point previousPage;
    private Point nextPage;
    private Image image;
    private FunctionalStyledBook fBook;
    private BookEditorPane editorPane;
    private boolean htmlToImage = false;

    public FunctionalBookPage(Image image) {
        this.background = image;
    }

    public FunctionalBookPage(BookPage bookPage, FunctionalStyledBook functionalStyledBook, Image image, Image image2, Image image3, Point point, Point point2, boolean bl) {
        this.editorPane = new BookEditorPaneEngine(bookPage.getUri());
        this.isValid = true;
        this.bookPage = bookPage;
        this.fBook = functionalStyledBook;
        this.background = image;
        this.currentArrowLeft = image2;
        this.currentArrowRight = image3;
        this.previousPage = point;
        this.nextPage = point2;
        FunctionalBookMouseListener functionalBookMouseListener = new FunctionalBookMouseListener();
        this.addMouseListener(functionalBookMouseListener);
        this.addMouseMotionListener(functionalBookMouseListener);
        switch (bookPage.getType()) {
            case 0: {
                this.isValid = this.createURLPage(bl);
                break;
            }
            case 1: {
                this.isValid = this.createResourcePage();
                break;
            }
            case 2: {
                this.isValid = this.createImagePage();
                break;
            }
            default: {
                this.isValid = false;
            }
        }
        if (this.editorPane != null) {
            FunctionalBookMouseListener functionalBookMouseListener2 = new FunctionalBookMouseListener();
            this.editorPane.addMouseListener(functionalBookMouseListener2);
            this.editorPane.addMouseMotionListener(functionalBookMouseListener2);
            this.editorPane.setOpaque(false);
            this.editorPane.setEditable(false);
            this.setOpaque(false);
            this.setLayout(null);
        }
    }

    private boolean createImagePage() {
        this.image = MultimediaManager.getInstance().loadImageFromZip(this.bookPage.getUri(), 0);
        return this.image != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createResourcePage() {
        this.image = MultimediaManager.getInstance().loadImageFromZip("assets/image/" + this.bookPage.getImageName() + ".png", 0);
        if (this.image == null) {
            String string = this.bookPage.getUri();
            String string2 = string.substring(string.lastIndexOf(46) + 1, string.length()).toLowerCase();
            if (string2.equals("html") || string2.equals("htm") || string2.equals("rtf")) {
                StringBuffer stringBuffer = new StringBuffer();
                InputStream inputStream = ResourceHandler.getInstance().getResourceAsStreamFromZip(string);
                try {
                    int n;
                    while ((n = inputStream.read()) != -1) {
                        stringBuffer.append((char)n);
                    }
                }
                catch (IOException iOException) {
                    this.isValid = false;
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            this.isValid = false;
                        }
                    }
                }
                if (string2.equals("html") || string2.equals("htm")) {
                    this.editorPane.setContentType("text/html");
                    this.editorPane.setText(stringBuffer.toString());
                    URL uRL = ResourceHandler.getInstance().getResourceAsURL(string);
                    try {
                        this.editorPane.setDocumentBase(new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                } else {
                    this.editorPane.setContentType("text/rtf");
                    this.editorPane.setText(stringBuffer.toString());
                }
                this.isValid = true;
            }
        } else {
            this.htmlToImage = true;
        }
        return this.isValid;
    }

    private boolean createURLPage(boolean bl) {
        URL uRL = null;
        try {
            uRL = new URL(this.bookPage.getUri());
            uRL.openStream().close();
        }
        catch (Exception exception) {
            this.isValid = false;
        }
        try {
            if (this.isValid) {
                this.editorPane.setPage(uRL);
                this.editorPane.setEditable(false);
                if (bl) {
                    this.editorPane.addHyperlinkListener(new BookHyperlinkListener());
                }
                if (!(this.editorPane.getEditorKit() instanceof HTMLEditorKit) && !(this.editorPane.getEditorKit() instanceof RTFEditorKit)) {
                    this.isValid = false;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.isValid;
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.background, 0, 0, this.background.getWidth(null), this.background.getHeight(null), null);
        if (this.image != null) {
            if (this.htmlToImage) {
                graphics.drawImage(this.image, 0, 0, null);
            } else {
                graphics.drawImage(this.image, this.bookPage.getMargin(), this.bookPage.getMarginTop(), null);
            }
        } else if (this.editorPane != null) {
            this.editorPane.paint(graphics, this.bookPage.getMargin(), this.bookPage.getMarginTop(), this.getWidth() - this.bookPage.getMarginEnd(), this.getHeight() - this.bookPage.getMarginBottom());
        }
        if (this.currentArrowLeft != null && this.currentArrowRight != null) {
            if (!this.fBook.isInFirstPage()) {
                graphics.drawImage(this.currentArrowLeft, this.previousPage.x, this.previousPage.y, this.currentArrowLeft.getWidth(null), this.currentArrowLeft.getHeight(null), null);
            }
            graphics.drawImage(this.currentArrowRight, this.nextPage.x, this.nextPage.y, this.currentArrowRight.getWidth(null), this.currentArrowRight.getHeight(null), null);
        }
        super.paint(graphics);
    }

    public BookPage getBookPage() {
        return this.bookPage;
    }

    public void setBookPage(BookPage bookPage) {
        this.bookPage = bookPage;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean bl) {
        this.isValid = bl;
    }

    public void setCurrentArrowLeft(Image image) {
        this.currentArrowLeft = image;
        this.repaint();
    }

    public void setCurrentArrowRight(Image image) {
        this.currentArrowRight = image;
        this.repaint();
    }

    private class BookHyperlinkListener
    implements HyperlinkListener {
        private BookHyperlinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                    HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                    hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                } else {
                    try {
                        jEditorPane.setPage(hyperlinkEvent.getURL());
                    }
                    catch (Exception exception) {
                        ReportDialog.GenerateErrorReport(exception, Game.getInstance().isFromEditor(), "UNKNOWERROR");
                    }
                }
            }
        }
    }

    private class FunctionalBookMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private FunctionalBookMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = this.createMouseEvent(mouseEvent);
            Game.getInstance().mouseClicked(mouseEvent2);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = this.createMouseEvent(mouseEvent);
            Game.getInstance().mouseMoved(mouseEvent2);
        }

        private MouseEvent createMouseEvent(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (mouseEvent.getSource() == FunctionalBookPage.this.editorPane) {
                n += FunctionalBookPage.this.bookPage.getMargin();
                n2 += FunctionalBookPage.this.bookPage.getMarginTop();
            }
            MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n, n2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            return mouseEvent2;
        }
    }
}

