/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.animations;

import es.eucm.eadventure.engine.core.control.animations.ImageSet;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.awt.Image;

public class ImageAnimation
extends ImageSet {
    private static final int TIME_PER_FRAME = 100;
    private long accumulatedAnimationTime = 0L;
    private boolean playingFirstTime = true;

    public synchronized void start() {
        super.start();
        this.accumulatedAnimationTime = 0L;
        this.playingFirstTime = true;
    }

    public boolean isPlayingForFirstTime() {
        return this.playingFirstTime;
    }

    public void update(long l) {
        this.accumulatedAnimationTime += l;
        if (this.imageSet.length > 1) {
            while (this.accumulatedAnimationTime > 100L) {
                this.accumulatedAnimationTime -= 100L;
                ++this.currentFrameIndex;
            }
            if (this.currentFrameIndex >= this.imageSet.length) {
                this.currentFrameIndex %= this.imageSet.length;
                this.playingFirstTime = false;
            }
        } else if (this.accumulatedAnimationTime > 100L) {
            this.playingFirstTime = false;
        }
    }

    protected Image[] getNoAnimationAvailableImageSet() {
        Image[] imageArray = new Image[]{MultimediaManager.getInstance().loadImage("gui/defaultassets/NRB_animation_01.png", 0)};
        return imageArray;
    }
}

