/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.animations;

import es.eucm.eadventure.engine.core.control.animations.Animation;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.awt.Image;

public class FrameAnimation
implements Animation {
    private es.eucm.eadventure.common.data.animation.Animation animation;
    private long accumulatedTime;
    private long previousFrameSoundID;

    public FrameAnimation(es.eucm.eadventure.common.data.animation.Animation animation) {
        this.animation = animation;
        this.accumulatedTime = 0L;
        this.previousFrameSoundID = -1L;
    }

    public Image getImage() {
        Image image = this.animation.getImage(this.accumulatedTime, 0);
        String string = this.animation.getNewSound();
        if (string != null && string != "") {
            if (this.previousFrameSoundID != -1L) {
                MultimediaManager.getInstance().stopPlaying(this.previousFrameSoundID);
            }
            this.previousFrameSoundID = MultimediaManager.getInstance().loadSound(string, false);
            MultimediaManager.getInstance().startPlaying(this.previousFrameSoundID);
        } else if (!MultimediaManager.getInstance().isPlaying(this.previousFrameSoundID)) {
            this.previousFrameSoundID = -1L;
        }
        return image;
    }

    public boolean isPlayingForFirstTime() {
        return !this.animation.finishedFirstTime(this.accumulatedTime);
    }

    public void start() {
        this.accumulatedTime = 0L;
    }

    public void update(long l) {
        this.accumulatedTime += l;
    }

    public boolean nextImage() {
        boolean bl = false;
        this.accumulatedTime = this.animation.skipFrame(this.accumulatedTime);
        if (this.accumulatedTime >= this.animation.getTotalTime()) {
            this.accumulatedTime %= this.animation.getTotalTime();
            bl = true;
        }
        return bl;
    }

    public void setAnimation(es.eucm.eadventure.common.data.animation.Animation animation) {
        this.animation = animation;
    }

    public void setMirror(boolean bl) {
        this.animation.setMirror(bl);
    }

    public void setFullscreen(boolean bl) {
        this.animation.setFullscreen(bl);
    }
}

