/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control;

import es.eucm.eadventure.common.data.chapter.Timer;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.engine.core.control.DebugLog;
import es.eucm.eadventure.engine.core.control.TimerEventListener;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.data.SaveTimer;
import es.eucm.eadventure.engine.core.gui.GUI;
import java.awt.Color;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerManager {
    private static int ID = 0;
    private static TimerManager singleton = new TimerManager();
    private HashMap<Integer, FunctionalTimer> timers = new HashMap();

    public static TimerManager getInstance() {
        return singleton;
    }

    public TimerManager() {
        ID = 0;
    }

    public void reset() {
        if (this.timers != null) {
            this.timers.clear();
        }
        this.timers = new HashMap();
        ID = 0;
    }

    public int addTimer(Conditions conditions, Conditions conditions2, boolean bl, TimerEventListener timerEventListener) {
        FunctionalTimer functionalTimer = new FunctionalTimer(conditions, conditions2, bl, timerEventListener);
        this.timers.put(new Integer(ID), functionalTimer);
        return ++ID - 1;
    }

    public int addTimer(Timer timer, TimerEventListener timerEventListener, long l) {
        FunctionalTimer functionalTimer = new FunctionalTimer(timer.getInitCond(), timer.getEndCond(), timerEventListener, l, false);
        functionalTimer.setUsesEndCondition(timer.isUsesEndCondition());
        functionalTimer.setRunsInLoop(timer.isRunsInLoop());
        functionalTimer.setMultipleStarts(timer.isMultipleStarts());
        functionalTimer.setShowTime(timer.isShowTime());
        functionalTimer.setCountDown(timer.isCountDown());
        functionalTimer.setName(timer.getDisplayName());
        functionalTimer.setShowWhenStopped(timer.isShowWhenStopped());
        this.timers.put(new Integer(ID), functionalTimer);
        return ++ID - 1;
    }

    public void deleteTimer(int n) {
        if (this.timers.containsKey(new Integer(n))) {
            this.timers.remove(new Integer(n));
        }
    }

    public boolean isTimerRunning(int n) {
        if (n >= 0 && n < this.timers.size()) {
            FunctionalTimer functionalTimer = this.timers.get(n);
            return functionalTimer.getState() == 1;
        }
        return false;
    }

    public boolean isTimerDone(int n) {
        if (n >= 0 && n < this.timers.size()) {
            FunctionalTimer functionalTimer = this.timers.get(n);
            return functionalTimer.getState() == 2;
        }
        return true;
    }

    public boolean isTimerNotStarted(int n) {
        if (n >= 0 && n < this.timers.size()) {
            FunctionalTimer functionalTimer = this.timers.get(n);
            return functionalTimer.getState() == 0;
        }
        return false;
    }

    public ArrayList<SaveTimer> getTimers() {
        ArrayList<SaveTimer> arrayList = new ArrayList<SaveTimer>();
        for (int i = 0; i < ID; ++i) {
            SaveTimer saveTimer = new SaveTimer();
            FunctionalTimer functionalTimer = this.timers.get(new Integer(i));
            saveTimer.setLastUpdate(functionalTimer.getLastUpdate());
            saveTimer.setState(functionalTimer.getState());
            saveTimer.setTimeUpdate(functionalTimer.getTimeUpdate());
            saveTimer.setAssessmentRule(functionalTimer.isAssessmentTimer());
            arrayList.add(saveTimer);
        }
        return arrayList;
    }

    public boolean isRunningState(int n) {
        return n == 1;
    }

    public int changeValueOfTimer(int n, SaveTimer saveTimer) {
        if (n > ID) {
            return -1;
        }
        FunctionalTimer functionalTimer = this.timers.get(new Integer(n));
        if (functionalTimer != null) {
            functionalTimer.setLastUpdate(saveTimer.getLastUpdate());
            functionalTimer.setState(saveTimer.getState());
            functionalTimer.setTimeUpdate(saveTimer.getTimeUpdate());
            return n;
        }
        return -1;
    }

    public void update(boolean bl) {
        long l = System.currentTimeMillis() / 1000L;
        for (int i = 0; i < ID; ++i) {
            long l2;
            if (!this.timers.containsKey(new Integer(i))) continue;
            FunctionalTimer functionalTimer = this.timers.get(new Integer(i));
            if (functionalTimer.getState() == 0 || functionalTimer.isMultipleStarts() && functionalTimer.getState() == 2) {
                if (!new FunctionalConditions(functionalTimer.getInitConditions()).allConditionsOk() || functionalTimer.isUsesEndCondition() && new FunctionalConditions(functionalTimer.getEndConditions()).allConditionsOk()) continue;
                DebugLog.general("Timer started " + i);
                functionalTimer.setLastUpdate(l);
                functionalTimer.setState(1);
                TimerEventListener timerEventListener = functionalTimer.getListener();
                if (timerEventListener == null) continue;
                timerEventListener.timerStarted(i, l);
                continue;
            }
            if (functionalTimer.getState() != 1) continue;
            if (functionalTimer.isUsesEndCondition() && new FunctionalConditions(functionalTimer.getEndConditions()).allConditionsOk() || !functionalTimer.isUsesEndCondition() && !new FunctionalConditions(functionalTimer.getInitConditions()).allConditionsOk()) {
                DebugLog.general("Timer stoped " + i);
                functionalTimer.setLastUpdate(l);
                functionalTimer.setState(2);
                TimerEventListener timerEventListener = functionalTimer.getListener();
                if (timerEventListener == null) continue;
                timerEventListener.timerStopped(i, l);
                continue;
            }
            if (!bl || (l2 = l - functionalTimer.getLastUpdate()) < functionalTimer.getTimeUpdate() || !functionalTimer.isNotifyUpdates()) continue;
            if (!functionalTimer.isRunsInLoop()) {
                DebugLog.general("Timer ended first cycle and stoped " + i);
                functionalTimer.setState(2);
            } else {
                DebugLog.general("Timer ended cycle and continues " + i);
            }
            TimerEventListener timerEventListener = functionalTimer.getListener();
            if (timerEventListener == null) continue;
            functionalTimer.setLastUpdate(l);
            timerEventListener.cycleCompleted(i, l2);
            if (functionalTimer.isRunsInLoop()) continue;
            timerEventListener.timerStopped(i, l);
        }
    }

    public void draw(Graphics2D graphics2D) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Integer n : this.timers.keySet()) {
            FunctionalTimer functionalTimer = this.timers.get(n);
            if (!functionalTimer.isShowTime() || !functionalTimer.isShowWhenStopped() && functionalTimer.getState() != 1) continue;
            String string = functionalTimer.getName();
            if (string.length() > 0) {
                string = string + " : ";
            }
            string = string + functionalTimer.getTime();
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        GUI.drawStringOnto(graphics2D, stringArray, 800, 0, Color.WHITE, Color.BLACK);
    }

    private static class FunctionalTimer {
        public static final long NO_UPDATE = Long.MIN_VALUE;
        public static final int STATE_NO_INIT = 0;
        public static final int STATE_RUNNING = 1;
        public static final int STATE_DONE = 2;
        private long lastUpdate;
        private boolean notifyUpdates;
        private long timeUpdate;
        private Conditions initConditions;
        private Conditions endConditions;
        private TimerEventListener listener;
        private boolean isAssessmentTimer;
        private boolean usesEndCondition;
        private boolean runsInLoop;
        private boolean multipleStarts;
        private int state;
        private String name;
        private boolean showTime;
        private boolean countDown;
        private boolean showWhenStopped;

        public FunctionalTimer(Conditions conditions, Conditions conditions2, boolean bl, TimerEventListener timerEventListener) {
            this(conditions, conditions2, timerEventListener, Long.MIN_VALUE, true);
            this.usesEndCondition = bl;
        }

        public boolean isUsesEndCondition() {
            return this.usesEndCondition;
        }

        public void setUsesEndCondition(boolean bl) {
            this.usesEndCondition = bl;
        }

        public boolean isRunsInLoop() {
            return this.runsInLoop;
        }

        public void setRunsInLoop(boolean bl) {
            this.runsInLoop = bl;
        }

        public boolean isMultipleStarts() {
            return this.multipleStarts;
        }

        public void setMultipleStarts(boolean bl) {
            this.multipleStarts = bl;
        }

        public FunctionalTimer(Conditions conditions, Conditions conditions2, TimerEventListener timerEventListener, long l, boolean bl) {
            this.initConditions = conditions;
            this.endConditions = conditions2;
            this.listener = timerEventListener;
            this.lastUpdate = 0L;
            this.timeUpdate = l;
            this.notifyUpdates = l != Long.MIN_VALUE;
            this.state = 0;
            this.isAssessmentTimer = bl;
            this.usesEndCondition = true;
            this.runsInLoop = true;
            this.multipleStarts = true;
            this.showTime = false;
            this.name = "timer";
            this.countDown = false;
        }

        public boolean isAssessmentTimer() {
            return this.isAssessmentTimer;
        }

        public long getLastUpdate() {
            return this.lastUpdate;
        }

        public void setLastUpdate(long l) {
            this.lastUpdate = l;
        }

        public boolean isNotifyUpdates() {
            return this.notifyUpdates;
        }

        public void setNotifyUpdates(boolean bl) {
            this.notifyUpdates = bl;
        }

        public long getTimeUpdate() {
            return this.timeUpdate;
        }

        public void setTimeUpdate(long l) {
            this.timeUpdate = l;
        }

        public Conditions getInitConditions() {
            return this.initConditions;
        }

        public void setInitConditions(Conditions conditions) {
            this.initConditions = conditions;
        }

        public Conditions getEndConditions() {
            return this.endConditions;
        }

        public void setEndConditions(Conditions conditions) {
            this.endConditions = conditions;
        }

        public TimerEventListener getListener() {
            return this.listener;
        }

        public void setListener(TimerEventListener timerEventListener) {
            this.listener = timerEventListener;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int n) {
            this.state = n;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setShowTime(boolean bl) {
            this.showTime = bl;
        }

        public boolean isShowTime() {
            return this.showTime;
        }

        public void setCountDown(boolean bl) {
            this.countDown = bl;
        }

        public boolean isCountDown() {
            return this.countDown;
        }

        public String getTime() {
            long l = 0L;
            if (this.state == 0 && this.countDown || this.state == 2 && !this.countDown) {
                l = this.timeUpdate;
            } else if (this.state == 0 && !this.countDown || this.state == 2 && this.countDown) {
                l = 0L;
            } else {
                l = System.currentTimeMillis() / 1000L - this.lastUpdate;
                if (this.countDown) {
                    l = this.timeUpdate - l;
                }
            }
            DecimalFormat decimalFormat = new DecimalFormat("00");
            String string = (this.countDown ? "-" : "") + decimalFormat.format(Math.abs(l / 3600L));
            string = string + ":" + decimalFormat.format(Math.abs(l % 3600L / 60L));
            string = string + ":" + decimalFormat.format(Math.abs(l % 60L));
            return string;
        }

        public void setShowWhenStopped(boolean bl) {
            this.showWhenStopped = bl;
        }

        public boolean isShowWhenStopped() {
            return this.showWhenStopped;
        }
    }
}

