/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.data.GameText;
import es.eucm.eadventure.engine.resourcehandler.ResourceHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class Options {
    public static final int TEXT_NUM_SPEEDS = 3;
    public static final int TEXT_SLOW = 0;
    public static final int TEXT_NORMAL = 1;
    public static final int TEXT_FAST = 2;
    public static final String[] TEXT_SPEED_PRINT_VALUES = new String[]{GameText.TEXT_SLOW, GameText.TEXT_NORMAL, GameText.TEXT_FAST};
    private Properties options = new Properties();

    public Options() {
        this.options.setProperty("Music", "On");
        this.options.setProperty("FunctionalEffects", "On");
        this.options.setProperty("TextSpeed", "1");
    }

    public void loadOptions(String string, String string2) {
        InputStream inputStream = ResourceHandler.getInstance().getResourceAsStream(string + string2 + "-opt.xml");
        if (inputStream != null) {
            try {
                this.options.loadFromXML(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                ReportDialog.GenerateErrorReport(iOException, Game.getInstance().isFromEditor(), "UNKNOWERROR");
            }
        }
    }

    public void saveOptions(String string, String string2) {
        OutputStream outputStream = ResourceHandler.getInstance().getOutputStream(string + string2 + "-opt.xml");
        if (outputStream != null) {
            try {
                this.options.storeToXML(outputStream, "eAdventure game options", "ISO-8859-1");
            }
            catch (IOException iOException) {
                ReportDialog.GenerateErrorReport(iOException, Game.getInstance().isFromEditor(), "UNKNOWERROR");
            }
        }
    }

    public boolean isMusicActive() {
        return this.options.getProperty("Music").equals("On");
    }

    public boolean isEffectsActive() {
        return this.options.getProperty("FunctionalEffects").equals("On");
    }

    public int getTextSpeed() {
        return Integer.parseInt(this.options.getProperty("TextSpeed"));
    }

    public void setMusicActive(boolean bl) {
        this.options.setProperty("Music", bl ? "On" : "Off");
    }

    public void setEffectsActive(boolean bl) {
        this.options.setProperty("FunctionalEffects", bl ? "On" : "Off");
    }

    public void setTextSpeed(int n) {
        this.options.setProperty("TextSpeed", String.valueOf(n));
    }
}

