/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.subparsers;

import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.ElementReference;
import es.eucm.eadventure.common.data.chapter.Exit;
import es.eucm.eadventure.common.data.chapter.ExitLook;
import es.eucm.eadventure.common.data.chapter.InfluenceArea;
import es.eucm.eadventure.common.data.chapter.NextScene;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.data.chapter.scenes.Scene;
import es.eucm.eadventure.common.loader.subparsers.ActiveAreaSubParser;
import es.eucm.eadventure.common.loader.subparsers.BarrierSubParser;
import es.eucm.eadventure.common.loader.subparsers.ConditionSubParser;
import es.eucm.eadventure.common.loader.subparsers.EffectSubParser;
import es.eucm.eadventure.common.loader.subparsers.SubParser;
import es.eucm.eadventure.common.loader.subparsers.TrajectorySubParser;
import java.awt.Point;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class SceneSubParser
extends SubParser {
    private static final int READING_NONE = 0;
    private static final int READING_RESOURCES = 1;
    private static final int READING_EXIT = 2;
    private static final int READING_NEXT_SCENE = 3;
    private static final int READING_ELEMENT_REFERENCE = 4;
    private static final int SUBPARSING_NONE = 0;
    private static final int SUBPARSING_CONDITION = 1;
    private static final int SUBPARSING_EFFECT = 2;
    private static final int SUBPARSING_ACTIVE_AREA = 3;
    private static final int SUBPARSING_BARRIER = 4;
    private static final int SUBPARSING_TRAJECTORY = 5;
    private int reading = 0;
    private int subParsing = 0;
    private Scene scene;
    private Resources currentResources;
    private Exit currentExit;
    private ExitLook currentExitLook;
    private NextScene currentNextScene;
    private Point currentPoint;
    private ElementReference currentElementReference;
    private Conditions currentConditions;
    private Effects currentEffects;
    private SubParser subParser;

    public SceneSubParser(Chapter chapter) {
        super(chapter);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.subParsing == 0) {
            if (string3.equals("scene")) {
                String string4 = "";
                boolean bl = false;
                int n = -1;
                float f = 1.0f;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("id")) {
                        string4 = attributes.getValue(i);
                    }
                    if (attributes.getQName(i).equals("start")) {
                        bl = attributes.getValue(i).equals("yes");
                    }
                    if (attributes.getQName(i).equals("playerLayer")) {
                        n = Integer.parseInt(attributes.getValue(i));
                    }
                    if (!attributes.getQName(i).equals("playerScale")) continue;
                    f = Float.parseFloat(attributes.getValue(i));
                }
                this.scene = new Scene(string4);
                this.scene.setPlayerLayer(n);
                this.scene.setPlayerScale(f);
                if (bl) {
                    this.chapter.setTargetId(string4);
                }
            } else if (string3.equals("resources")) {
                this.currentResources = new Resources();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("name")) continue;
                    this.currentResources.setName(attributes.getValue(i));
                }
                this.reading = 1;
            } else if (string3.equals("asset")) {
                String string5 = "";
                String string6 = "";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("type")) {
                        string5 = attributes.getValue(i);
                    }
                    if (!attributes.getQName(i).equals("uri")) continue;
                    string6 = attributes.getValue(i);
                }
                this.currentResources.addAsset(string5, string6);
            } else if (string3.equals("default-initial-position")) {
                int n = Integer.MIN_VALUE;
                int n2 = Integer.MIN_VALUE;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("x")) {
                        n = Integer.parseInt(attributes.getValue(i));
                    }
                    if (!attributes.getQName(i).equals("y")) continue;
                    n2 = Integer.parseInt(attributes.getValue(i));
                }
                this.scene.setDefaultPosition(n, n2);
            } else if (string3.equals("exit")) {
                int n = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                boolean bl = true;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                boolean bl2 = false;
                String string7 = "";
                int n10 = Integer.MIN_VALUE;
                int n11 = Integer.MIN_VALUE;
                int n12 = 0;
                int n13 = 0;
                boolean bl3 = false;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("rectangular")) {
                        bl = attributes.getValue(i).equals("yes");
                    }
                    if (attributes.getQName(i).equals("x")) {
                        n = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("y")) {
                        n3 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("width")) {
                        n4 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("height")) {
                        n5 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("hasInfluenceArea")) {
                        bl2 = attributes.getValue(i).equals("yes");
                    }
                    if (attributes.getQName(i).equals("influenceX")) {
                        n6 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("influenceY")) {
                        n7 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("influenceWidth")) {
                        n8 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("influenceHeight")) {
                        n9 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("idTarget")) {
                        string7 = attributes.getValue(i);
                    }
                    if (attributes.getQName(i).equals("destinyX")) {
                        n10 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("destinyY")) {
                        n11 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("transitionType")) {
                        n12 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("transitionTime")) {
                        n13 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (!attributes.getQName(i).equals("not-effects")) continue;
                    bl3 = attributes.getValue(i).equals("yes");
                }
                this.currentExit = new Exit(bl, n, n3, n4, n5);
                this.currentExit.setNextSceneId(string7);
                this.currentExit.setDestinyX(n10);
                this.currentExit.setDestinyY(n11);
                this.currentExit.setTransitionTime(n13);
                this.currentExit.setTransitionType(n12);
                this.currentExit.setHasNotEffects(bl3);
                if (bl2) {
                    InfluenceArea influenceArea = new InfluenceArea(n6, n7, n8, n9);
                    this.currentExit.setInfluenceArea(influenceArea);
                }
                this.reading = 2;
            } else if (string3.equals("exit-look")) {
                this.currentExitLook = new ExitLook();
                String string8 = null;
                String string9 = null;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("text")) {
                        string8 = attributes.getValue(i);
                    }
                    if (!attributes.getQName(i).equals("cursor-path")) continue;
                    string9 = attributes.getValue(i);
                }
                this.currentExitLook.setCursorPath(string9);
                this.currentExitLook.setExitText(string8);
            } else if (string3.equals("next-scene")) {
                String string10 = "";
                int n = Integer.MIN_VALUE;
                int n14 = Integer.MIN_VALUE;
                int n15 = 0;
                int n16 = 0;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("idTarget")) {
                        string10 = attributes.getValue(i);
                    }
                    if (attributes.getQName(i).equals("x")) {
                        n = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("y")) {
                        n14 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("transitionType")) {
                        n15 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (!attributes.getQName(i).equals("transitionTime")) continue;
                    n16 = Integer.parseInt(attributes.getValue(i));
                }
                this.currentNextScene = new NextScene(string10, n, n14);
                this.currentNextScene.setTransitionType(n15);
                this.currentNextScene.setTransitionTime(n16);
                this.reading = 3;
            } else if (string3.equals("point")) {
                int n = 0;
                int n17 = 0;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("x")) {
                        n = Integer.parseInt(attributes.getValue(i));
                    }
                    if (!attributes.getQName(i).equals("y")) continue;
                    n17 = Integer.parseInt(attributes.getValue(i));
                }
                this.currentPoint = new Point(n, n17);
            } else if (string3.equals("object-ref") || string3.equals("character-ref") || string3.equals("atrezzo-ref")) {
                String string11 = "";
                int n = 0;
                int n18 = 0;
                float f = 0.0f;
                int n19 = 0;
                int n20 = 0;
                int n21 = 0;
                int n22 = 0;
                int n23 = 0;
                boolean bl = false;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("idTarget")) {
                        string11 = attributes.getValue(i);
                    }
                    if (attributes.getQName(i).equals("x")) {
                        n = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("y")) {
                        n18 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("scale")) {
                        f = Float.parseFloat(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("layer")) {
                        n19 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("hasInfluenceArea")) {
                        bl = attributes.getValue(i).equals("yes");
                    }
                    if (attributes.getQName(i).equals("influenceX")) {
                        n20 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("influenceY")) {
                        n21 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("influenceWidth")) {
                        n22 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (!attributes.getQName(i).equals("influenceHeight")) continue;
                    n23 = Integer.parseInt(attributes.getValue(i));
                }
                if (n19 == -1) {
                    n19 = 0;
                }
                this.currentElementReference = new ElementReference(string11, n, n18, n19);
                if (bl) {
                    InfluenceArea influenceArea = new InfluenceArea(n20, n21, n22, n23);
                    this.currentElementReference.setInfluenceArea(influenceArea);
                }
                if ((double)f > 0.001 || (double)f < -0.001) {
                    this.currentElementReference.setScale(f);
                }
                this.reading = 4;
            } else if (string3.equals("condition")) {
                this.currentConditions = new Conditions();
                this.subParser = new ConditionSubParser(this.currentConditions, this.chapter);
                this.subParsing = 1;
            } else if (string3.equals("effect")) {
                this.currentEffects = new Effects();
                this.subParser = new EffectSubParser(this.currentEffects, this.chapter);
                this.subParsing = 2;
            } else if (string3.equals("post-effect")) {
                this.currentEffects = new Effects();
                this.subParser = new EffectSubParser(this.currentEffects, this.chapter);
                this.subParsing = 2;
            } else if (string3.equals("not-effect")) {
                this.currentEffects = new Effects();
                this.subParser = new EffectSubParser(this.currentEffects, this.chapter);
                this.subParsing = 2;
            } else if (string3.equals("active-area")) {
                this.subParsing = 3;
                this.subParser = new ActiveAreaSubParser(this.chapter, this.scene, this.scene.getActiveAreas().size());
            } else if (string3.equals("barrier")) {
                this.subParsing = 4;
                this.subParser = new BarrierSubParser(this.chapter, this.scene, this.scene.getBarriers().size());
            } else if (string3.equals("trajectory")) {
                this.subParsing = 5;
                this.subParser = new TrajectorySubParser(this.chapter, this.scene);
            }
        }
        if (this.subParsing != 0) {
            this.subParser.startElement(string, string2, string3, attributes);
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (this.subParsing == 0) {
            if (string3.equals("scene")) {
                this.chapter.addScene(this.scene);
            } else if (string3.equals("resources")) {
                this.scene.addResources(this.currentResources);
                this.reading = 0;
            } else if (string3.equals("name")) {
                this.scene.setName(this.currentString.toString().trim());
            } else if (string3.equals("documentation")) {
                if (this.reading == 0) {
                    this.scene.setDocumentation(this.currentString.toString().trim());
                } else if (this.reading == 2) {
                    this.currentExit.setDocumentation(this.currentString.toString().trim());
                } else if (this.reading == 4) {
                    this.currentElementReference.setDocumentation(this.currentString.toString().trim());
                }
            } else if (string3.equals("exit")) {
                if (this.currentExit.getNextScenes().size() > 0) {
                    for (NextScene nextScene : this.currentExit.getNextScenes()) {
                        try {
                            Exit exit = (Exit)this.currentExit.clone();
                            exit.setNextScenes(new ArrayList<NextScene>());
                            exit.setDestinyX(nextScene.getPositionX());
                            exit.setDestinyY(nextScene.getPositionY());
                            exit.setEffects(nextScene.getEffects());
                            exit.setPostEffects(nextScene.getPostEffects());
                            if (exit.getDefaultExitLook() == null) {
                                exit.setDefaultExitLook(nextScene.getExitLook());
                            } else if (nextScene.getExitLook() != null) {
                                if (nextScene.getExitLook().getExitText() != null && !nextScene.getExitLook().getExitText().equals("")) {
                                    exit.getDefaultExitLook().setExitText(nextScene.getExitLook().getExitText());
                                }
                                if (nextScene.getExitLook().getCursorPath() != null && !nextScene.getExitLook().getCursorPath().equals("")) {
                                    exit.getDefaultExitLook().setCursorPath(nextScene.getExitLook().getCursorPath());
                                }
                            }
                            exit.setHasNotEffects(false);
                            exit.setConditions(nextScene.getConditions());
                            exit.setNextSceneId(nextScene.getTargetId());
                            this.scene.addExit(exit);
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            cloneNotSupportedException.printStackTrace();
                        }
                    }
                } else {
                    this.scene.addExit(this.currentExit);
                }
                this.reading = 0;
            } else if (string3.equals("exit-look")) {
                if (this.reading == 3) {
                    this.currentNextScene.setExitLook(this.currentExitLook);
                } else if (this.reading == 2) {
                    this.currentExit.setDefaultExitLook(this.currentExitLook);
                }
            } else if (string3.equals("next-scene")) {
                this.currentExit.addNextScene(this.currentNextScene);
                this.reading = 0;
            } else if (string3.equals("point")) {
                this.currentExit.addPoint(this.currentPoint);
            } else if (string3.equals("object-ref")) {
                this.scene.addItemReference(this.currentElementReference);
                this.reading = 0;
            } else if (string3.equals("character-ref")) {
                this.scene.addCharacterReference(this.currentElementReference);
                this.reading = 0;
            } else if (string3.equals("atrezzo-ref")) {
                this.scene.addAtrezzoReference(this.currentElementReference);
                this.reading = 0;
            }
            this.currentString = new StringBuffer();
        } else if (this.subParsing == 1) {
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("condition")) {
                if (this.reading == 1) {
                    this.currentResources.setConditions(this.currentConditions);
                }
                if (this.reading == 3) {
                    this.currentNextScene.setConditions(this.currentConditions);
                }
                if (this.reading == 4) {
                    this.currentElementReference.setConditions(this.currentConditions);
                }
                if (this.reading == 2) {
                    this.currentExit.setConditions(this.currentConditions);
                }
                this.subParsing = 0;
            }
        } else if (this.subParsing == 2) {
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("effect")) {
                if (this.reading == 3) {
                    this.currentNextScene.setEffects(this.currentEffects);
                }
                if (this.reading == 2) {
                    this.currentExit.setEffects(this.currentEffects);
                }
                this.subParsing = 0;
            }
            if (string3.equals("post-effect")) {
                if (this.reading == 3) {
                    this.currentNextScene.setPostEffects(this.currentEffects);
                }
                if (this.reading == 2) {
                    this.currentExit.setPostEffects(this.currentEffects);
                }
                this.subParsing = 0;
            }
            if (string3.equals("not-effect")) {
                this.currentExit.setNotEffects(this.currentEffects);
                this.subParsing = 0;
            }
        } else if (this.subParsing == 3) {
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("active-area")) {
                this.subParsing = 0;
            }
        } else if (this.subParsing == 4) {
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("barrier")) {
                this.subParsing = 0;
            }
        } else if (this.subParsing == 5) {
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("trajectory")) {
                this.subParsing = 0;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.subParsing == 0) {
            super.characters(cArray, n, n2);
        } else {
            this.subParser.characters(cArray, n, n2);
        }
    }
}

