/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.subparsers;

import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.elements.Player;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.loader.subparsers.ConditionSubParser;
import es.eucm.eadventure.common.loader.subparsers.SubParser;
import org.xml.sax.Attributes;

public class PlayerSubParser
extends SubParser {
    private static final int SUBPARSING_NONE = 0;
    private static final int SUBPARSING_CONDITION = 1;
    private int subParsing = 0;
    private Player player;
    private Resources currentResources;
    private Conditions currentConditions;
    private SubParser conditionSubParser;

    public PlayerSubParser(Chapter chapter) {
        super(chapter);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.subParsing == 0) {
            if (string3.equals("player")) {
                this.player = new Player();
            } else if (string3.equals("resources")) {
                this.currentResources = new Resources();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("name")) continue;
                    this.currentResources.setName(attributes.getValue(i));
                }
            } else if (string3.equals("condition")) {
                this.currentConditions = new Conditions();
                this.conditionSubParser = new ConditionSubParser(this.currentConditions, this.chapter);
                this.subParsing = 1;
            } else if (string3.equals("asset")) {
                String string4 = "";
                String string5 = "";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("type")) {
                        string4 = attributes.getValue(i);
                    }
                    if (!attributes.getQName(i).equals("uri")) continue;
                    string5 = attributes.getValue(i);
                }
                this.currentResources.addAsset(string4, string5);
            } else if (string3.equals("frontcolor") || string3.equals("bordercolor")) {
                String string6 = "";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("color")) continue;
                    string6 = attributes.getValue(i);
                }
                if (string3.equals("frontcolor")) {
                    this.player.setTextFrontColor(string6);
                }
                if (string3.equals("bordercolor")) {
                    this.player.setTextBorderColor(string6);
                }
            } else if (string3.equals("textcolor")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("showsSpeechBubble")) {
                        this.player.setShowsSpeechBubbles(attributes.getValue(i).equals("yes"));
                    }
                    if (attributes.getQName(i).equals("bubbleBkgColor")) {
                        this.player.setBubbleBkgColor(attributes.getValue(i));
                    }
                    if (!attributes.getQName(i).equals("bubbleBorderColor")) continue;
                    this.player.setBubbleBorderColor(attributes.getValue(i));
                }
            } else if (string3.equals("voice")) {
                String string7 = new String("");
                boolean bl = false;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string8;
                    if (attributes.getQName(i).equals("name")) {
                        string7 = attributes.getValue(i);
                    }
                    if (!attributes.getQName(i).equals("synthesizeAlways") || !(string8 = attributes.getValue(i)).equals("yes")) continue;
                    bl = true;
                }
                this.player.setAlwaysSynthesizer(bl);
                this.player.setVoice(string7);
            }
        }
        if (this.subParsing == 1) {
            this.conditionSubParser.startElement(string, string2, string3, attributes);
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (this.subParsing == 0) {
            if (string3.equals("player")) {
                this.chapter.setPlayer(this.player);
            } else if (string3.equals("documentation")) {
                this.player.setDocumentation(this.currentString.toString().trim());
            } else if (string3.equals("resources")) {
                this.player.addResources(this.currentResources);
            } else if (string3.equals("name")) {
                this.player.setName(this.currentString.toString().trim());
            } else if (string3.equals("brief")) {
                this.player.setDescription(this.currentString.toString().trim());
            } else if (string3.equals("detailed")) {
                this.player.setDetailedDescription(this.currentString.toString().trim());
            }
            this.currentString = new StringBuffer();
        } else if (this.subParsing == 1) {
            this.conditionSubParser.endElement(string, string2, string3);
            if (string3.equals("condition")) {
                this.currentResources.setConditions(this.currentConditions);
                this.subParsing = 0;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.subParsing == 0) {
            super.characters(cArray, n, n2);
        } else if (this.subParsing == 1) {
            this.conditionSubParser.characters(cArray, n, n2);
        }
    }
}

