/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.subparsers;

import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.conversation.GraphConversation;
import es.eucm.eadventure.common.data.chapter.conversation.line.ConversationLine;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.DialogueConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.OptionConversationNode;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.common.loader.subparsers.ConditionSubParser;
import es.eucm.eadventure.common.loader.subparsers.EffectSubParser;
import es.eucm.eadventure.common.loader.subparsers.SubParser;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class GraphConversationSubParser
extends SubParser {
    private static final int SUBPARSING_NONE = 0;
    private static final int SUBPARSING_EFFECT = 1;
    private static final int SUBPARSING_CONDITION = 2;
    private int subParsing = 0;
    private String conversationName;
    private ConversationNode currentNode;
    private List<ConversationNode> graphNodes;
    private List<Integer> currentLinks;
    private List<List<Integer>> nodeLinks;
    private Effects currentEffects;
    private SubParser subParser;
    private String characterName;
    private String audioPath;
    private boolean random;
    private boolean keepShowing;
    private boolean keepShowingLine;
    private boolean showUserOption;
    private boolean preListening;
    private boolean keepShowingDialogue;
    private Boolean synthesizerVoice;
    private Conditions currentConditions;
    private ConversationLine conversationLine;

    public GraphConversationSubParser(Chapter chapter) {
        super(chapter);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.subParsing == 0) {
            if (string3.equals("graph-conversation")) {
                this.conversationName = "";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("id")) continue;
                    this.conversationName = attributes.getValue(i);
                }
                this.graphNodes = new ArrayList<ConversationNode>();
                this.nodeLinks = new ArrayList<List<Integer>>();
            } else if (string3.equals("dialogue-node") || string3.equals("option-node")) {
                int n;
                if (string3.equals("dialogue-node")) {
                    for (n = 0; n < attributes.getLength(); ++n) {
                        if (attributes.getQName(n).equals("keepShowing")) {
                            this.keepShowingDialogue = attributes.getValue(n).equals("yes");
                        }
                        this.currentNode = new DialogueConversationNode(this.keepShowingDialogue);
                    }
                }
                if (string3.equals("option-node")) {
                    for (n = 0; n < attributes.getLength(); ++n) {
                        if (attributes.getQName(n).equals("random")) {
                            this.random = attributes.getValue(n).equals("yes");
                        }
                        if (attributes.getQName(n).equals("keepShowing")) {
                            this.keepShowing = attributes.getValue(n).equals("yes");
                        }
                        if (attributes.getQName(n).equals("showUserOption")) {
                            this.showUserOption = attributes.getValue(n).equals("yes");
                        }
                        if (!attributes.getQName(n).equals("preListening")) continue;
                        this.preListening = attributes.getValue(n).equals("yes");
                    }
                    this.currentNode = new OptionConversationNode(this.random, this.keepShowing, this.showUserOption, this.preListening);
                }
                this.currentLinks = new ArrayList<Integer>();
            } else if (string3.equals("speak-char")) {
                this.characterName = "NPC";
                this.audioPath = "";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string4;
                    if (attributes.getQName(i).equals("idTarget")) {
                        this.characterName = attributes.getValue(i);
                    }
                    if (attributes.getQName(i).equals("uri")) {
                        this.audioPath = attributes.getValue(i);
                    }
                    if (attributes.getQName(i).equals("synthesize")) {
                        string4 = attributes.getValue(i);
                        this.synthesizerVoice = string4.equals("yes") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (!attributes.getQName(i).equals("keepShowing")) continue;
                    string4 = attributes.getValue(i);
                    this.keepShowingLine = string4.equals("yes");
                }
            } else if (string3.equals("speak-player")) {
                this.audioPath = "";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string5;
                    if (attributes.getQName(i).equals("uri")) {
                        this.audioPath = attributes.getValue(i);
                    }
                    if (attributes.getQName(i).equals("synthesize")) {
                        string5 = attributes.getValue(i);
                        this.synthesizerVoice = string5.equals("yes") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (!attributes.getQName(i).equals("keepShowing")) continue;
                    string5 = attributes.getValue(i);
                    this.keepShowingLine = string5.equals("yes");
                }
            } else if (string3.equals("child")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("nodeindex")) continue;
                    Integer n = new Integer(attributes.getValue(i));
                    this.currentLinks.add(n);
                }
            } else if (string3.equals("effect")) {
                this.currentEffects = new Effects();
                this.subParser = new EffectSubParser(this.currentEffects, this.chapter);
                this.subParsing = 1;
            } else if (string3.equals("condition")) {
                this.currentConditions = new Conditions();
                this.subParser = new ConditionSubParser(this.currentConditions, this.chapter);
                this.subParsing = 2;
            }
        }
        if (this.subParsing == 1 || this.subParsing == 2) {
            this.subParser.startElement(string, string2, string3, attributes);
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (this.subParsing == 0) {
            if (string3.equals("graph-conversation")) {
                this.setNodeLinks();
                this.chapter.addConversation(new GraphConversation(this.conversationName, this.graphNodes.get(0)));
            } else if (string3.equals("dialogue-node") || string3.equals("option-node")) {
                this.graphNodes.add(this.currentNode);
                this.nodeLinks.add(this.currentLinks);
            } else if (string3.equals("speak-player")) {
                this.conversationLine = new ConversationLine("Player", new String(this.currentString).trim());
                if (this.audioPath != null && !this.audioPath.equals("")) {
                    this.conversationLine.setAudioPath(this.audioPath);
                }
                if (this.synthesizerVoice != null) {
                    this.conversationLine.setSynthesizerVoice(this.synthesizerVoice);
                }
                this.conversationLine.setKeepShowing(this.keepShowingLine);
                this.currentNode.addLine(this.conversationLine);
            } else if (string3.equals("speak-char")) {
                this.conversationLine = new ConversationLine(this.characterName, new String(this.currentString).trim());
                if (this.audioPath != null && !this.audioPath.equals("")) {
                    this.conversationLine.setAudioPath(this.audioPath);
                }
                if (this.synthesizerVoice != null) {
                    this.conversationLine.setSynthesizerVoice(this.synthesizerVoice);
                }
                this.conversationLine.setKeepShowing(this.keepShowingLine);
                this.currentNode.addLine(this.conversationLine);
            }
            this.currentString = new StringBuffer();
        } else if (this.subParsing == 1 || this.subParsing == 2) {
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("effect") && this.subParsing == 1) {
                this.currentNode.setEffects(this.currentEffects);
                this.subParsing = 0;
            } else if (string3.equals("condition") && this.subParsing == 2) {
                this.conversationLine.setConditions(this.currentConditions);
                this.subParsing = 0;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.subParsing == 0) {
            super.characters(cArray, n, n2);
        } else if (this.subParsing == 1 || this.subParsing == 2) {
            this.subParser.characters(cArray, n, n2);
        }
    }

    private void setNodeLinks() {
        for (int i = 0; i < this.graphNodes.size(); ++i) {
            ConversationNode conversationNode = this.graphNodes.get(i);
            List<Integer> list = this.nodeLinks.get(i);
            for (int j = 0; j < list.size(); ++j) {
                conversationNode.addChild(this.graphNodes.get(list.get(j)));
            }
        }
    }
}

