/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.subparsers;

import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.ConversationReference;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.effects.TriggerConversationEffect;
import es.eucm.eadventure.common.data.chapter.elements.NPC;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.loader.subparsers.ActionsSubParser;
import es.eucm.eadventure.common.loader.subparsers.ConditionSubParser;
import es.eucm.eadventure.common.loader.subparsers.SubParser;
import org.xml.sax.Attributes;

public class CharacterSubParser
extends SubParser {
    private static final int READING_NONE = 0;
    private static final int READING_RESOURCES = 1;
    private static final int READING_CONVERSATION_REFERENCE = 2;
    private static final int SUBPARSING_NONE = 0;
    private static final int SUBPARSING_CONDITION = 1;
    private static final int SUBPARSING_ACTIONS = 2;
    private int reading = 0;
    private int subParsing = 0;
    private NPC npc;
    private Resources currentResources;
    private ConversationReference conversationReference;
    private Conditions currentConditions;
    private SubParser subParser;

    public CharacterSubParser(Chapter chapter) {
        super(chapter);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.subParsing == 0) {
            if (string3.equals("character")) {
                String string4 = "";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("id")) continue;
                    string4 = attributes.getValue(i);
                }
                this.npc = new NPC(string4);
            } else if (string3.equals("resources")) {
                this.currentResources = new Resources();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("name")) continue;
                    this.currentResources.setName(attributes.getValue(i));
                }
                this.reading = 1;
            } else if (string3.equals("asset")) {
                String string5 = "";
                String string6 = "";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("type")) {
                        string5 = attributes.getValue(i);
                    }
                    if (!attributes.getQName(i).equals("uri")) continue;
                    string6 = attributes.getValue(i);
                }
                this.currentResources.addAsset(string5, string6);
            } else if (string3.equals("frontcolor") || string3.equals("bordercolor")) {
                String string7 = "";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("color")) continue;
                    string7 = attributes.getValue(i);
                }
                if (string3.equals("frontcolor")) {
                    this.npc.setTextFrontColor(string7);
                }
                if (string3.equals("bordercolor")) {
                    this.npc.setTextBorderColor(string7);
                }
            } else if (string3.equals("textcolor")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("showsSpeechBubble")) {
                        this.npc.setShowsSpeechBubbles(attributes.getValue(i).equals("yes"));
                    }
                    if (attributes.getQName(i).equals("bubbleBkgColor")) {
                        this.npc.setBubbleBkgColor(attributes.getValue(i));
                    }
                    if (!attributes.getQName(i).equals("bubbleBorderColor")) continue;
                    this.npc.setBubbleBorderColor(attributes.getValue(i));
                }
            } else if (string3.equals("conversation-ref")) {
                String string8 = "";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("idTarget")) continue;
                    string8 = attributes.getValue(i);
                }
                this.conversationReference = new ConversationReference(string8);
                this.reading = 2;
            } else if (string3.equals("condition")) {
                this.currentConditions = new Conditions();
                this.subParser = new ConditionSubParser(this.currentConditions, this.chapter);
                this.subParsing = 1;
            } else if (string3.equals("voice")) {
                String string9 = new String("");
                boolean bl = false;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string10;
                    if (attributes.getQName(i).equals("name")) {
                        string9 = attributes.getValue(i);
                    }
                    if (!attributes.getQName(i).equals("synthesizeAlways") || !(string10 = attributes.getValue(i)).equals("yes")) continue;
                    bl = true;
                }
                this.npc.setAlwaysSynthesizer(bl);
                this.npc.setVoice(string9);
            } else if (string3.equals("actions")) {
                this.subParser = new ActionsSubParser(this.chapter, this.npc);
                this.subParsing = 2;
            }
        }
        if (this.subParsing != 0) {
            this.subParser.startElement(string, string2, string3, attributes);
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (this.subParsing == 0) {
            if (string3.equals("character")) {
                this.chapter.addCharacter(this.npc);
            } else if (string3.equals("documentation")) {
                if (this.reading == 0) {
                    this.npc.setDocumentation(this.currentString.toString().trim());
                } else if (this.reading == 2) {
                    this.conversationReference.setDocumentation(this.currentString.toString().trim());
                }
            } else if (string3.equals("resources")) {
                this.npc.addResources(this.currentResources);
                this.reading = 0;
            } else if (string3.equals("name")) {
                this.npc.setName(this.currentString.toString().trim());
            } else if (string3.equals("brief")) {
                this.npc.setDescription(this.currentString.toString().trim());
            } else if (string3.equals("detailed")) {
                this.npc.setDetailedDescription(this.currentString.toString().trim());
            } else if (string3.equals("conversation-ref")) {
                Action action = new Action(7);
                action.setConditions(this.conversationReference.getConditions());
                action.setDocumentation(this.conversationReference.getDocumentation());
                TriggerConversationEffect triggerConversationEffect = new TriggerConversationEffect(this.conversationReference.getTargetId());
                action.getEffects().add(triggerConversationEffect);
                this.npc.addAction(action);
                this.reading = 0;
            }
            this.currentString = new StringBuffer();
        } else if (this.subParsing == 1) {
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("condition")) {
                if (this.reading == 1) {
                    this.currentResources.setConditions(this.currentConditions);
                }
                if (this.reading == 2) {
                    this.conversationReference.setConditions(this.currentConditions);
                }
                this.subParsing = 0;
            }
        } else if (this.subParsing == 2) {
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("actions")) {
                this.subParsing = 0;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.subParsing == 0) {
            super.characters(cArray, n, n2);
        } else if (this.subParsing == 1) {
            this.subParser.characters(cArray, n, n2);
        } else if (this.subParsing == 2) {
            this.subParser.characters(cArray, n, n2);
        }
    }
}

