/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.subparsers;

import es.eucm.eadventure.common.data.assessment.AssessmentProfile;
import es.eucm.eadventure.common.data.assessment.AssessmentProperty;
import es.eucm.eadventure.common.data.assessment.AssessmentRule;
import es.eucm.eadventure.common.data.assessment.TimedAssessmentRule;
import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.conditions.FlagCondition;
import es.eucm.eadventure.common.data.chapter.conditions.GlobalStateCondition;
import es.eucm.eadventure.common.data.chapter.conditions.VarCondition;
import es.eucm.eadventure.common.loader.subparsers.SubParser;
import org.xml.sax.Attributes;

public class AssessmentSubParser
extends SubParser {
    private StringBuffer currentString;
    private static final int READING_NONE = 0;
    private static final int READING_EITHER = 1;
    private int reading = 0;
    private AssessmentRule currentAssessmentRule;
    private Conditions currentConditions;
    private Conditions currentEitherCondition;
    private AssessmentProfile profile = new AssessmentProfile();

    public AssessmentSubParser(Chapter chapter) {
        super(chapter);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string3.equals("assessment")) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("show-report-at-end")) {
                    this.profile.setShowReportAtEnd(attributes.getValue(i).equals("yes"));
                }
                if (attributes.getQName(i).equals("send-to-email")) {
                    if (attributes.getValue(i) == null || attributes.getValue(i).length() < 1) {
                        this.profile.setEmail("");
                        this.profile.setSendByEmail(false);
                    } else {
                        this.profile.setEmail(attributes.getValue(i));
                        this.profile.setSendByEmail(true);
                    }
                }
                if (attributes.getQName(i).equals("scorm12")) {
                    this.profile.setScorm12(attributes.getValue(i).equals("yes"));
                }
                if (attributes.getQName(i).equals("scorm2004")) {
                    this.profile.setScorm2004(attributes.getValue(i).equals("yes"));
                }
                if (!attributes.getQName(i).equals("name")) continue;
                this.profile.setName(attributes.getValue(i));
            }
        } else if (string3.equals("smtp-config")) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("smtp-ssl")) {
                    this.profile.setSmtpSSL(attributes.getValue(i).equals("yes"));
                }
                if (attributes.getQName(i).equals("smtp-server")) {
                    this.profile.setSmtpServer(attributes.getValue(i));
                }
                if (attributes.getQName(i).equals("smtp-port")) {
                    this.profile.setSmtpPort(attributes.getValue(i));
                }
                if (attributes.getQName(i).equals("smtp-user")) {
                    this.profile.setSmtpUser(attributes.getValue(i));
                }
                if (!attributes.getQName(i).equals("smtp-pwd")) continue;
                this.profile.setSmtpPwd(attributes.getValue(i));
            }
        } else if (string3.equals("assessment-rule")) {
            String string4 = null;
            int n = 0;
            boolean bl = false;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("id")) {
                    string4 = attributes.getValue(i);
                }
                if (attributes.getQName(i).equals("importance")) {
                    for (int j = 0; j < 5; ++j) {
                        if (!attributes.getValue(i).equals(AssessmentRule.IMPORTANCE_VALUES[j])) continue;
                        n = j;
                    }
                }
                if (!attributes.getQName(i).equals("repeatRule")) continue;
                bl = attributes.getValue(i).equals("yes");
            }
            this.currentAssessmentRule = new AssessmentRule(string4, n, bl);
        } else if (string3.equals("timed-assessment-rule")) {
            String string5 = null;
            int n = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("id")) {
                    string5 = attributes.getValue(i);
                }
                if (attributes.getQName(i).equals("importance")) {
                    for (int j = 0; j < 5; ++j) {
                        if (!attributes.getValue(i).equals(AssessmentRule.IMPORTANCE_VALUES[j])) continue;
                        n = j;
                    }
                }
                if (attributes.getQName(i).equals("usesEndConditions")) {
                    bl2 = true;
                    bl = attributes.getValue(i).equals("yes");
                }
                if (!attributes.getQName(i).equals("repeatRule")) continue;
                bl3 = attributes.getValue(i).equals("yes");
            }
            this.currentAssessmentRule = new TimedAssessmentRule(string5, n, bl3);
            if (bl2) {
                ((TimedAssessmentRule)this.currentAssessmentRule).setUsesEndConditions(bl);
            }
        } else if (string3.equals("condition") || string3.equals("init-condition") || string3.equals("end-condition")) {
            this.currentConditions = new Conditions();
        } else if (string3.equals("either")) {
            this.currentEitherCondition = new Conditions();
            this.reading = 1;
        } else if (string3.equals("active")) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("flag")) continue;
                if (this.reading == 0) {
                    this.currentConditions.add(new FlagCondition(attributes.getValue(i), 0));
                }
                if (this.reading == 1) {
                    this.currentEitherCondition.add(new FlagCondition(attributes.getValue(i), 0));
                }
                this.profile.addFlag(attributes.getValue(i));
            }
        } else if (string3.equals("inactive")) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("flag")) continue;
                if (this.reading == 0) {
                    this.currentConditions.add(new FlagCondition(attributes.getValue(i), 1));
                }
                if (this.reading == 1) {
                    this.currentEitherCondition.add(new FlagCondition(attributes.getValue(i), 1));
                }
                this.profile.addFlag(attributes.getValue(i));
            }
        } else if (string3.equals("greater-than")) {
            String string6 = null;
            int n = 0;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("var")) {
                    string6 = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getQName(i).equals("value")) continue;
                n = Integer.parseInt(attributes.getValue(i));
            }
            if (this.reading == 0) {
                this.currentConditions.add(new VarCondition(string6, 2, n));
            }
            if (this.reading == 1) {
                this.currentEitherCondition.add(new VarCondition(string6, 2, n));
            }
            this.profile.addVar(string6);
        } else if (string3.equals("greater-equals-than")) {
            String string7 = null;
            int n = 0;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("var")) {
                    string7 = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getQName(i).equals("value")) continue;
                n = Integer.parseInt(attributes.getValue(i));
            }
            if (this.reading == 0) {
                this.currentConditions.add(new VarCondition(string7, 3, n));
            }
            if (this.reading == 1) {
                this.currentEitherCondition.add(new VarCondition(string7, 3, n));
            }
            this.profile.addVar(string7);
        } else if (string3.equals("less-than")) {
            String string8 = null;
            int n = 0;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("var")) {
                    string8 = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getQName(i).equals("value")) continue;
                n = Integer.parseInt(attributes.getValue(i));
            }
            if (this.reading == 0) {
                this.currentConditions.add(new VarCondition(string8, 6, n));
            }
            if (this.reading == 1) {
                this.currentEitherCondition.add(new VarCondition(string8, 6, n));
            }
            this.profile.addVar(string8);
        } else if (string3.equals("less-equals-than")) {
            String string9 = null;
            int n = 0;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("var")) {
                    string9 = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getQName(i).equals("value")) continue;
                n = Integer.parseInt(attributes.getValue(i));
            }
            if (this.reading == 0) {
                this.currentConditions.add(new VarCondition(string9, 5, n));
            }
            if (this.reading == 1) {
                this.currentEitherCondition.add(new VarCondition(string9, 5, n));
            }
            this.profile.addVar(string9);
        } else if (string3.equals("equals")) {
            String string10 = null;
            int n = 0;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("var")) {
                    string10 = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getQName(i).equals("value")) continue;
                n = Integer.parseInt(attributes.getValue(i));
            }
            if (this.reading == 0) {
                this.currentConditions.add(new VarCondition(string10, 4, n));
            }
            if (this.reading == 1) {
                this.currentEitherCondition.add(new VarCondition(string10, 4, n));
            }
            this.profile.addVar(string10);
        } else if (string3.equals("global-state-ref")) {
            String string11 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("id")) continue;
                string11 = attributes.getValue(i);
            }
            if (this.reading == 0) {
                this.currentConditions.add(new GlobalStateCondition(string11));
            }
            if (this.reading == 1) {
                this.currentEitherCondition.add(new GlobalStateCondition(string11));
            }
        } else if (string3.equals("set-property")) {
            String string12 = null;
            String string13 = null;
            String string14 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("id")) {
                    string12 = attributes.getValue(i);
                }
                if (attributes.getQName(i).equals("value")) {
                    string13 = attributes.getValue(i);
                }
                if (!attributes.getQName(i).equals("varName")) continue;
                string14 = attributes.getValue(i);
            }
            if (string14 == null) {
                this.currentAssessmentRule.addProperty(new AssessmentProperty(string12, string13));
            } else {
                this.currentAssessmentRule.addProperty(new AssessmentProperty(string12, string13, string14));
            }
        } else if (string3.equals("assessEffect") && this.currentAssessmentRule instanceof TimedAssessmentRule) {
            int n = Integer.MIN_VALUE;
            int n2 = Integer.MIN_VALUE;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("time-min")) {
                    n = Integer.parseInt(attributes.getValue(i));
                }
                if (!attributes.getQName(i).equals("time-max")) continue;
                n2 = Integer.parseInt(attributes.getValue(i));
            }
            TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.currentAssessmentRule;
            if (n != Integer.MIN_VALUE && n2 != Integer.MAX_VALUE) {
                timedAssessmentRule.addEffect(n, n2);
            } else {
                timedAssessmentRule.addEffect();
            }
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (string3.equals("assessment")) {
            this.chapter.addAssessmentProfile(this.profile);
        } else if (string3.equals("assessment-rule") || string3.equals("timed-assessment-rule")) {
            this.profile.addRule(this.currentAssessmentRule);
        } else if (string3.equals("concept")) {
            this.currentAssessmentRule.setConcept(this.currentString.toString().trim());
        } else if (string3.equals("condition")) {
            this.currentAssessmentRule.setConditions(this.currentConditions);
        } else if (string3.equals("init-condition")) {
            ((TimedAssessmentRule)this.currentAssessmentRule).setInitConditions(this.currentConditions);
        } else if (string3.equals("end-condition")) {
            ((TimedAssessmentRule)this.currentAssessmentRule).setEndConditions(this.currentConditions);
        } else if (string3.equals("either")) {
            this.currentConditions.add(this.currentEitherCondition);
            this.reading = 0;
        } else if (string3.equals("set-text")) {
            this.currentAssessmentRule.setText(this.currentString.toString().trim());
        }
        this.currentString = new StringBuffer();
    }

    public void characters(char[] cArray, int n, int n2) {
        this.currentString.append(new String(cArray, n, n2));
    }
}

