/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.parsers;

import es.eucm.eadventure.common.data.adventure.ChapterSummary;
import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.common.loader.InputStreamCreator;
import java.io.InputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DescriptorHandler
extends DefaultHandler {
    private static final int READING_NONE = 0;
    private static final int READING_CHAPTER = 1;
    private StringBuffer currentString = new StringBuffer();
    private DescriptorData gameDescriptor = new DescriptorData();
    private int reading = 0;
    private ChapterSummary currentChapter;
    private InputStreamCreator isCreator;

    public DescriptorHandler(InputStreamCreator inputStreamCreator) {
        this.isCreator = inputStreamCreator;
    }

    public DescriptorData getGameDescriptor() {
        return this.gameDescriptor;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        block41: {
            block43: {
                block42: {
                    block40: {
                        int n;
                        int n2;
                        int n3;
                        if (string3.equals("game-descriptor")) {
                            for (n3 = 0; n3 < attributes.getLength(); ++n3) {
                                if (!attributes.getQName(n3).equals("versionNumber")) continue;
                                this.gameDescriptor.setVersionNumber(attributes.getValue(n3));
                            }
                        }
                        if (string3.equals("configuration")) {
                            for (n3 = 0; n3 < attributes.getLength(); ++n3) {
                                if (attributes.getQName(n3).equals("keepShowing")) {
                                    this.gameDescriptor.setKeepShowing(attributes.getValue(n3).equals("yes"));
                                }
                                if (attributes.getQName(n3).equals("defaultClickAction")) {
                                    if (attributes.getValue(n3).equals("showDetails")) {
                                        this.gameDescriptor.setDeafultClickAction(DescriptorData.DefaultClickAction.SHOW_DETAILS);
                                    }
                                    if (attributes.getValue(n3).equals("showActions")) {
                                        this.gameDescriptor.setDeafultClickAction(DescriptorData.DefaultClickAction.SHOW_ACTIONS);
                                    }
                                }
                                if (!attributes.getQName(n3).equals("perspective")) continue;
                                if (attributes.getValue(n3).equals("regular")) {
                                    this.gameDescriptor.setPerspective(DescriptorData.Perspective.REGULAR);
                                }
                                if (!attributes.getValue(n3).equals("isometric")) continue;
                                this.gameDescriptor.setPerspective(DescriptorData.Perspective.ISOMETRIC);
                            }
                        }
                        if (string3.equals("gui")) {
                            n3 = 0;
                            boolean bl = false;
                            n2 = 1;
                            for (n = 0; n < attributes.getLength(); ++n) {
                                if (attributes.getQName(n).equals("type")) {
                                    if (attributes.getValue(n).equals("traditional")) {
                                        n3 = 0;
                                    } else if (attributes.getValue(n).equals("contextual")) {
                                        n3 = 1;
                                    }
                                } else if (attributes.getQName(n).equals("customized")) {
                                    bl = attributes.getValue(n).equals("yes");
                                }
                                if (!attributes.getQName(n).equals("inventoryPosition")) continue;
                                if (attributes.getValue(n).equals("none")) {
                                    n2 = 0;
                                    continue;
                                }
                                if (attributes.getValue(n).equals("top_bottom")) {
                                    n2 = 1;
                                    continue;
                                }
                                if (attributes.getValue(n).equals("top")) {
                                    n2 = 2;
                                    continue;
                                }
                                if (!attributes.getValue(n).equals("bottom")) continue;
                                n2 = 3;
                            }
                            this.gameDescriptor.setGUI(n3, bl);
                            this.gameDescriptor.setInventoryPosition(n2);
                        }
                        if (string3.equals("cursor")) {
                            String string4 = "";
                            String string5 = "";
                            for (n2 = 0; n2 < attributes.getLength(); ++n2) {
                                if (attributes.getQName(n2).equals("type")) {
                                    string4 = attributes.getValue(n2);
                                    continue;
                                }
                                if (!attributes.getQName(n2).equals("uri")) continue;
                                string5 = attributes.getValue(n2);
                            }
                            this.gameDescriptor.addCursor(string4, string5);
                        }
                        if (string3.equals("button")) {
                            String string6 = "";
                            String string7 = "";
                            String string8 = "";
                            for (n = 0; n < attributes.getLength(); ++n) {
                                if (attributes.getQName(n).equals("type")) {
                                    string6 = attributes.getValue(n);
                                    continue;
                                }
                                if (attributes.getQName(n).equals("uri")) {
                                    string7 = attributes.getValue(n);
                                    continue;
                                }
                                if (!attributes.getQName(n).equals("action")) continue;
                                string8 = attributes.getValue(n);
                            }
                            this.gameDescriptor.addButton(string8, string6, string7);
                        }
                        if (string3.equals("arrow")) {
                            String string9 = "";
                            String string10 = "";
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                if (attributes.getQName(i).equals("type")) {
                                    string9 = attributes.getValue(i);
                                    continue;
                                }
                                if (!attributes.getQName(i).equals("uri")) continue;
                                string10 = attributes.getValue(i);
                            }
                            this.gameDescriptor.addArrow(string9, string10);
                        }
                        if (string3.endsWith("automatic-commentaries")) {
                            this.gameDescriptor.setCommentaries(true);
                        }
                        if (string3.equals("mode")) {
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                if (!attributes.getQName(i).equals("playerTransparent")) continue;
                                if (attributes.getValue(i).equals("yes")) {
                                    this.gameDescriptor.setPlayerMode(0);
                                    continue;
                                }
                                if (!attributes.getValue(i).equals("no")) continue;
                                this.gameDescriptor.setPlayerMode(1);
                            }
                        }
                        if (!string3.equals("graphics")) break block40;
                        for (int i = 0; i < attributes.getLength(); ++i) {
                            if (!attributes.getQName(i).equals("mode")) continue;
                            if (attributes.getValue(i).equals("windowed")) {
                                this.gameDescriptor.setGraphicConfig(0);
                                continue;
                            }
                            if (attributes.getValue(i).equals("fullscreen")) {
                                this.gameDescriptor.setGraphicConfig(2);
                                continue;
                            }
                            if (!attributes.getValue(i).equals("blackbkg")) continue;
                            this.gameDescriptor.setGraphicConfig(1);
                        }
                        break block41;
                    }
                    if (!string3.equals("chapter")) break block42;
                    this.currentChapter = new ChapterSummary();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        if (!attributes.getQName(i).equals("path")) continue;
                        this.currentChapter.setChapterPath(attributes.getValue(i));
                    }
                    this.reading = 1;
                    break block41;
                }
                if (!string3.equals("adaptation-configuration")) break block43;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("path")) continue;
                    String string11 = attributes.getValue(i);
                    this.currentChapter.setAdaptationName(string11);
                }
                break block41;
            }
            if (!string3.equals("assessment-configuration")) break block41;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("path")) continue;
                String string12 = attributes.getValue(i);
                this.currentChapter.setAssessmentName(string12);
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("title")) {
            if (this.reading == 0) {
                this.gameDescriptor.setTitle(this.currentString.toString().trim());
            } else if (this.reading == 1) {
                this.currentChapter.setTitle(this.currentString.toString().trim());
            }
        } else if (string3.equals("description")) {
            if (this.reading == 0) {
                this.gameDescriptor.setDescription(this.currentString.toString().trim());
            } else if (this.reading == 1) {
                this.currentChapter.setDescription(this.currentString.toString().trim());
            }
        } else if (string3.equals("chapter")) {
            this.gameDescriptor.addChapterSummary(this.currentChapter);
            this.reading = 0;
        }
        this.currentString = new StringBuffer();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.currentString.append(new String(cArray, n, n2));
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        sAXParseException.printStackTrace();
        throw sAXParseException;
    }

    public InputSource resolveEntity(String string, String string2) {
        int n = string2.lastIndexOf("/") + 1;
        String string3 = string2.substring(n, string2.length());
        InputStream inputStream = this.isCreator.buildInputStream(string3);
        return new InputSource(inputStream);
    }
}

