/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.parsers;

import es.eucm.eadventure.common.data.animation.Animation;
import es.eucm.eadventure.common.data.animation.ImageLoaderFactory;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.loader.InputStreamCreator;
import es.eucm.eadventure.common.loader.subparsers.FrameSubParser;
import es.eucm.eadventure.common.loader.subparsers.SubParser;
import es.eucm.eadventure.common.loader.subparsers.TransitionSubParser;
import java.io.InputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class AnimationHandler
extends DefaultHandler {
    StringBuffer currentString;
    Resources currentResources;
    private static final int READING_NONE = 0;
    private static final int READING_TRANSITION = 1;
    private static final int READING_FRAME = 2;
    private int reading = 0;
    private SubParser subParser;
    private Animation animation;
    private InputStreamCreator isCreator;
    private ImageLoaderFactory factory;

    public AnimationHandler(InputStreamCreator inputStreamCreator, ImageLoaderFactory imageLoaderFactory) {
        this.factory = imageLoaderFactory;
        this.isCreator = inputStreamCreator;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.reading == 0) {
            int n;
            if (string3.equals("animation")) {
                for (n = 0; n < attributes.getLength(); ++n) {
                    if (attributes.getQName(n).equals("id")) {
                        this.animation = new Animation(attributes.getValue(n), this.factory);
                        this.animation.getFrames().clear();
                        this.animation.getTransitions().clear();
                    }
                    if (attributes.getQName(n).equals("slides")) {
                        if (attributes.getValue(n).equals("yes")) {
                            this.animation.setSlides(true);
                        } else {
                            this.animation.setSlides(false);
                        }
                    }
                    if (!attributes.getQName(n).equals("usetransitions")) continue;
                    if (attributes.getValue(n).equals("yes")) {
                        this.animation.setUseTransitions(true);
                        continue;
                    }
                    this.animation.setUseTransitions(false);
                }
            }
            if (string3.equals("documentation")) {
                this.currentString = new StringBuffer();
            }
            if (string3.equals("resources")) {
                this.currentResources = new Resources();
                for (n = 0; n < attributes.getLength(); ++n) {
                    if (!attributes.getQName(n).equals("name")) continue;
                    this.currentResources.setName(attributes.getValue(n));
                }
            } else if (string3.equals("asset")) {
                String string4 = "";
                String string5 = "";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("type")) {
                        string4 = attributes.getValue(i);
                    }
                    if (!attributes.getQName(i).equals("uri")) continue;
                    string5 = attributes.getValue(i);
                }
                this.currentResources.addAsset(string4, string5);
            }
            if (string3.equals("frame")) {
                this.subParser = new FrameSubParser(this.animation);
                this.reading = 2;
            }
            if (string3.equals("transition")) {
                this.subParser = new TransitionSubParser(this.animation);
                this.reading = 1;
            }
        }
        if (this.reading != 0) {
            this.subParser.startElement(string, string2, string3, attributes);
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (string3.equals("documentation")) {
            if (this.reading == 0) {
                this.animation.setDocumentation(this.currentString.toString().trim());
            }
        } else if (string3.equals("resources")) {
            this.animation.addResources(this.currentResources);
        }
        if (this.reading != 0) {
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("transition") || string3.equals("frame")) {
                this.reading = 0;
            }
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        sAXParseException.printStackTrace();
        throw sAXParseException;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.currentString.append(new String(cArray, n, n2));
        if (this.reading != 0) {
            this.subParser.characters(cArray, n, n2);
        }
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public InputSource resolveEntity(String string, String string2) {
        int n = string2.lastIndexOf("/") + 1;
        String string3 = string2.substring(n, string2.length());
        InputStream inputStream = this.isCreator.buildInputStream(string3);
        return new InputSource(inputStream);
    }
}

