/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.parsers;

import es.eucm.eadventure.common.data.adaptation.AdaptationRule;
import es.eucm.eadventure.common.data.adaptation.AdaptedState;
import es.eucm.eadventure.common.data.adaptation.UOLProperty;
import es.eucm.eadventure.common.loader.InputStreamCreator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptationHandler
extends DefaultHandler {
    private static final int NONE = 0;
    private static final int INITIAL_STATE = 1;
    private static final int ADAPTATION_RULE = 2;
    private int parsing = 0;
    private AdaptedState initialState;
    private List<AdaptationRule> externalRules;
    private AdaptationRule rule_temp;
    private List<String> flags;
    private List<String> vars;
    private StringBuffer currentString;
    private InputStreamCreator isCreator;
    private boolean scorm12;
    private boolean scorm2004;

    public AdaptationHandler(InputStreamCreator inputStreamCreator, List<AdaptationRule> list, AdaptedState adaptedState) {
        this.initialState = adaptedState;
        this.externalRules = list == null ? new ArrayList<AdaptationRule>() : list;
        this.currentString = new StringBuffer();
        this.vars = new ArrayList<String>();
        this.flags = new ArrayList<String>();
        this.isCreator = inputStreamCreator;
    }

    private void addFlag(String string) {
        if (!this.flags.contains(string)) {
            this.flags.add(string);
        }
    }

    private void addVar(String string) {
        if (!this.vars.contains(string)) {
            this.vars.add(string);
        }
    }

    public AdaptedState getInitialState() {
        return this.initialState;
    }

    public List<AdaptationRule> getAdaptationRules() {
        return this.externalRules;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n;
        if (string3.equals("adaptation")) {
            for (n = 0; n < attributes.getLength(); ++n) {
                if (attributes.getQName(n).equals("scorm12")) {
                    this.scorm12 = attributes.getValue(n).equals("yes");
                }
                if (!attributes.getQName(n).equals("scorm2004")) continue;
                this.scorm2004 = attributes.getValue(n).equals("yes");
            }
        }
        if (string3.equals("initial-state")) {
            this.parsing = 1;
        } else if (string3.equals("adaptation-rule")) {
            this.parsing = 2;
            this.rule_temp = new AdaptationRule();
        } else if (string3.equals("initial-scene")) {
            for (n = 0; n < attributes.getLength(); ++n) {
                if (!attributes.getQName(n).equals("idTarget")) continue;
                if (this.parsing == 1) {
                    this.initialState.setTargetId(attributes.getValue(n));
                    continue;
                }
                this.rule_temp.setInitialScene(attributes.getValue(n));
            }
        } else if (string3.equals("activate")) {
            for (n = 0; n < attributes.getLength(); ++n) {
                if (!attributes.getQName(n).equals("flag")) continue;
                if (this.parsing == 1) {
                    this.initialState.addActivatedFlag(attributes.getValue(n));
                } else {
                    this.rule_temp.addActivatedFlag(attributes.getValue(n));
                }
                this.addFlag(attributes.getValue(n));
            }
        } else if (string3.equals("deactivate")) {
            for (n = 0; n < attributes.getLength(); ++n) {
                if (!attributes.getQName(n).equals("flag")) continue;
                if (this.parsing == 1) {
                    this.initialState.addDeactivatedFlag(attributes.getValue(n));
                } else {
                    this.rule_temp.addDeactivatedFlag(attributes.getValue(n));
                }
                this.addFlag(attributes.getValue(n));
            }
        } else if (string3.equals("set-value")) {
            String string4 = null;
            String string5 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("var")) {
                    string4 = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getQName(i).equals("value")) continue;
                string5 = attributes.getValue(i);
            }
            if (this.parsing == 1) {
                this.initialState.addVarValue(string4, "set-value " + string5);
            } else {
                this.rule_temp.addVarValue(string4, "set-value " + string5);
            }
            this.addVar(string4);
        } else if (string3.equals("increment")) {
            String string6 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("var")) continue;
                string6 = attributes.getValue(i);
            }
            if (this.parsing == 1) {
                this.initialState.addVarValue(string6, "increment");
            } else {
                this.rule_temp.addVarValue(string6, "increment");
            }
            this.addVar(string6);
        } else if (string3.equals("decrement")) {
            String string7 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("var")) continue;
                string7 = attributes.getValue(i);
            }
            if (this.parsing == 1) {
                this.initialState.addVarValue(string7, "decrement");
            } else {
                this.rule_temp.addVarValue(string7, "decrement");
            }
            this.addVar(string7);
        } else if (string3.equals("property")) {
            String string8 = null;
            String string9 = null;
            String string10 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("id")) {
                    string8 = attributes.getValue(i);
                    continue;
                }
                if (attributes.getQName(i).equals("value")) {
                    string9 = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getQName(i).equals("operation")) continue;
                string10 = attributes.getValue(i);
            }
            this.rule_temp.addUOLProperty(new UOLProperty(string8, string9, string10));
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("initial-state")) {
            this.parsing = 0;
        } else if (string3.equals("description")) {
            this.rule_temp.setDescription(this.currentString.toString().trim());
        } else if (string3.equals("adaptation-rule")) {
            this.parsing = 0;
            this.externalRules.add(this.rule_temp);
        }
        this.currentString = new StringBuffer();
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.currentString.append(new String(cArray, n, n2));
    }

    public List<String> getFlags() {
        return this.flags;
    }

    public List<String> getVars() {
        return this.vars;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        int n = string2.lastIndexOf("/") + 1;
        String string3 = string2.substring(n, string2.length());
        InputStream inputStream = this.isCreator.buildInputStream(string3);
        return new InputSource(inputStream);
    }

    public boolean isScorm12() {
        return this.scorm12;
    }

    public boolean isScorm2004() {
        return this.scorm2004;
    }
}

