/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.incidences;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Incidence {
    public static final int XML_INCIDENCE = 0;
    public static final int ASSET_INCIDENCE = 1;
    public static final int ASSESSMENT_INCIDENCE = 0;
    public static final int ADAPTATION_INCIDENCE = 1;
    public static final int CHAPTER_INCIDENCE = 2;
    public static final int DESCRIPTOR_INCIDENCE = 3;
    public static final int IMPORTANCE_LOW = 0;
    public static final int IMPORTANCE_MEDIUM = 1;
    public static final int IMPORTANCE_HIGH = 2;
    public static final int IMPORTANCE_CRITICAL = 3;
    private int type;
    private int affectedArea;
    private String affectedResource;
    private int importance;
    private String message;
    private boolean referenced;
    private Exception exception;

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getAffectedArea() {
        return this.affectedArea;
    }

    public void setAffectedArea(int n) {
        this.affectedArea = n;
    }

    public String getAffectedResource() {
        return this.affectedResource;
    }

    public void setAffectedResource(String string) {
        this.affectedResource = string;
    }

    public int getImportance() {
        return this.importance;
    }

    public void setImportance(int n) {
        this.importance = n;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public boolean isReferenced() {
        return this.referenced;
    }

    public void setReferenced(boolean bl) {
        this.referenced = bl;
    }

    public Incidence(int n, int n2, String string, int n3, String string2, boolean bl, Exception exception) {
        this.type = n;
        this.affectedArea = n2;
        this.affectedResource = string;
        this.importance = n3;
        this.message = string2;
        this.referenced = bl;
        this.exception = exception;
    }

    public static Incidence createDescriptorIncidence(String string, Exception exception) {
        int n = 0;
        int n2 = 3;
        String string2 = "descriptor.xml";
        int n3 = 3;
        boolean bl = true;
        return new Incidence(n, n2, string2, n3, string, bl, exception);
    }

    public static Incidence createAssessmentIncidence(boolean bl, String string, String string2, Exception exception) {
        int n = 0;
        int n2 = 0;
        String string3 = string2;
        int n3 = 0;
        if (bl) {
            n3 = 1;
        }
        return new Incidence(n, n2, string3, n3, string, bl, exception);
    }

    public static Incidence createAdaptationIncidence(boolean bl, String string, String string2, Exception exception) {
        int n = 0;
        int n2 = 1;
        String string3 = string2;
        int n3 = 0;
        if (bl) {
            n3 = 1;
        }
        return new Incidence(n, n2, string3, n3, string, bl, exception);
    }

    public static Incidence createChapterIncidence(String string, String string2, Exception exception) {
        int n = 0;
        int n2 = 2;
        String string3 = string2;
        int n3 = 2;
        boolean bl = true;
        return new Incidence(n, n2, string3, n3, string, bl, exception);
    }

    public static Incidence createAssetIncidence(boolean bl, int n, String string, String string2, Exception exception) {
        int n2 = 1;
        int n3 = n;
        int n4 = 1;
        return new Incidence(n2, n3, string2, n4, string, bl, exception);
    }

    public static void sortIncidences(List<Incidence> list) {
        if (list != null && list.size() > 0) {
            Incidence.sortIncidences(list, 0);
        }
    }

    private static void sortIncidences(List<Incidence> list, int n) {
        if (list != null) {
            int n2 = list.get((int)n).importance;
            for (int i = n + 1; i < list.size() && n2 < 3; ++i) {
                if (list.get((int)i).importance <= n2) continue;
                n2 = list.get((int)i).importance;
                Incidence incidence = list.remove(n);
                list.add(n, list.get(i));
                list.add(i, incidence);
            }
        }
    }
}

