/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.gui;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class BookEditorPane
extends JEditorPane {
    private static final long serialVersionUID = 1L;

    public BookEditorPane() {
        this.setEditorKit(new BookHTMLEditorKit());
        this.setBounds(0, 0, 800, 600);
        this.setOpaque(false);
        this.setEditable(true);
    }

    public void setDocumentBase(URL uRL) {
        ((HTMLDocument)this.getDocument()).setBase(uRL);
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n3 != 0 && n4 != 0) {
            BufferedImage bufferedImage = new BufferedImage(800, 600, 2);
            super.paint(bufferedImage.createGraphics());
            Image image = bufferedImage.getScaledInstance(n3, n4, 4);
            graphics.drawImage(image, n, n2, this);
        }
    }

    public void setText(String string) {
        try {
            Document document = this.getDocument();
            document.remove(0, document.getLength());
            if (string == null || string.equals("")) {
                return;
            }
            StringReader stringReader = new StringReader(string);
            EditorKit editorKit = this.getEditorKit();
            editorKit.read(stringReader, document, 0);
        }
        catch (IOException iOException) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        }
        catch (BadLocationException badLocationException) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        }
    }

    protected class BookHTMLEditorKit
    extends HTMLEditorKit {
        private static final long serialVersionUID = 1L;

        protected BookHTMLEditorKit() {
        }

        public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
            if (document instanceof HTMLDocument) {
                HTMLDocument hTMLDocument = (HTMLDocument)document;
                HTMLEditorKit.Parser parser = this.getParser();
                if (parser == null) {
                    throw new IOException("Can't load parser");
                }
                if (n > document.getLength()) {
                    throw new BadLocationException("Invalid location", n);
                }
                HTMLEditorKit.ParserCallback parserCallback = hTMLDocument.getReader(n);
                Boolean bl = true;
                parser.parse(reader, parserCallback, bl == null ? false : bl);
                parserCallback.flush();
            } else {
                super.read(reader, document, n);
            }
        }
    }
}

