/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter.scenes;

import es.eucm.eadventure.common.data.Positioned;
import es.eucm.eadventure.common.data.chapter.ElementReference;
import es.eucm.eadventure.common.data.chapter.Exit;
import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.common.data.chapter.elements.ActiveArea;
import es.eucm.eadventure.common.data.chapter.elements.Barrier;
import es.eucm.eadventure.common.data.chapter.scenes.GeneralScene;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scene
extends GeneralScene
implements Positioned {
    public static final int PLAYER_WITHOUT_LAYER = -1;
    public static final int PLAYER_NO_ALLOWED = -2;
    public static final String RESOURCE_TYPE_BACKGROUND = "background";
    public static final String RESOURCE_TYPE_FOREGROUND = "foreground";
    public static final String RESOURCE_TYPE_HARDMAP = "hardmap";
    public static final String RESOURCE_TYPE_MUSIC = "bgmusic";
    private int defaultX = 400;
    private int defaultY = 300;
    private int playerLayer = -1;
    private boolean allowPlayerLayer = false;
    private List<Exit> exits = new ArrayList<Exit>();
    private List<ElementReference> itemReferences = new ArrayList<ElementReference>();
    private List<ElementReference> atrezzoReferences = new ArrayList<ElementReference>();
    private List<ElementReference> characterReferences = new ArrayList<ElementReference>();
    private List<ActiveArea> activeAreas = new ArrayList<ActiveArea>();
    private List<Barrier> barriers = new ArrayList<Barrier>();
    private Trajectory trajectory;
    private float playerScale = 1.0f;

    public Scene(String string) {
        super(0, string);
    }

    public Trajectory getTrajectory() {
        return this.trajectory;
    }

    public void setTrajectory(Trajectory trajectory) {
        this.trajectory = trajectory;
    }

    public boolean hasDefaultPosition() {
        return this.defaultX != Integer.MIN_VALUE && this.defaultY != Integer.MIN_VALUE;
    }

    @Override
    public int getPositionX() {
        return this.defaultX;
    }

    @Override
    public int getPositionY() {
        return this.defaultY;
    }

    public List<Exit> getExits() {
        return this.exits;
    }

    public List<ElementReference> getItemReferences() {
        return this.itemReferences;
    }

    public List<ElementReference> getAtrezzoReferences() {
        return this.atrezzoReferences;
    }

    public List<ElementReference> getCharacterReferences() {
        return this.characterReferences;
    }

    public void setDefaultPosition(int n, int n2) {
        this.defaultX = n;
        this.defaultY = n2;
    }

    public void addExit(Exit exit) {
        this.exits.add(exit);
    }

    public void addItemReference(ElementReference elementReference) {
        this.itemReferences.add(elementReference);
    }

    public void addAtrezzoReference(ElementReference elementReference) {
        this.atrezzoReferences.add(elementReference);
    }

    public void addCharacterReference(ElementReference elementReference) {
        this.characterReferences.add(elementReference);
    }

    public void addActiveArea(ActiveArea activeArea) {
        this.activeAreas.add(activeArea);
    }

    public List<ActiveArea> getActiveAreas() {
        return this.activeAreas;
    }

    public void addBarrier(Barrier barrier) {
        this.barriers.add(barrier);
    }

    public List<Barrier> getBarriers() {
        return this.barriers;
    }

    public boolean isAllowPlayerLayer() {
        return this.allowPlayerLayer;
    }

    public void setAllowPlayerLayer(boolean bl) {
        this.allowPlayerLayer = bl;
        if (!bl) {
            this.playerLayer = -2;
        }
    }

    public int getPlayerLayer() {
        return this.playerLayer;
    }

    public void setPlayerLayer(int n) {
        this.playerLayer = n;
        if (n == -2) {
            this.allowPlayerLayer = false;
        }
    }

    public void setPlayerScale(float f) {
        this.playerScale = f;
    }

    public float getPlayerScale() {
        return this.playerScale;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Scene scene = (Scene)super.clone();
        if (this.activeAreas != null) {
            scene.activeAreas = new ArrayList<ActiveArea>();
            for (ActiveArea cloneable : this.activeAreas) {
                scene.activeAreas.add((ActiveArea)cloneable.clone());
            }
        }
        scene.allowPlayerLayer = this.allowPlayerLayer;
        if (this.atrezzoReferences != null) {
            scene.atrezzoReferences = new ArrayList<ElementReference>();
            for (ElementReference elementReference : this.atrezzoReferences) {
                scene.atrezzoReferences.add((ElementReference)elementReference.clone());
            }
        }
        if (this.barriers != null) {
            scene.barriers = new ArrayList<Barrier>();
            for (Barrier barrier : this.barriers) {
                scene.barriers.add((Barrier)barrier.clone());
            }
        }
        if (this.characterReferences != null) {
            scene.characterReferences = new ArrayList<ElementReference>();
            for (ElementReference elementReference : this.characterReferences) {
                scene.characterReferences.add((ElementReference)elementReference.clone());
            }
        }
        scene.defaultX = this.defaultX;
        scene.defaultY = this.defaultY;
        if (this.exits != null) {
            scene.exits = new ArrayList<Exit>();
            for (Exit exit : this.exits) {
                scene.exits.add((Exit)exit.clone());
            }
        }
        if (this.itemReferences != null) {
            scene.itemReferences = new ArrayList<ElementReference>();
            for (ElementReference elementReference : this.itemReferences) {
                scene.itemReferences.add((ElementReference)elementReference.clone());
            }
        }
        scene.playerLayer = this.playerLayer;
        scene.playerScale = this.playerScale;
        scene.trajectory = this.trajectory != null ? (Trajectory)this.trajectory.clone() : null;
        return scene;
    }

    @Override
    public void setPositionX(int n) {
        this.defaultX = n;
    }

    @Override
    public void setPositionY(int n) {
        this.defaultY = n;
    }
}

