/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter.scenes;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.HasId;
import es.eucm.eadventure.common.data.Named;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneralScene
implements Cloneable,
Documented,
Named,
HasId {
    public static final int SCENE = 0;
    public static final int SLIDESCENE = 1;
    public static final int VIDEOSCENE = 2;
    private int type;
    private String id;
    private String name;
    private String documentation;
    private List<Resources> resources;
    private boolean initialScene;

    protected GeneralScene(int n, String string) {
        this.type = n;
        this.id = string;
        this.name = "";
        this.documentation = null;
        this.resources = new ArrayList<Resources>();
    }

    public int getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    public List<Resources> getResources() {
        return this.resources;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void setDocumentation(String string) {
        this.documentation = string;
    }

    public void addResources(Resources resources) {
        this.resources.add(resources);
    }

    public boolean isInitialScene() {
        return this.initialScene;
    }

    public void setInitialScene(boolean bl) {
        this.initialScene = bl;
    }

    public Object clone() throws CloneNotSupportedException {
        GeneralScene generalScene = (GeneralScene)super.clone();
        generalScene.documentation = this.documentation != null ? new String(this.documentation) : null;
        generalScene.id = this.id != null ? new String(this.id) : null;
        generalScene.initialScene = this.initialScene;
        String string = generalScene.name = this.name != null ? new String(this.name) : null;
        if (this.resources != null) {
            generalScene.resources = new ArrayList<Resources>();
            for (Resources resources : this.resources) {
                generalScene.resources.add((Resources)resources.clone());
            }
        }
        generalScene.type = this.type;
        return generalScene;
    }
}

