/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter.scenes;

import es.eucm.eadventure.common.data.HasTargetId;
import es.eucm.eadventure.common.data.Positioned;
import es.eucm.eadventure.common.data.chapter.NextScene;
import es.eucm.eadventure.common.data.chapter.effects.AbstractEffect;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.common.data.chapter.scenes.GeneralScene;

public abstract class Cutscene
extends GeneralScene
implements HasTargetId,
Positioned {
    public static final String RESOURCE_TYPE_VIDEO = "video";
    public static final String RESOURCE_TYPE_SLIDES = "slides";
    public static final String RESOURCE_TYPE_MUSIC = "bgmusic";
    public static final int GOBACK = 0;
    public static final int ENDCHAPTER = 1;
    public static final int NEWSCENE = 2;
    private int next = 0;
    private int transitionTime = 0;
    private int transitionType = 0;
    private int destinyX;
    private int destinyY;
    private String idTarget;
    private Effects effects = new Effects();

    protected Cutscene(int n, String string) {
        super(n, string);
        this.destinyX = Integer.MIN_VALUE;
        this.destinyY = Integer.MIN_VALUE;
    }

    public void addNextScene(NextScene nextScene) {
        this.next = 2;
        this.idTarget = nextScene.getTargetId();
        this.transitionTime = nextScene.getTransitionTime();
        this.transitionType = nextScene.getTransitionType();
        this.destinyX = nextScene.getPositionX();
        this.destinyY = nextScene.getPositionY();
        for (AbstractEffect abstractEffect : nextScene.getEffects().getEffects()) {
            this.effects.add(abstractEffect);
        }
        for (AbstractEffect abstractEffect : nextScene.getPostEffects().getEffects()) {
            this.effects.add(abstractEffect);
        }
    }

    public boolean isEndScene() {
        return this.next == 1;
    }

    public void setEndScene(boolean bl) {
        this.next = bl ? 1 : 0;
    }

    public boolean hasPlayerPosition() {
        return this.destinyX != Integer.MIN_VALUE && this.destinyY != Integer.MIN_VALUE;
    }

    public int getPositionX() {
        return this.destinyX;
    }

    public int getPositionY() {
        return this.destinyY;
    }

    public Effects getEffects() {
        return this.effects;
    }

    public void setTargetId(String string) {
        this.idTarget = string;
    }

    public String getTargetId() {
        return this.idTarget;
    }

    public void setDestinyPosition(int n, int n2) {
        this.setPositionX(n);
        this.setPositionY(n2);
    }

    public void setPositionX(int n) {
        this.destinyX = n;
    }

    public void setPositionY(int n) {
        this.destinyY = n;
    }

    public void setEffects(Effects effects) {
        this.effects = effects;
    }

    public Integer getTransitionType() {
        return this.transitionType;
    }

    public Integer getTransitionTime() {
        return this.transitionTime;
    }

    public void setTransitionType(Integer n) {
        this.transitionType = n;
    }

    public void setTransitionTime(Integer n) {
        this.transitionTime = n;
    }

    public void setNext(Integer n) {
        this.next = n;
    }

    public Integer getNext() {
        return this.next;
    }

    public Object clone() throws CloneNotSupportedException {
        Cutscene cutscene = (Cutscene)super.clone();
        cutscene.next = this.next;
        cutscene.destinyX = this.destinyX;
        cutscene.destinyY = this.destinyY;
        cutscene.effects = this.effects != null ? (Effects)this.effects.clone() : null;
        cutscene.idTarget = this.idTarget != null ? new String(this.idTarget) : null;
        return cutscene;
    }
}

