/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter.elements;

import es.eucm.eadventure.common.data.Described;
import es.eucm.eadventure.common.data.Detailed;
import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.HasId;
import es.eucm.eadventure.common.data.Named;
import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Element
implements Cloneable,
Named,
HasId,
Documented,
Described,
Detailed {
    protected String id;
    private String documentation;
    protected String name;
    protected String description;
    protected String detailedDescription;
    private List<Resources> resources;
    protected List<Action> actions;
    private boolean returnsWhenDragged;

    public Element(String string) {
        this.id = string;
        this.name = "";
        this.description = "";
        this.detailedDescription = "";
        this.returnsWhenDragged = true;
        this.resources = new ArrayList<Resources>();
        this.actions = new ArrayList<Action>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDetailedDescription() {
        return this.detailedDescription;
    }

    public List<Resources> getResources() {
        return this.resources;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public void setDocumentation(String string) {
        this.documentation = string;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public void setDetailedDescription(String string) {
        this.detailedDescription = string;
    }

    public void addResources(Resources resources) {
        this.resources.add(resources);
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public int getActionsCount() {
        if (this.actions == null) {
            return 0;
        }
        return this.actions.size();
    }

    public Action getAction(int n) {
        return this.actions.get(n);
    }

    public void setActions(ArrayList<Action> arrayList) {
        this.actions = arrayList;
    }

    public void setReturnsWhenDragged(boolean bl) {
        this.returnsWhenDragged = bl;
    }

    public boolean isReturnsWhenDragged() {
        return this.returnsWhenDragged;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append("Name: ");
        stringBuffer.append(this.name);
        stringBuffer.append("\nDescription: ");
        stringBuffer.append(this.description);
        stringBuffer.append("\nDetailed description:");
        stringBuffer.append(this.detailedDescription);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        Element element = (Element)super.clone();
        if (this.actions != null) {
            element.actions = new ArrayList<Action>();
            for (Action cloneable : this.actions) {
                element.actions.add((Action)cloneable.clone());
            }
        }
        element.description = this.description != null ? new String(this.description) : null;
        element.detailedDescription = this.detailedDescription != null ? new String(this.detailedDescription) : null;
        element.documentation = this.documentation != null ? new String(this.documentation) : null;
        element.id = this.id != null ? new String(this.id) : null;
        element.name = this.name != null ? new String(this.name) : null;
        element.returnsWhenDragged = this.returnsWhenDragged;
        if (this.resources != null) {
            element.resources = new ArrayList<Resources>();
            for (Resources resources : this.resources) {
                element.resources.add((Resources)resources.clone());
            }
        }
        return element;
    }
}

