/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter.elements;

import es.eucm.eadventure.common.data.chapter.InfluenceArea;
import es.eucm.eadventure.common.data.chapter.Rectangle;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.elements.Item;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveArea
extends Item
implements Rectangle {
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean rectangular;
    private List<Point> points;
    private Conditions conditions;
    private InfluenceArea influenceArea;

    public ActiveArea(String string, boolean bl, int n, int n2, int n3, int n4) {
        super(string);
        this.rectangular = bl;
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.points = new ArrayList<Point>();
        this.conditions = new Conditions();
        this.influenceArea = new InfluenceArea();
    }

    @Override
    public int getX() {
        if (this.rectangular) {
            return this.x;
        }
        int n = Integer.MAX_VALUE;
        for (Point point : this.points) {
            if (point.x >= n) continue;
            n = point.x;
        }
        return n;
    }

    @Override
    public int getY() {
        if (this.rectangular) {
            return this.y;
        }
        int n = Integer.MAX_VALUE;
        for (Point point : this.points) {
            if (point.y >= n) continue;
            n = point.y;
        }
        return n;
    }

    @Override
    public int getWidth() {
        if (this.rectangular) {
            return this.width;
        }
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MAX_VALUE;
        for (Point point : this.points) {
            if (point.x > n) {
                n = point.x;
            }
            if (point.x >= n2) continue;
            n2 = point.x;
        }
        return n - n2;
    }

    @Override
    public int getHeight() {
        if (this.rectangular) {
            return this.height;
        }
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MAX_VALUE;
        for (Point point : this.points) {
            if (point.y > n) {
                n = point.y;
            }
            if (point.y >= n2) continue;
            n2 = point.y;
        }
        return n - n2;
    }

    @Override
    public boolean isRectangular() {
        return this.rectangular;
    }

    @Override
    public List<Point> getPoints() {
        return this.points;
    }

    public void addPoint(Point point) {
        this.points.add(point);
    }

    @Override
    public void setValues(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ActiveArea activeArea = (ActiveArea)super.clone();
        String string = activeArea.getId() + "-" + new Random().nextInt(1000);
        activeArea.setId(string);
        activeArea.conditions = this.conditions != null ? (Conditions)this.conditions.clone() : null;
        activeArea.height = this.height;
        activeArea.width = this.width;
        activeArea.x = this.x;
        activeArea.y = this.y;
        activeArea.influenceArea = this.influenceArea != null ? (InfluenceArea)this.influenceArea.clone() : null;
        activeArea.rectangular = this.rectangular;
        activeArea.points = this.points != null ? new ArrayList() : null;
        for (Point point : this.points) {
            activeArea.points.add((Point)point.clone());
        }
        return activeArea;
    }

    @Override
    public void setRectangular(boolean bl) {
        this.rectangular = bl;
    }

    public InfluenceArea getInfluenceArea() {
        return this.influenceArea;
    }

    public void setInfluenceArea(InfluenceArea influenceArea) {
        this.influenceArea = influenceArea;
    }
}

