/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter.conversation.node;

import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.conversation.line.ConversationLine;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class OptionConversationNode
extends ConversationNode {
    private List<ConversationLine> options = new ArrayList<ConversationLine>();
    private List<ConversationNode> optionNodes = new ArrayList<ConversationNode>();
    private boolean effectConsumed = false;
    private Effects effects;
    private boolean random;
    private boolean keepShowing;
    private boolean showUserOption;
    private boolean preListening;

    public Boolean isRandom() {
        return this.random;
    }

    public void setRandom(Boolean bl) {
        this.random = bl;
    }

    public OptionConversationNode(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.random = bl;
        this.keepShowing = bl2;
        this.showUserOption = bl3;
        this.preListening = bl4;
        this.effects = new Effects();
    }

    public OptionConversationNode() {
        this(false, false, false, false);
    }

    public int getType() {
        return 1;
    }

    public boolean isTerminal() {
        return false;
    }

    public int getChildCount() {
        return this.optionNodes.size();
    }

    public ConversationNode getChild(int n) {
        return this.optionNodes.get(n);
    }

    public void addChild(ConversationNode conversationNode) {
        this.optionNodes.add(conversationNode);
    }

    public void addChild(int n, ConversationNode conversationNode) {
        this.optionNodes.add(n, conversationNode);
    }

    public ConversationNode removeChild(int n) {
        return this.optionNodes.remove(n);
    }

    public int getLineCount() {
        return this.options.size();
    }

    public ConversationLine getLine(int n) {
        return this.options.get(n);
    }

    public void addLine(ConversationLine conversationLine) {
        this.options.add(conversationLine);
    }

    public void addLine(int n, ConversationLine conversationLine) {
        this.options.add(n, conversationLine);
    }

    public ConversationLine removeLine(int n) {
        return this.options.remove(n);
    }

    public boolean hasEffects() {
        return this.hasValidEffect() && !this.effects.isEmpty();
    }

    public void setEffects(Effects effects) {
        this.effects = effects;
    }

    public Effects getEffects() {
        return this.effects;
    }

    public void consumeEffect() {
        this.effectConsumed = true;
    }

    public boolean isEffectConsumed() {
        return this.effectConsumed;
    }

    public void resetEffect() {
        this.effectConsumed = false;
    }

    public boolean hasValidEffect() {
        return this.effects != null;
    }

    public void doRandom() {
        if (this.random && this.getLineCount() > 0) {
            Random random = new Random();
            ArrayList<ConversationLine> arrayList = new ArrayList<ConversationLine>();
            ArrayList<ConversationNode> arrayList2 = new ArrayList<ConversationNode>();
            for (int i = this.getLineCount(); i > 1; --i) {
                int n = random.nextInt(i);
                arrayList.add(this.options.get(n));
                arrayList2.add(this.optionNodes.get(n));
                this.options.remove(n);
                this.optionNodes.remove(n);
            }
            arrayList.add(this.options.get(0));
            arrayList2.add(this.optionNodes.get(0));
            this.options = arrayList;
            this.optionNodes = arrayList2;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        OptionConversationNode optionConversationNode = (OptionConversationNode)super.clone();
        optionConversationNode.effectConsumed = this.effectConsumed;
        optionConversationNode.effects = this.effects != null ? (Effects)this.effects.clone() : null;
        optionConversationNode.optionNodes = new ArrayList<ConversationNode>();
        if (this.options != null) {
            optionConversationNode.options = new ArrayList<ConversationLine>();
            for (ConversationLine conversationLine : this.options) {
                optionConversationNode.options.add((ConversationLine)conversationLine.clone());
            }
        }
        optionConversationNode.random = this.random;
        optionConversationNode.keepShowing = this.keepShowing;
        optionConversationNode.showUserOption = this.showUserOption;
        return optionConversationNode;
    }

    public Conditions getLineConditions(int n) {
        return this.options.get(n).getConditions();
    }

    public ConversationLine getConversationLine(int n) {
        return this.options.get(n);
    }

    public Boolean isKeepShowing() {
        return this.keepShowing;
    }

    public void setKeepShowing(Boolean bl) {
        this.keepShowing = bl;
    }

    public Boolean isShowUserOption() {
        return this.showUserOption;
    }

    public void setShowUserOption(Boolean bl) {
        this.showUserOption = bl;
    }

    public Boolean isPreListening() {
        return this.preListening;
    }

    public void setPreListening(Boolean bl) {
        this.preListening = bl;
    }
}

