/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter.conversation.node;

import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.conversation.line.ConversationLine;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import java.util.ArrayList;
import java.util.List;

public class DialogueConversationNode
extends ConversationNode {
    private List<ConversationLine> dialogue = new ArrayList<ConversationLine>();
    private ConversationNode nextNode = null;
    private boolean terminal = true;
    private Effects effects = new Effects();
    private boolean effectConsumed = false;
    private boolean keepShowing;

    public DialogueConversationNode() {
        this(false);
    }

    public DialogueConversationNode(boolean bl) {
        this.keepShowing = bl;
    }

    public int getType() {
        return 0;
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    public int getChildCount() {
        int n = 0;
        if (this.nextNode != null) {
            ++n;
        }
        return n;
    }

    public ConversationNode getChild(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.nextNode;
    }

    public void addChild(ConversationNode conversationNode) {
        if (this.nextNode != null) {
            throw new IndexOutOfBoundsException();
        }
        this.nextNode = conversationNode;
        this.terminal = false;
    }

    public void addChild(int n, ConversationNode conversationNode) {
        if (n != 0 || this.nextNode != null) {
            throw new IndexOutOfBoundsException();
        }
        this.nextNode = conversationNode;
        this.terminal = false;
    }

    public ConversationNode removeChild(int n) {
        if (n != 0 || this.nextNode == null) {
            throw new IndexOutOfBoundsException();
        }
        ConversationNode conversationNode = this.nextNode;
        this.nextNode = null;
        this.terminal = true;
        return conversationNode;
    }

    public int getLineCount() {
        return this.dialogue.size();
    }

    public ConversationLine getLine(int n) {
        return this.dialogue.get(n);
    }

    public void addLine(ConversationLine conversationLine) {
        this.dialogue.add(conversationLine);
    }

    public void addLine(int n, ConversationLine conversationLine) {
        this.dialogue.add(n, conversationLine);
    }

    public ConversationLine removeLine(int n) {
        return this.dialogue.remove(n);
    }

    public boolean hasEffects() {
        return this.hasValidEffect() && !this.effects.isEmpty();
    }

    public void setEffects(Effects effects) {
        this.effects = effects;
    }

    public Effects getEffects() {
        return this.effects;
    }

    public void consumeEffect() {
        this.effectConsumed = true;
    }

    public boolean isEffectConsumed() {
        return this.effectConsumed;
    }

    public void resetEffect() {
        this.effectConsumed = false;
    }

    public boolean hasValidEffect() {
        return this.effects != null;
    }

    public Object clone() throws CloneNotSupportedException {
        DialogueConversationNode dialogueConversationNode = (DialogueConversationNode)super.clone();
        if (this.dialogue != null) {
            dialogueConversationNode.dialogue = new ArrayList<ConversationLine>();
            for (ConversationLine conversationLine : this.dialogue) {
                dialogueConversationNode.dialogue.add((ConversationLine)conversationLine.clone());
            }
        }
        dialogueConversationNode.effectConsumed = this.effectConsumed;
        dialogueConversationNode.effects = this.effects != null ? (Effects)this.effects.clone() : null;
        dialogueConversationNode.nextNode = null;
        dialogueConversationNode.terminal = this.terminal;
        dialogueConversationNode.keepShowing = this.keepShowing;
        return dialogueConversationNode;
    }

    public Conditions getLineConditions(int n) {
        return this.dialogue.get(n).getConditions();
    }

    public ConversationLine getConversationLine(int n) {
        return this.dialogue.get(n);
    }

    public Boolean isKeepShowing() {
        return this.keepShowing;
    }

    public void setKeepShowing(Boolean bl) {
        this.keepShowing = bl;
    }
}

