/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter.conversation;

import es.eucm.eadventure.common.data.HasId;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Conversation
implements Cloneable,
HasId {
    public static final int TREE = 0;
    public static final int GRAPH = 1;
    private int conversationType;
    private String conversationId;
    private ConversationNode root;

    protected Conversation(int n, String string, ConversationNode conversationNode) {
        this.conversationType = n;
        this.conversationId = string;
        this.root = conversationNode;
    }

    public int getType() {
        return this.conversationType;
    }

    @Override
    public String getId() {
        return this.conversationId;
    }

    public ConversationNode getRootNode() {
        return this.root;
    }

    @Override
    public void setId(String string) {
        this.conversationId = string;
    }

    public List<ConversationNode> getAllNodes() {
        ArrayList<ConversationNode> arrayList = new ArrayList<ConversationNode>();
        this.getAllNodes(this.root, arrayList);
        return arrayList;
    }

    private void getAllNodes(ConversationNode conversationNode, List<ConversationNode> list) {
        for (int i = -1; i < conversationNode.getChildCount(); ++i) {
            ConversationNode conversationNode2 = null;
            conversationNode2 = i == -1 ? conversationNode : conversationNode.getChild(i);
            boolean bl = false;
            for (ConversationNode conversationNode3 : list) {
                if (conversationNode3 != conversationNode2) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            list.add(conversationNode2);
            this.getAllNodes(conversationNode2, list);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Conversation conversation = (Conversation)super.clone();
        conversation.conversationId = this.conversationId != null ? new String(this.conversationId) : null;
        conversation.conversationType = this.conversationType;
        HashMap<ConversationNode, ConversationNode> hashMap = new HashMap<ConversationNode, ConversationNode>();
        conversation.root = this.root != null ? (ConversationNode)this.root.clone() : null;
        hashMap.put(this.root, conversation.root);
        ArrayList<ConversationNode> arrayList = new ArrayList<ConversationNode>();
        ArrayList<ConversationNode> arrayList2 = new ArrayList<ConversationNode>();
        arrayList.add(this.root);
        while (!arrayList.isEmpty()) {
            ConversationNode conversationNode = (ConversationNode)arrayList.get(0);
            ConversationNode conversationNode2 = (ConversationNode)hashMap.get(conversationNode);
            arrayList.remove(0);
            arrayList2.add(conversationNode);
            for (int i = 0; i < conversationNode.getChildCount(); ++i) {
                ConversationNode conversationNode3 = (ConversationNode)hashMap.get(conversationNode.getChild(i));
                if (conversationNode3 == null) {
                    conversationNode3 = (ConversationNode)conversationNode.getChild(i).clone();
                    hashMap.put(conversationNode.getChild(i), conversationNode3);
                }
                conversationNode2.addChild(conversationNode3);
                if (arrayList2.contains(conversationNode.getChild(i)) || arrayList.contains(conversationNode.getChild(i))) continue;
                arrayList.add(conversationNode.getChild(i));
            }
        }
        return conversation;
    }
}

