/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trajectory
implements Cloneable {
    List<Node> nodes = new ArrayList<Node>();
    List<Side> sides = new ArrayList<Side>();
    Node initial = null;

    public Node addNode(String string, int n, int n2, float f) {
        Node node = new Node(string, n, n2, f);
        if (this.nodes.contains(node)) {
            node = this.nodes.get(this.nodes.indexOf(node));
        } else {
            this.nodes.add(node);
        }
        if (this.nodes.size() == 1) {
            this.initial = this.nodes.get(0);
        }
        return node;
    }

    public Side addSide(String string, String string2, int n) {
        if (string.equals(string2)) {
            return null;
        }
        Side side = new Side(string, string2);
        Node node = this.getNodeForId(string);
        Node node2 = this.getNodeForId(string2);
        if (node != null && node2 != null) {
            int n2 = node.getX() - node2.getX();
            int n3 = node.getY() - node2.getY();
            if (n == -1) {
                side.setLenght((float)Math.sqrt(n2 * n2 + n3 * n3));
            } else {
                side.setLenght(n);
            }
            side.setRealLength((float)Math.sqrt(n2 * n2 + n3 * n3));
        }
        if (this.sides.contains(side)) {
            return null;
        }
        this.sides.add(side);
        return side;
    }

    public void removeNode(Node node) {
        if (this.nodes.contains(node)) {
            node = this.nodes.get(this.nodes.indexOf(node));
            int n = 0;
            while (n < this.sides.size()) {
                Side side = this.sides.get(n);
                if (side.getIDEnd().equals(node.getID()) || side.getIDStart().equals(node.getID())) {
                    this.sides.remove(n);
                    continue;
                }
                ++n;
            }
        }
        this.nodes.remove(node);
    }

    public void removeNode(int n, int n2) {
        Node node = new Node("id", n, n2, 1.0f);
        if (this.nodes.contains(node)) {
            node = this.nodes.get(this.nodes.indexOf(node));
            int n3 = 0;
            while (n3 < this.sides.size()) {
                Side side = this.sides.get(n3);
                if (side.getIDEnd().equals(node.getID()) || side.getIDStart().equals(node.getID())) {
                    this.sides.remove(n3);
                    continue;
                }
                ++n3;
            }
            this.nodes.remove(node);
        }
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Side> getSides() {
        return this.sides;
    }

    public Node getNodeForId(String string) {
        if (string == null) {
            return null;
        }
        for (Node node : this.nodes) {
            if (!string.equals(node.id)) continue;
            return node;
        }
        return null;
    }

    public void setInitial(String string) {
        this.initial = this.getNodeForId(string);
    }

    public Node getInitial() {
        return this.initial;
    }

    public void deleteUnconnectedNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (this.initial == null && this.nodes.size() > 0) {
            this.initial = this.nodes.get(0);
        }
        arrayList.add(this.initial);
        int n = 0;
        while (n < arrayList.size()) {
            Node node = (Node)arrayList.get(n);
            ++n;
            for (Side side : this.sides) {
                Node node2;
                if (side.getIDEnd().equals(node.getID()) && (node2 = this.getNodeForId(side.getIDStart())) != null && !arrayList.contains(node2)) {
                    arrayList.add(node2);
                }
                if (!side.getIDStart().equals(node.getID()) || (node2 = this.getNodeForId(side.getIDEnd())) == null || arrayList.contains(node2)) continue;
                arrayList.add(node2);
            }
        }
        n = 0;
        while (n < this.nodes.size()) {
            if (!arrayList.contains(this.nodes.get(n))) {
                int n2 = 0;
                while (n2 < this.sides.size()) {
                    if (this.sides.get(n2).getIDEnd().equals(this.nodes.get(n).getID())) {
                        this.sides.remove(n2);
                        continue;
                    }
                    if (this.sides.get(n2).getIDStart().equals(this.nodes.get(n).getID())) {
                        this.sides.remove(n2);
                        continue;
                    }
                    ++n2;
                }
                this.nodes.remove(n);
                continue;
            }
            ++n;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Object object;
        Trajectory trajectory = (Trajectory)super.clone();
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        String string = this.initial.getID();
        trajectory.initial = this.initial != null ? (Node)this.initial.clone() : null;
        hashMap.put(string, trajectory.initial.getID());
        if (this.nodes != null) {
            trajectory.nodes = new ArrayList<Node>();
            for (Node cloneable : this.nodes) {
                if (cloneable.getID().equals(string)) {
                    trajectory.nodes.add(trajectory.initial);
                    continue;
                }
                object = cloneable.getID();
                Node node = (Node)cloneable.clone();
                trajectory.nodes.add(node);
                hashMap.put(object, node.getID());
            }
        }
        if (this.sides != null) {
            trajectory.sides = new ArrayList<Side>();
            for (Side side : this.sides) {
                object = new Side((String)hashMap.get(side.getIDStart()), (String)hashMap.get(side.getIDEnd()));
                ((Side)object).setLenght(side.getLength());
                ((Side)object).setRealLength(side.getRealLength());
                trajectory.sides.add((Side)object);
            }
        }
        return trajectory;
    }

    public class Side
    implements Cloneable {
        private String idStart;
        private String idEnd;
        private float length = 1.0f;
        private float realLength = 1.0f;

        public Side(String string, String string2) {
            this.idStart = string;
            this.idEnd = string2;
        }

        public void setRealLength(float f) {
            this.realLength = f;
        }

        public String getIDStart() {
            return this.idStart;
        }

        public String getIDEnd() {
            return this.idEnd;
        }

        public void setLenght(float f) {
            this.length = f;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof Side) {
                Side side = (Side)object;
                if (side.idEnd.equals(this.idEnd) && side.idStart.equals(this.idStart)) {
                    return true;
                }
            }
            return false;
        }

        public float getLength() {
            return this.length;
        }

        public Object clone() throws CloneNotSupportedException {
            Side side = (Side)super.clone();
            side.idEnd = this.idEnd != null ? new String(this.idEnd) : null;
            side.idStart = this.idStart != null ? new String(this.idStart) : null;
            side.length = this.length;
            return side;
        }

        public float getRealLength() {
            return this.realLength;
        }
    }

    public class Node
    implements Cloneable {
        private String id;
        private int x;
        private int y;
        private float scale;

        public Node(String string, int n, int n2, float f) {
            this.id = string;
            this.x = n;
            this.y = n2;
            this.scale = f;
        }

        public String getID() {
            return this.id;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public float getScale() {
            return this.scale;
        }

        public void setScale(float f) {
            this.scale = f;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof Node) {
                Node node = (Node)object;
                if (node.id.equals(this.id)) {
                    return true;
                }
                if (node.x == this.x && node.y == this.y) {
                    return true;
                }
            }
            return false;
        }

        public void setValues(int n, int n2, float f) {
            this.x = n;
            this.y = n2;
            this.scale = f;
        }

        public Object clone() throws CloneNotSupportedException {
            Node node = (Node)super.clone();
            node.id = "node" + new Random().nextInt(10000);
            node.scale = this.scale;
            node.x = this.x;
            node.y = this.y;
            return node;
        }
    }
}

