/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import java.awt.Color;

public class Timer
implements Cloneable,
Documented {
    public static final long DEFAULT_SECONDS = 60L;
    private long seconds;
    private Conditions initCond;
    private Conditions endCond;
    private Effects effect;
    private Effects postEffect;
    private String documentation;
    private Boolean usesEndCondition;
    private Boolean runsInLoop;
    private Boolean multipleStarts;
    private Boolean showTime;
    private String displayName;
    private Boolean countDown;
    private Boolean showWhenStopped;
    private Color fontColor = Color.BLACK;
    private Color borderColor = Color.WHITE;

    public Timer(long l, Conditions conditions, Conditions conditions2, Effects effects, Effects effects2) {
        this.seconds = l;
        this.initCond = conditions;
        this.endCond = conditions2;
        this.effect = effects;
        this.postEffect = effects2;
        this.usesEndCondition = true;
        this.runsInLoop = true;
        this.multipleStarts = true;
        this.showTime = false;
        this.displayName = "timer";
        this.countDown = true;
        this.showWhenStopped = false;
    }

    public Timer(long l) {
        this(l, new Conditions(), new Conditions(), new Effects(), new Effects());
    }

    public Timer() {
        this(60L);
    }

    public Long getTime() {
        return this.seconds;
    }

    public void setTime(Long l) {
        this.seconds = l;
    }

    public Conditions getInitCond() {
        return this.initCond;
    }

    public void setInitCond(Conditions conditions) {
        this.initCond = conditions;
    }

    public Conditions getEndCond() {
        return this.endCond;
    }

    public void setEndCond(Conditions conditions) {
        this.endCond = conditions;
    }

    public Effects getEffects() {
        return this.effect;
    }

    public void setEffects(Effects effects) {
        this.effect = effects;
    }

    public Effects getPostEffects() {
        return this.postEffect;
    }

    public void setPostEffects(Effects effects) {
        this.postEffect = effects;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String string) {
        this.documentation = string;
    }

    public Boolean isUsesEndCondition() {
        return this.usesEndCondition;
    }

    public void setUsesEndCondition(Boolean bl) {
        this.usesEndCondition = bl;
    }

    public Boolean isRunsInLoop() {
        return this.runsInLoop;
    }

    public void setRunsInLoop(Boolean bl) {
        this.runsInLoop = bl;
    }

    public Boolean isMultipleStarts() {
        return this.multipleStarts;
    }

    public void setMultipleStarts(Boolean bl) {
        this.multipleStarts = bl;
    }

    public Boolean isCountDown() {
        return this.countDown;
    }

    public void setCountDown(Boolean bl) {
        this.countDown = bl;
    }

    public Boolean isShowWhenStopped() {
        return this.showWhenStopped;
    }

    public void setShowWhenStopped(Boolean bl) {
        this.showWhenStopped = bl;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public Boolean isShowTime() {
        return this.showTime;
    }

    public void setShowTime(Boolean bl) {
        this.showTime = bl;
    }

    public Object clone() throws CloneNotSupportedException {
        Timer timer = (Timer)super.clone();
        timer.documentation = this.documentation != null ? new String(this.documentation) : null;
        timer.effect = this.effect != null ? (Effects)this.effect.clone() : null;
        timer.endCond = this.endCond != null ? (Conditions)this.endCond.clone() : null;
        timer.initCond = this.initCond != null ? (Conditions)this.initCond.clone() : null;
        timer.postEffect = this.postEffect != null ? (Effects)this.postEffect.clone() : null;
        timer.seconds = this.seconds;
        timer.runsInLoop = this.runsInLoop;
        timer.multipleStarts = this.multipleStarts;
        timer.usesEndCondition = this.usesEndCondition;
        return timer;
    }
}

