/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter;

import es.eucm.eadventure.common.data.HasTargetId;
import es.eucm.eadventure.common.data.adaptation.AdaptationProfile;
import es.eucm.eadventure.common.data.adventure.ChapterSummary;
import es.eucm.eadventure.common.data.assessment.AssessmentProfile;
import es.eucm.eadventure.common.data.chapter.Timer;
import es.eucm.eadventure.common.data.chapter.book.Book;
import es.eucm.eadventure.common.data.chapter.conditions.GlobalState;
import es.eucm.eadventure.common.data.chapter.conversation.Conversation;
import es.eucm.eadventure.common.data.chapter.effects.Macro;
import es.eucm.eadventure.common.data.chapter.elements.Atrezzo;
import es.eucm.eadventure.common.data.chapter.elements.Item;
import es.eucm.eadventure.common.data.chapter.elements.NPC;
import es.eucm.eadventure.common.data.chapter.elements.Player;
import es.eucm.eadventure.common.data.chapter.scenes.Cutscene;
import es.eucm.eadventure.common.data.chapter.scenes.GeneralScene;
import es.eucm.eadventure.common.data.chapter.scenes.Scene;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chapter
extends ChapterSummary
implements HasTargetId {
    private String initialScene;
    private List<Scene> scenes;
    private List<Cutscene> cutscenes;
    private List<Book> books;
    private List<Item> items;
    private List<Atrezzo> atrezzo;
    private Player player;
    private List<NPC> characters;
    private List<Conversation> conversations;
    private List<Timer> timers;
    private List<String> flags;
    private List<String> vars;
    private List<GlobalState> globalStates;
    private List<Macro> macros;

    public Chapter() {
        this.scenes = new ArrayList<Scene>();
        this.cutscenes = new ArrayList<Cutscene>();
        this.books = new ArrayList<Book>();
        this.items = new ArrayList<Item>();
        this.atrezzo = new ArrayList<Atrezzo>();
        this.player = new Player();
        this.characters = new ArrayList<NPC>();
        this.conversations = new ArrayList<Conversation>();
        this.timers = new ArrayList<Timer>();
        this.flags = new ArrayList<String>();
        this.vars = new ArrayList<String>();
        this.globalStates = new ArrayList<GlobalState>();
        this.macros = new ArrayList<Macro>();
    }

    public Chapter(String string, String string2) {
        super(string);
        this.initialScene = string2;
        this.scenes = new ArrayList<Scene>();
        this.cutscenes = new ArrayList<Cutscene>();
        this.books = new ArrayList<Book>();
        this.items = new ArrayList<Item>();
        this.atrezzo = new ArrayList<Atrezzo>();
        this.player = new Player();
        this.characters = new ArrayList<NPC>();
        this.conversations = new ArrayList<Conversation>();
        this.timers = new ArrayList<Timer>();
        this.scenes.add(new Scene(string2));
        this.globalStates = new ArrayList<GlobalState>();
        this.macros = new ArrayList<Macro>();
        this.flags = new ArrayList<String>();
        this.vars = new ArrayList<String>();
    }

    @Override
    public String getTargetId() {
        return this.initialScene;
    }

    public GeneralScene getInitialGeneralScene() {
        GeneralScene generalScene = null;
        if (this.initialScene != null) {
            generalScene = this.getGeneralScene(this.initialScene);
        }
        if (generalScene == null) {
            for (int i = 0; i < this.getGeneralScenes().size() && generalScene == null; ++i) {
                if (!this.getGeneralScenes().get(i).isInitialScene()) continue;
                generalScene = this.getGeneralScenes().get(i);
            }
            if (generalScene == null) {
                generalScene = this.getGeneralScenes().get(0);
            }
        }
        return generalScene;
    }

    public List<Scene> getScenes() {
        return this.scenes;
    }

    public List<Cutscene> getCutscenes() {
        return this.cutscenes;
    }

    public List<Book> getBooks() {
        return this.books;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public List<Atrezzo> getAtrezzo() {
        return this.atrezzo;
    }

    public Player getPlayer() {
        return this.player;
    }

    public List<NPC> getCharacters() {
        return this.characters;
    }

    public List<Conversation> getConversations() {
        return this.conversations;
    }

    @Override
    public void setTargetId(String string) {
        this.initialScene = string;
    }

    public void addScene(Scene scene) {
        this.scenes.add(scene);
    }

    public void addCutscene(Cutscene cutscene) {
        this.cutscenes.add(cutscene);
    }

    public void addBook(Book book) {
        this.books.add(book);
    }

    public void addItem(Item item) {
        this.items.add(item);
    }

    public void addAtrezzo(Atrezzo atrezzo) {
        this.atrezzo.add(atrezzo);
    }

    public void addGlobalState(GlobalState globalState) {
        this.globalStates.add(globalState);
    }

    public void addMacro(Macro macro) {
        this.macros.add(macro);
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void addCharacter(NPC nPC) {
        this.characters.add(nPC);
    }

    public void addConversation(Conversation conversation) {
        this.conversations.add(conversation);
    }

    public void addTimer(Timer timer) {
        this.timers.add(timer);
    }

    public Scene getScene(String string) {
        Scene scene = null;
        for (Scene scene2 : this.scenes) {
            if (!scene2.getId().equals(string)) continue;
            scene = scene2;
        }
        return scene;
    }

    public Cutscene getCutscene(String string) {
        Cutscene cutscene = null;
        for (Cutscene cutscene2 : this.cutscenes) {
            if (!cutscene2.getId().equals(string)) continue;
            cutscene = cutscene2;
        }
        return cutscene;
    }

    public Item getItem(String string) {
        Item item = null;
        for (Item item2 : this.items) {
            if (!item2.getId().equals(string)) continue;
            item = item2;
        }
        return item;
    }

    public Atrezzo getAtrezzo(String string) {
        Atrezzo atrezzo = null;
        for (Atrezzo atrezzo2 : this.atrezzo) {
            if (!atrezzo2.getId().equals(string)) continue;
            atrezzo = atrezzo2;
        }
        return atrezzo;
    }

    public NPC getCharacter(String string) {
        NPC nPC = null;
        for (NPC nPC2 : this.characters) {
            if (!nPC2.getId().equals(string)) continue;
            nPC = nPC2;
        }
        return nPC;
    }

    public GlobalState getGlobalState(String string) {
        GlobalState globalState = null;
        for (GlobalState globalState2 : this.globalStates) {
            if (!globalState2.getId().equals(string)) continue;
            globalState = globalState2;
        }
        return globalState;
    }

    public Macro getMacro(String string) {
        Macro macro = null;
        for (Macro macro2 : this.macros) {
            if (!macro2.getId().equals(string)) continue;
            macro = macro2;
        }
        return macro;
    }

    public List<Timer> getTimers() {
        return this.timers;
    }

    public void setTimers(List<Timer> list) {
        this.timers = list;
    }

    public List<String> getFlags() {
        return this.flags;
    }

    public List<String> getVars() {
        return this.vars;
    }

    public void addFlag(String string) {
        if (!this.flags.contains(string)) {
            this.flags.add(string);
        }
    }

    public void addVar(String string) {
        if (!this.vars.contains(string)) {
            this.vars.add(string);
        }
    }

    public GeneralScene getGeneralScene(String string) {
        GeneralScene generalScene = this.getScene(string);
        if (generalScene == null) {
            generalScene = this.getCutscene(string);
        }
        return generalScene;
    }

    public List<GeneralScene> getGeneralScenes() {
        ArrayList<GeneralScene> arrayList = new ArrayList<GeneralScene>();
        for (Scene generalScene : this.scenes) {
            arrayList.add(generalScene);
        }
        for (Cutscene cutscene : this.cutscenes) {
            arrayList.add(cutscene);
        }
        return arrayList;
    }

    public Book getBook(String string) {
        Book book = null;
        for (Book book2 : this.books) {
            if (!book2.getId().equals(string)) continue;
            book = book2;
        }
        return book;
    }

    public Conversation getConversation(String string) {
        Conversation conversation = null;
        for (Conversation conversation2 : this.conversations) {
            if (!conversation2.getId().equals(string)) continue;
            conversation = conversation2;
        }
        return conversation;
    }

    public boolean isCutscene(String string) {
        return this.getCutscene(string) != null;
    }

    public List<GlobalState> getGlobalStates() {
        return this.globalStates;
    }

    public void setGlobalStates(List<GlobalState> list) {
        this.globalStates = list;
    }

    public List<Macro> getMacros() {
        return this.macros;
    }

    public void setMacros(List<Macro> list) {
        this.macros = list;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Chapter chapter = (Chapter)super.clone();
        if (this.atrezzo != null) {
            chapter.atrezzo = new ArrayList<Atrezzo>();
            for (Atrezzo object : this.atrezzo) {
                chapter.atrezzo.add((Atrezzo)object.clone());
            }
        }
        if (this.books != null) {
            chapter.books = new ArrayList<Book>();
            for (Book book : this.books) {
                chapter.books.add((Book)book.clone());
            }
        }
        if (this.characters != null) {
            chapter.characters = new ArrayList<NPC>();
            for (NPC nPC : this.characters) {
                chapter.characters.add((NPC)nPC.clone());
            }
        }
        if (this.conversations != null) {
            chapter.conversations = new ArrayList<Conversation>();
            for (Conversation conversation : this.conversations) {
                chapter.conversations.add((Conversation)conversation.clone());
            }
        }
        if (this.cutscenes != null) {
            chapter.cutscenes = new ArrayList<Cutscene>();
            for (Cutscene cutscene : this.cutscenes) {
                chapter.cutscenes.add((Cutscene)cutscene.clone());
            }
        }
        if (this.flags != null) {
            chapter.flags = new ArrayList<String>();
            for (String string : this.flags) {
                chapter.flags.add(new String(string));
            }
        }
        if (this.globalStates != null) {
            chapter.globalStates = new ArrayList<GlobalState>();
            for (GlobalState globalState : this.globalStates) {
                chapter.globalStates.add((GlobalState)globalState.clone());
            }
        }
        String string = chapter.initialScene = this.initialScene != null ? new String(this.initialScene) : null;
        if (this.items != null) {
            chapter.items = new ArrayList<Item>();
            for (Item item : this.items) {
                chapter.items.add((Item)item.clone());
            }
        }
        if (this.macros != null) {
            chapter.macros = new ArrayList<Macro>();
            for (Macro macro : this.macros) {
                chapter.macros.add((Macro)macro.clone());
            }
        }
        Player player = chapter.player = this.player != null ? (Player)this.player.clone() : null;
        if (this.scenes != null) {
            chapter.scenes = new ArrayList<Scene>();
            for (Scene scene : this.scenes) {
                chapter.scenes.add((Scene)scene.clone());
            }
        }
        if (this.timers != null) {
            chapter.timers = new ArrayList<Timer>();
            for (Timer timer : this.timers) {
                chapter.timers.add((Timer)timer.clone());
            }
        }
        if (this.vars != null) {
            chapter.vars = new ArrayList<String>();
            for (String string2 : this.vars) {
                chapter.vars.add(new String(string2));
            }
        }
        if (this.assessmentProfiles != null) {
            chapter.assessmentProfiles = new ArrayList();
            for (AssessmentProfile assessmentProfile : this.assessmentProfiles) {
                chapter.assessmentProfiles.add(assessmentProfile);
            }
        }
        if (this.adaptationProfiles != null) {
            chapter.adaptationProfiles = new ArrayList();
            for (AdaptationProfile adaptationProfile : this.adaptationProfiles) {
                chapter.adaptationProfiles.add(adaptationProfile);
            }
        }
        return chapter;
    }
}

