/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.assessment;

import es.eucm.eadventure.common.data.HasId;
import es.eucm.eadventure.common.data.assessment.AssessmentEffect;
import es.eucm.eadventure.common.data.assessment.AssessmentProperty;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssessmentRule
implements Cloneable,
HasId {
    public static final int N_IMPORTANCE_VALUES = 5;
    public static final int IMPORTANCE_VERY_LOW = 0;
    public static final int IMPORTANCE_LOW = 1;
    public static final int IMPORTANCE_NORMAL = 2;
    public static final int IMPORTANCE_HIGH = 3;
    public static final int IMPORTANCE_VERY_HIGH = 4;
    public static final String[] IMPORTANCE_VALUES = new String[]{"verylow", "low", "normal", "high", "veryhigh"};
    protected String id;
    protected int importance;
    protected String concept;
    protected Conditions conditions;
    protected AssessmentEffect effect;
    protected boolean repeatRule;

    public AssessmentRule(String string, int n, boolean bl) {
        this.id = string;
        this.importance = n;
        this.concept = null;
        this.conditions = new Conditions();
        this.effect = new AssessmentEffect();
        this.repeatRule = bl;
    }

    public void setConcept(String string) {
        this.concept = string;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public void setText(String string) {
        this.effect.setText(string);
    }

    public void addProperty(AssessmentProperty assessmentProperty) {
        this.effect.getAssessmentProperties().add(assessmentProperty);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Integer getImportance() {
        return this.importance;
    }

    public String getConcept() {
        return this.concept;
    }

    public String getText() {
        return this.effect.getText();
    }

    public List<AssessmentProperty> getAssessmentProperties() {
        return this.effect.getAssessmentProperties();
    }

    public void setImportance(Integer n) {
        this.importance = n;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    public Boolean isRepeatRule() {
        return this.repeatRule;
    }

    public void setRepeatRule(Boolean bl) {
        this.repeatRule = bl;
    }

    public Object clone() throws CloneNotSupportedException {
        AssessmentRule assessmentRule = (AssessmentRule)super.clone();
        String string = assessmentRule.concept = this.concept != null ? new String(this.concept) : null;
        if (this.conditions != null) {
            assessmentRule.conditions = (Conditions)this.conditions.clone();
        }
        if (this.effect != null) {
            assessmentRule.effect = (AssessmentEffect)this.effect.clone();
        }
        assessmentRule.id = this.id != null ? new String(this.id) : null;
        assessmentRule.importance = this.importance;
        assessmentRule.repeatRule = this.repeatRule;
        return assessmentRule;
    }
}

