/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.assessment;

import es.eucm.eadventure.common.data.assessment.AssessmentRule;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssessmentProfile
implements Cloneable {
    public static final String EQUALS = "eq";
    public static final String GRATER = "gt";
    public static final String LESS = "lt";
    public static final String GRATER_EQ = "ge";
    public static final String LESS_EQ = "le";
    private String name;
    private List<AssessmentRule> rules;
    private List<String> flags;
    private List<String> vars;
    private boolean scorm2004;
    private boolean scorm12;
    private boolean showReportAtEnd;
    private boolean sendByEmail;
    private String email;
    private boolean smtpSSL;
    private String smtpServer;
    private String smtpPort;
    private String smtpUser;
    private String smtpPwd;

    public AssessmentProfile() {
        this(new ArrayList<AssessmentRule>(), null);
    }

    public AssessmentProfile(String string) {
        this(new ArrayList<AssessmentRule>(), string);
    }

    public AssessmentProfile(List<AssessmentRule> list, String string) {
        this.rules = list;
        this.name = string;
        this.flags = new ArrayList<String>();
        this.vars = new ArrayList<String>();
        this.sendByEmail = false;
        this.email = "";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List<AssessmentRule> getRules() {
        return this.rules;
    }

    public void addRule(AssessmentRule assessmentRule) {
        this.rules.add(assessmentRule);
    }

    public void addRule(AssessmentRule assessmentRule, int n) {
        this.rules.add(n, assessmentRule);
    }

    public void setRules(List<AssessmentRule> list) {
        this.rules = list;
    }

    public void addFlag(String string) {
        if (!this.flags.contains(string)) {
            this.flags.add(string);
        }
    }

    public void addVar(String string) {
        if (!this.vars.contains(string)) {
            this.vars.add(string);
        }
    }

    public List<String> getFlags() {
        return this.flags;
    }

    public List<String> getVars() {
        return this.vars;
    }

    public void setFlags(List<String> list) {
        this.flags = list;
    }

    public void setVars(List<String> list) {
        this.vars = list;
    }

    public boolean isShowReportAtEnd() {
        return this.showReportAtEnd;
    }

    public void setShowReportAtEnd(boolean bl) {
        this.showReportAtEnd = bl;
    }

    public boolean isSendByEmail() {
        return this.sendByEmail;
    }

    public void setSendByEmail(boolean bl) {
        this.sendByEmail = bl;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String string) {
        this.email = string;
    }

    public void setSmtpSSL(boolean bl) {
        this.smtpSSL = bl;
    }

    public void setSmtpPort(String string) {
        this.smtpPort = string;
    }

    public void setSmtpUser(String string) {
        this.smtpUser = string;
    }

    public void setSmtpPwd(String string) {
        this.smtpPwd = string;
    }

    public boolean isSmtpSSL() {
        return this.smtpSSL;
    }

    public String getSmtpPort() {
        return this.smtpPort;
    }

    public String getSmtpUser() {
        return this.smtpUser;
    }

    public String getSmtpPwd() {
        return this.smtpPwd;
    }

    public void setSmtpServer(String string) {
        this.smtpServer = string;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public Object clone() throws CloneNotSupportedException {
        AssessmentProfile assessmentProfile = (AssessmentProfile)super.clone();
        String string = assessmentProfile.email = this.email != null ? new String(this.email) : null;
        if (this.flags != null) {
            assessmentProfile.flags = new ArrayList<String>();
            for (String object : this.flags) {
                assessmentProfile.flags.add(object != null ? new String(object) : null);
            }
        }
        String string2 = assessmentProfile.name = this.name != null ? new String(this.name) : null;
        if (this.rules != null) {
            assessmentProfile.rules = new ArrayList<AssessmentRule>();
            for (AssessmentRule assessmentRule : this.rules) {
                assessmentProfile.rules.add((AssessmentRule)assessmentRule.clone());
            }
        }
        assessmentProfile.sendByEmail = this.sendByEmail;
        assessmentProfile.showReportAtEnd = this.showReportAtEnd;
        assessmentProfile.smtpPort = this.smtpPort != null ? new String(this.smtpPort) : null;
        assessmentProfile.smtpPwd = this.smtpPwd != null ? new String(this.smtpPwd) : null;
        assessmentProfile.smtpServer = this.smtpServer != null ? new String(this.smtpServer) : null;
        assessmentProfile.smtpSSL = this.smtpSSL;
        String string3 = assessmentProfile.smtpUser = this.smtpUser != null ? new String(this.smtpUser) : null;
        if (this.vars != null) {
            assessmentProfile.vars = new ArrayList<String>();
            for (String string4 : this.vars) {
                assessmentProfile.vars.add(string4 != null ? new String(string4) : null);
            }
        }
        assessmentProfile.scorm12 = this.scorm12;
        assessmentProfile.scorm2004 = this.scorm2004;
        return assessmentProfile;
    }

    public boolean isScorm2004() {
        return this.scorm2004;
    }

    public void changeToScorm2004Profile() {
        this.scorm2004 = true;
        this.scorm12 = false;
    }

    public boolean isScorm12() {
        return this.scorm12;
    }

    public void changeToScorm12Profile() {
        this.scorm2004 = false;
        this.scorm12 = true;
    }

    public void changeToNormalProfile() {
        this.scorm2004 = false;
        this.scorm12 = false;
    }

    public static String[] getOperations() {
        return new String[]{"=", ">", "<", ">=", "<="};
    }

    public static String getOpName(Object object) {
        String string = new String("");
        if (object.equals("=")) {
            string = EQUALS;
        } else if (object.equals(">")) {
            string = GRATER;
        } else if (object.equals("<")) {
            string = LESS;
        } else if (object.equals(">=")) {
            string = GRATER_EQ;
        } else if (object.equals("<=")) {
            string = LESS_EQ;
        }
        return string;
    }

    public static String getOpRepresentation(Object object) {
        String string = new String("");
        if (object.equals(EQUALS)) {
            string = "=";
        } else if (object.equals(GRATER)) {
            string = ">";
        } else if (object.equals(LESS)) {
            string = "<";
        } else if (object.equals(GRATER_EQ)) {
            string = ">=";
        } else if (object.equals(LESS_EQ)) {
            string = "<=";
        }
        return string;
    }

    public void setScorm2004(boolean bl) {
        this.scorm2004 = bl;
    }

    public void setScorm12(boolean bl) {
        this.scorm12 = bl;
    }
}

