/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.animation;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.animation.ImageLoaderFactory;
import es.eucm.eadventure.common.data.animation.Timed;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.engine.core.gui.GUI;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frame
implements Cloneable,
Timed {
    public static final String RESOURCE_TYPE_SOUND = "sound";
    public static final int TYPE_IMAGE = 0;
    public static final int TYPE_VIDEO = 1;
    public static final int DEFAULT_TIME = 40;
    private String uri;
    private long time;
    private int type;
    private Image image;
    private List<Resources> resources;
    private boolean waitforclick;
    private String soundUri;
    private int maxSoundTime;
    private String animationPath;
    private ImageLoaderFactory factory;

    public Frame(ImageLoaderFactory imageLoaderFactory) {
        this.factory = imageLoaderFactory;
        this.uri = "";
        this.type = 0;
        this.time = 40L;
        this.image = null;
        this.waitforclick = false;
        this.resources = new ArrayList<Resources>();
        this.soundUri = "";
        this.maxSoundTime = 1000;
    }

    public Frame(ImageLoaderFactory imageLoaderFactory, String string) {
        this.uri = string;
        this.factory = imageLoaderFactory;
        this.type = 0;
        this.time = 40L;
        this.image = null;
        this.waitforclick = false;
        this.resources = new ArrayList<Resources>();
        this.soundUri = "";
        this.maxSoundTime = 1000;
    }

    public Frame(ImageLoaderFactory imageLoaderFactory, String string, long l, boolean bl) {
        this.uri = string;
        this.factory = imageLoaderFactory;
        this.type = 0;
        this.time = l;
        this.image = null;
        this.waitforclick = bl;
        this.resources = new ArrayList<Resources>();
        this.soundUri = "";
        this.maxSoundTime = 1000;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String string) {
        this.uri = string;
        this.image = null;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public void setTime(long l) {
        this.time = l;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String getSoundUri() {
        return this.soundUri;
    }

    public void setSoundUri(String string) {
        this.soundUri = string;
    }

    public int getMaxSoundTime() {
        return this.maxSoundTime;
    }

    public void setMaxSoundTime(int n) {
        this.maxSoundTime = n;
    }

    public void addResources(Resources resources) {
        this.resources.add(resources);
    }

    public List<Resources> getResources() {
        return this.resources;
    }

    public Image getImage(boolean bl, boolean bl2, int n) {
        if (this.image != null) {
            return this.image;
        }
        if (this.uri != null && this.uri.length() > 0) {
            if (n == 0 || n == 1) {
                this.image = this.factory.getImageFromPath(this.uri);
            } else if (n == 2) {
                this.image = this.getImageFromAnimationPath();
            }
        }
        if (this.image != null && bl) {
            this.image = this.getScaledImage(this.image, -1.0f, 1.0f);
        }
        if (this.image != null && bl2) {
            this.image = this.getFullscreenImage(this.image);
        }
        if (this.image == null) {
            ImageIcon imageIcon = new ImageIcon("img/icons/noImageFrame.png");
            if (imageIcon != null && imageIcon.getImage() != null) {
                return imageIcon.getImage();
            }
            return new BufferedImage(100, 120, 5);
        }
        return this.image;
    }

    private Image getImageFromAnimationPath() {
        BufferedImage bufferedImage = null;
        try {
            FileInputStream fileInputStream = null;
            String string = File.separator;
            if (string.equals("\\")) {
                string = "\\\\";
            }
            String[] stringArray = this.animationPath.split(string);
            String string2 = "";
            for (int i = 0; i < stringArray.length - 1; ++i) {
                string2 = string2 + stringArray[i] + File.separator;
            }
            stringArray = this.uri.split("/");
            if (new es.eucm.eadventure.common.auxiliar.File(string2 = string2 + stringArray[stringArray.length - 1]).exists()) {
                fileInputStream = new FileInputStream(string2);
            }
            if (fileInputStream != null) {
                bufferedImage = ImageIO.read(fileInputStream);
                if (bufferedImage == null || ((Image)bufferedImage).getHeight(null) == -1 || ((Image)bufferedImage).getWidth(null) == -1) {
                    this.factory.showErrorDialog(TC.get("Error.Title"), TC.get("Error.ImageTypeNotSupported"));
                }
                ((InputStream)fileInputStream).close();
            }
        }
        catch (IOException iOException) {
            ReportDialog.GenerateErrorReport(iOException, true, "UNKNOWERROR");
        }
        catch (Exception exception) {
            ReportDialog.GenerateErrorReport(exception, true, "UNKNOWERROR");
        }
        return bufferedImage;
    }

    private Image getScaledImage(Image image, float f, float f2) {
        BufferedImage bufferedImage = null;
        if (image != null) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(f, f2);
            affineTransform.translate((f - 1.0f) * (float)image.getWidth(null) / 2.0f, (f2 - 1.0f) * (float)image.getHeight(null) / 2.0f);
            bufferedImage = GUI.getInstance().getGraphicsConfiguration().createCompatibleImage(image.getWidth(null), image.getHeight(null), 3);
            Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
            graphics2D.drawImage(image, affineTransform, null);
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    private Image getFullscreenImage(Image image) {
        BufferedImage bufferedImage = GUI.getInstance().getGraphicsConfiguration().createCompatibleImage(800, 600, 3);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        graphics2D.drawImage(image, 0, 0, 800, 600, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public boolean isWaitforclick() {
        return this.waitforclick;
    }

    public void setWaitforclick(boolean bl) {
        this.waitforclick = bl;
    }

    public Object clone() throws CloneNotSupportedException {
        Frame frame = (Frame)super.clone();
        frame.image = this.image;
        if (this.resources != null) {
            frame.resources = new ArrayList<Resources>();
            for (Resources resources : this.resources) {
                frame.resources.add((Resources)resources.clone());
            }
        }
        frame.time = this.time;
        frame.type = this.type;
        frame.uri = this.uri != null ? new String(this.uri) : null;
        frame.waitforclick = this.waitforclick;
        return frame;
    }

    public void setAbsolutePath(String string) {
        this.animationPath = string;
    }

    public String getImageAbsolutePath() {
        String string = File.separator;
        if (string.equals("\\")) {
            string = "\\\\";
        }
        String[] stringArray = this.animationPath.split(string);
        String string2 = "";
        for (int i = 0; i < stringArray.length - 1; ++i) {
            string2 = string2 + stringArray[i] + File.separator;
        }
        stringArray = this.uri.split("/");
        string2 = string2 + stringArray[stringArray.length - 1];
        return string2;
    }

    public String getSoundAbsolutePath() {
        if (this.soundUri == null || this.soundUri.equals("")) {
            return null;
        }
        String string = File.separator;
        if (string.equals("\\")) {
            string = "\\\\";
        }
        String[] stringArray = this.animationPath.split(string);
        String string2 = "";
        for (int i = 0; i < stringArray.length - 1; ++i) {
            string2 = string2 + stringArray[i] + File.separator;
        }
        stringArray = this.soundUri.split("/");
        string2 = string2 + stringArray[stringArray.length - 1];
        return string2;
    }
}

