/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.animation;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.HasId;
import es.eucm.eadventure.common.data.animation.Frame;
import es.eucm.eadventure.common.data.animation.ImageLoaderFactory;
import es.eucm.eadventure.common.data.animation.Transition;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Animation
implements Cloneable,
Documented,
HasId {
    public static final String RESOURCE_TYPE_MUSIC = "music";
    public static final int ENGINE = 0;
    public static final int EDITOR = 1;
    public static final int PREVIEW = 2;
    private List<Frame> frames;
    private List<Transition> transitions;
    private String documentation;
    private List<Resources> resources;
    private String id;
    private boolean slides;
    private boolean useTransitions;
    private int skippedFrames;
    private boolean mirror;
    private boolean fullscreen;
    private String newSound = null;
    private int soundMaxTime = 1000;
    private int lastSoundFrame = -1;
    private String animationPath;
    private ImageLoaderFactory factory;
    private BufferedImage temp;
    private int temp_w;
    private int temp_h;

    public Animation(String string, ImageLoaderFactory imageLoaderFactory) {
        this.factory = imageLoaderFactory;
        this.id = string;
        this.resources = new ArrayList<Resources>();
        this.frames = new ArrayList<Frame>();
        this.transitions = new ArrayList<Transition>();
        this.frames.add(new Frame(imageLoaderFactory));
        this.transitions.add(new Transition());
        this.transitions.add(new Transition());
        this.skippedFrames = 0;
        this.useTransitions = true;
        this.slides = false;
    }

    public Animation(String string, Frame frame, ImageLoaderFactory imageLoaderFactory) {
        this(string, imageLoaderFactory);
        this.frames.clear();
        this.frames.add(frame);
    }

    public Frame getFrame(int n) {
        if (this.frames.size() <= n || n < 0) {
            return null;
        }
        return this.frames.get(n);
    }

    public Transition getTranstionForFrame(int n) {
        if (this.frames.size() <= n - 1 || n < 0) {
            return null;
        }
        return this.transitions.get(n + 1);
    }

    public Transition getStartTransition() {
        return this.transitions.get(0);
    }

    public Transition getEndTransition() {
        return this.transitions.get(this.transitions.size() - 1);
    }

    public Frame addFrame(int n, Frame frame) {
        if (n >= this.frames.size() || n < 0) {
            n = this.frames.size() - 1;
        }
        if (frame == null) {
            frame = new Frame(this.factory);
        }
        if (this.frames.size() == 1 && this.frames.get(0).getUri().equals("")) {
            this.frames.remove(0);
            this.frames.add(frame);
        } else {
            this.frames.add(n + 1, frame);
            this.transitions.add(n + 2, new Transition());
        }
        return frame;
    }

    public void removeFrame(int n) {
        if (this.frames.size() <= n && n < 0) {
            return;
        }
        this.frames.remove(n);
        this.transitions.remove(n + 1);
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public void setDocumentation(String string) {
        this.documentation = string;
    }

    public void addResources(Resources resources) {
        this.resources.add(resources);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List<Frame> getFrames() {
        return this.frames;
    }

    public List<Transition> getTransitions() {
        return this.transitions;
    }

    public List<Resources> getResources() {
        return this.resources;
    }

    public boolean isSlides() {
        return this.slides;
    }

    public void setSlides(boolean bl) {
        this.slides = bl;
    }

    public boolean isUseTransitions() {
        return this.useTransitions;
    }

    public void setUseTransitions(boolean bl) {
        this.useTransitions = bl;
    }

    public Image getImage(long l, int n) {
        int n2;
        int n3 = this.skippedFrames;
        int n4 = 0;
        for (n2 = 0; n2 < this.frames.size(); ++n2) {
            if (!this.frames.get(n2).isWaitforclick()) continue;
            ++n4;
        }
        if (!this.slides || n4 <= this.skippedFrames) {
            l %= this.getTotalTime();
        }
        for (n2 = 0; n2 < this.frames.size(); ++n2) {
            if (this.frames.get(n2).isWaitforclick()) {
                --n3;
            }
            if (this.frames.get(n2).getTime() > l || this.frames.get(n2).isWaitforclick() && n3 < 0 && this.slides) {
                if (this.lastSoundFrame != n2) {
                    this.newSound = this.frames.get(n2).getSoundUri();
                    this.soundMaxTime = this.frames.get(n2).getMaxSoundTime();
                    this.lastSoundFrame = n2;
                }
                return this.frames.get(n2).getImage(this.mirror, this.fullscreen, n);
            }
            if (n2 == this.frames.size() - 1) {
                return this.noImage();
            }
            if (this.transitions.get(n2 + 1).getTime() > (l -= this.frames.get(n2).getTime()) && this.useTransitions) {
                return this.combinedFrames(n2, l, n);
            }
            if (!this.useTransitions) continue;
            l -= this.transitions.get(n2 + 1).getTime();
        }
        return this.noImage();
    }

    public String getNewSound() {
        String string = this.newSound;
        this.newSound = null;
        return string;
    }

    public int getSoundMaxTime() {
        return this.soundMaxTime;
    }

    private Image noImage() {
        ImageIcon imageIcon = new ImageIcon("img/icons/noImageFrame.png");
        if (imageIcon != null && imageIcon.getImage() != null) {
            return imageIcon.getImage();
        }
        return new BufferedImage(100, 120, 5);
    }

    public boolean finishedFirstTime(long l) {
        int n = this.skippedFrames;
        for (int i = 0; i < this.frames.size(); ++i) {
            if (this.frames.get(i).isWaitforclick()) {
                --n;
            }
            if (this.frames.get(i).getTime() > l || this.frames.get(i).isWaitforclick() && n < 0 && this.slides) {
                return false;
            }
            if (i == this.frames.size() - 1) {
                return true;
            }
            if (this.transitions.get(i + 1).getTime() > (l -= this.frames.get(i).getTime()) && this.useTransitions) {
                return false;
            }
            if (!this.useTransitions) continue;
            l -= this.transitions.get(i + 1).getTime();
        }
        return true;
    }

    public long getTotalTime() {
        long l = 0L;
        for (int i = 0; i < this.frames.size(); ++i) {
            l += this.frames.get(i).getTime();
            if (i >= this.frames.size() - 1 || !this.useTransitions) continue;
            l += this.transitions.get(i + 1).getTime();
        }
        return l;
    }

    private Image combinedFrames(int n, long l, int n2) {
        Image image = this.frames.get(n).getImage(this.mirror, this.fullscreen, n2);
        Image image2 = this.frames.get(n + 1).getImage(this.mirror, this.fullscreen, n2);
        long l2 = this.transitions.get(n + 1).getTime();
        switch (this.transitions.get(n + 1).getType()) {
            case 0: {
                return image;
            }
            case 1: {
                if (this.temp_w != image2.getWidth(null) || this.temp_h != image2.getHeight(null)) {
                    this.temp = new BufferedImage(image2.getWidth(null), image2.getHeight(null), 6);
                    this.temp_w = image2.getWidth(null);
                    this.temp_h = image2.getHeight(null);
                    Runtime.getRuntime().gc();
                }
                Graphics2D graphics2D = (Graphics2D)this.temp.getGraphics();
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 1.0f - (float)l / (float)l2);
                graphics2D.setComposite(alphaComposite);
                graphics2D.drawImage(image, 0, 0, null);
                alphaComposite = AlphaComposite.getInstance(3, (float)l / (float)l2);
                graphics2D.setComposite(alphaComposite);
                graphics2D.drawImage(image2, 0, 0, null);
                return this.temp;
            }
            case 2: {
                if (this.temp_w != image2.getWidth(null) || this.temp_h != image2.getHeight(null)) {
                    this.temp = new BufferedImage(image2.getWidth(null), image2.getHeight(null), 6);
                    this.temp_w = image2.getWidth(null);
                    this.temp_h = image2.getHeight(null);
                    Runtime.getRuntime().gc();
                }
                Graphics2D graphics2D = (Graphics2D)this.temp.getGraphics();
                graphics2D.drawImage(image, (int)((float)image2.getWidth(null) * (float)l / (float)l2), 0, null);
                graphics2D.drawImage(image2, (int)((float)image2.getWidth(null) * (float)l / (float)l2) - image2.getWidth(null), 0, null);
                return this.temp;
            }
            case 3: {
                if (this.temp_w != image2.getWidth(null) || this.temp_h != image2.getHeight(null)) {
                    this.temp = new BufferedImage(image2.getWidth(null), image2.getHeight(null), 6);
                    this.temp_w = image2.getWidth(null);
                    this.temp_h = image2.getHeight(null);
                    Runtime.getRuntime().gc();
                }
                Graphics2D graphics2D = (Graphics2D)this.temp.getGraphics();
                graphics2D.drawImage(image, 0, (int)((float)image2.getHeight(null) * (float)l / (float)l2), null);
                graphics2D.drawImage(image2, 0, (int)((float)image2.getHeight(null) * (float)l / (float)l2) - image2.getHeight(null), null);
                return this.temp;
            }
        }
        return image;
    }

    public void setMirror(boolean bl) {
        this.mirror = bl;
    }

    public long skipFrame(long l) {
        if (!this.slides) {
            return l;
        }
        long l2 = 0L;
        int n = ++this.skippedFrames;
        for (int i = 0; i < this.frames.size(); ++i) {
            if (this.frames.get(i).isWaitforclick()) {
                --n;
            }
            if (this.frames.get(i).getTime() > l || this.frames.get(i).isWaitforclick() && n < 1) {
                return l2 + this.frames.get(i).getTime();
            }
            l2 += this.frames.get(i).getTime();
            if (i == this.frames.size() - 1) {
                return 0L;
            }
            if (this.transitions.get(i + 1).getTime() > (l -= this.frames.get(i).getTime())) {
                --this.skippedFrames;
                return l2 += this.transitions.get(i + 1).getTime();
            }
            l2 += this.transitions.get(i + 1).getTime();
            l -= this.transitions.get(i + 1).getTime();
        }
        this.skippedFrames = 0;
        return 0L;
    }

    public void setFullscreen(boolean bl) {
        this.fullscreen = bl;
    }

    public void restart() {
        this.skippedFrames = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        Animation animation = (Animation)super.clone();
        String string = animation.documentation = this.documentation != null ? new String(this.documentation) : null;
        if (this.frames != null) {
            animation.frames = new ArrayList<Frame>();
            for (Frame cloneable : this.frames) {
                animation.frames.add((Frame)cloneable.clone());
            }
        }
        animation.fullscreen = this.fullscreen;
        animation.id = this.id != null ? new String(this.id) : null;
        animation.mirror = this.mirror;
        if (this.resources != null) {
            animation.resources = new ArrayList<Resources>();
            for (Resources resources : this.resources) {
                animation.resources.add((Resources)resources.clone());
            }
        }
        animation.skippedFrames = this.skippedFrames;
        animation.slides = this.slides;
        if (this.transitions != null) {
            animation.transitions = new ArrayList<Transition>();
            for (Transition transition : this.transitions) {
                animation.transitions.add((Transition)transition.clone());
            }
        }
        animation.useTransitions = this.useTransitions;
        return animation;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    public void setAbsolutePath(String string) {
        this.animationPath = string;
        for (Frame frame : this.frames) {
            frame.setAbsolutePath(string);
        }
    }

    public String getAboslutePath() {
        return this.animationPath;
    }

    public ImageLoaderFactory getImageLoaderFactory() {
        return this.factory;
    }
}

