/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.adventure;

import es.eucm.eadventure.common.data.Described;
import es.eucm.eadventure.common.data.Titled;
import es.eucm.eadventure.common.data.adventure.ChapterSummary;
import es.eucm.eadventure.common.data.adventure.CustomArrow;
import es.eucm.eadventure.common.data.adventure.CustomButton;
import es.eucm.eadventure.common.data.adventure.CustomCursor;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorData
implements Cloneable,
Described,
Titled {
    public static final String DEFAULT_CURSOR = "default";
    public static final String USE_CURSOR = "use";
    public static final String LOOK_CURSOR = "look";
    public static final String EXAMINE_CURSOR = "examine";
    public static final String TALK_CURSOR = "talk";
    public static final String GRAB_CURSOR = "grab";
    public static final String GIVE_CURSOR = "give";
    public static final String EXIT_CURSOR = "exit";
    public static final String CURSOR_OVER = "over";
    public static final String CURSOR_ACTION = "action";
    public static final String TALK_BUTTON = "talk";
    public static final String USE_GRAB_BUTTON = "use-grab";
    public static final String EXAMINE_BUTTON = "examine";
    public static final String HIGHLIGHTED_BUTTON = "highlighted";
    public static final String NORMAL_BUTTON = "normal";
    public static final String PRESSED_BUTTON = "pressed";
    public static final String NORMAL_ARROW_RIGHT = "normalright";
    public static final String NORMAL_ARROW_LEFT = "normalleft";
    public static final String HIGHLIGHTED_ARROW_RIGHT = "highlightedright";
    public static final String HIGHLIGHTED_ARROW_LEFT = "highlightedleft";
    public static final int INVENTORY_NONE = 0;
    public static final int INVENTORY_TOP_BOTTOM = 1;
    public static final int INVENTORY_TOP = 2;
    public static final int INVENTORY_BOTTOM = 3;
    private static final String[] cursorTypes = new String[]{"default", "over", "action", "exit"};
    private static final String[] actionTypes = new String[]{"talk", "use-grab", "examine"};
    private static final String[] buttonTypes = new String[]{"normal", "highlighted"};
    private static final String[] arrowTypes = new String[]{"normalright", "normalleft", "highlightedright", "highlightedleft"};
    public static final boolean[][] typeAllowed = new boolean[][]{{true, false, false, true, true, true, true, true, true, true}, {true, true, true, true, false, false, false, false, false, false}};
    public static final int GUI_TRADITIONAL = 0;
    public static final int GUI_CONTEXTUAL = 1;
    public static final int GRAPHICS_WINDOWED = 0;
    public static final int GRAPHICS_BLACKBKG = 1;
    public static final int GRAPHICS_FULLSCREEN = 2;
    public static final int MODE_PLAYER_1STPERSON = 0;
    public static final int MODE_PLAYER_3RDPERSON = 1;
    protected String title = null;
    protected String description = null;
    protected int guiType = -1;
    private int graphicConfig = 0;
    protected int playerMode = 0;
    protected boolean guiCustomized;
    protected List<ChapterSummary> contents = new ArrayList<ChapterSummary>();
    protected List<CustomCursor> cursors = new ArrayList<CustomCursor>();
    protected List<CustomButton> buttons = new ArrayList<CustomButton>();
    protected List<CustomArrow> arrows = new ArrayList<CustomArrow>();
    protected boolean commentaries = false;
    protected boolean keepShowing = false;
    protected String playerName = "";
    protected Integer inventoryPosition = 1;
    protected String versionNumber = "0";
    protected String projectName = "engine";
    protected DefaultClickAction defaultClickAction = DefaultClickAction.SHOW_DETAILS;
    protected Perspective perspective = Perspective.REGULAR;
    public static final String ENGINE_EXECUTION = "engine";

    public static String getCursorTypeString(int n) {
        switch (n) {
            case 0: {
                return DEFAULT_CURSOR;
            }
            case 1: {
                return CURSOR_OVER;
            }
            case 2: {
                return CURSOR_ACTION;
            }
            case 3: {
                return EXIT_CURSOR;
            }
            case 4: {
                return USE_CURSOR;
            }
            case 5: {
                return LOOK_CURSOR;
            }
            case 6: {
                return "examine";
            }
            case 7: {
                return "talk";
            }
            case 8: {
                return GRAB_CURSOR;
            }
            case 9: {
                return GIVE_CURSOR;
            }
        }
        return null;
    }

    public static int getCursorTypeIndex(String string) {
        if (string.equals(DEFAULT_CURSOR)) {
            return 0;
        }
        if (string.equals(USE_CURSOR)) {
            return 4;
        }
        if (string.equals(LOOK_CURSOR)) {
            return 5;
        }
        if (string.equals("examine")) {
            return 6;
        }
        if (string.equals("talk")) {
            return 7;
        }
        if (string.equals(GRAB_CURSOR)) {
            return 8;
        }
        if (string.equals(GIVE_CURSOR)) {
            return 9;
        }
        if (string.equals(EXIT_CURSOR)) {
            return 3;
        }
        if (string.equals(CURSOR_OVER)) {
            return 1;
        }
        if (string.equals(CURSOR_ACTION)) {
            return 2;
        }
        return -1;
    }

    public static String[] getCursorTypes() {
        return cursorTypes;
    }

    public static String[] getActionTypes() {
        return actionTypes;
    }

    public static String[] getButtonTypes() {
        return buttonTypes;
    }

    public static String[] getArrowTypes() {
        return arrowTypes;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Integer getGUIType() {
        return this.guiType;
    }

    @Override
    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    public void setGUIType(Integer n) {
        this.guiType = n;
    }

    public Integer getPlayerMode() {
        return this.playerMode;
    }

    public void setPlayerMode(Integer n) {
        this.playerMode = n;
    }

    public boolean isGUICustomized() {
        return this.guiCustomized;
    }

    public void setGUI(int n, boolean bl) {
        this.guiType = n;
        this.guiCustomized = bl;
    }

    public List<ChapterSummary> getChapterSummaries() {
        return this.contents;
    }

    public void addChapterSummary(ChapterSummary chapterSummary) {
        this.contents.add(chapterSummary);
    }

    public void addCursor(CustomCursor customCursor) {
        this.cursors.add(customCursor);
        this.guiCustomized = true;
    }

    public List<CustomCursor> getCursors() {
        return this.cursors;
    }

    public void addCursor(String string, String string2) {
        this.addCursor(new CustomCursor(string, string2));
    }

    public String getCursorPath(String string) {
        for (CustomCursor customCursor : this.cursors) {
            if (!customCursor.getType().equals(string)) continue;
            return customCursor.getPath();
        }
        return null;
    }

    public void addButton(CustomButton customButton) {
        this.buttons.add(customButton);
        this.guiCustomized = true;
    }

    public List<CustomButton> getButtons() {
        return this.buttons;
    }

    public void addButton(String string, String string2, String string3) {
        this.addButton(new CustomButton(string, string2, string3));
    }

    public String getButtonPath(String string, String string2) {
        for (CustomButton customButton : this.buttons) {
            if (!customButton.getType().equals(string2) || !customButton.getAction().equals(string)) continue;
            return customButton.getPath();
        }
        return null;
    }

    public void addArrow(CustomArrow customArrow) {
        this.arrows.add(customArrow);
    }

    public void addArrow(String string, String string2) {
        this.arrows.add(new CustomArrow(string, string2));
    }

    public List<CustomArrow> getArrows() {
        return this.arrows;
    }

    public String getArrowPath(String string) {
        for (CustomArrow customArrow : this.arrows) {
            if (!customArrow.getType().equals(string)) continue;
            return customArrow.getPath();
        }
        return null;
    }

    public Boolean isCommentaries() {
        return this.commentaries;
    }

    public void setCommentaries(Boolean bl) {
        this.commentaries = bl;
    }

    public Integer getGraphicConfig() {
        return this.graphicConfig;
    }

    public void setGraphicConfig(Integer n) {
        this.graphicConfig = n;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String string) {
        this.playerName = string;
    }

    public Integer getInventoryPosition() {
        return this.inventoryPosition;
    }

    public void setInventoryPosition(Integer n) {
        this.inventoryPosition = n;
    }

    public int countAssetReferences(String string) {
        int n = 0;
        for (CustomButton cloneable : this.buttons) {
            if (!cloneable.getPath().equals(string)) continue;
            ++n;
        }
        for (CustomArrow customArrow : this.arrows) {
            if (!customArrow.getPath().equals(string)) continue;
            ++n;
        }
        for (CustomCursor customCursor : this.cursors) {
            if (!customCursor.getPath().equals(string)) continue;
            ++n;
        }
        return n;
    }

    public void getAssetReferences(List<String> list, List<Integer> list2) {
        if (list != null && list2 != null) {
            String string;
            int n;
            for (CustomArrow cloneable : this.arrows) {
                n = 9;
                string = cloneable.getPath();
                this.getAssetReferencesForOneAsset(list, list2, string, n);
            }
            for (CustomButton customButton : this.buttons) {
                n = 9;
                string = customButton.getPath();
                this.getAssetReferencesForOneAsset(list, list2, string, n);
            }
            for (CustomCursor customCursor : this.cursors) {
                n = 6;
                string = customCursor.getPath();
                this.getAssetReferencesForOneAsset(list, list2, string, n);
            }
        }
    }

    private void getAssetReferencesForOneAsset(List<String> list, List<Integer> list2, String string, int n) {
        if (string == null) {
            return;
        }
        boolean bl = false;
        for (String string2 : list) {
            if (!string2.toLowerCase().equals(string.toLowerCase())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            int n2 = list.size();
            list.add(n2, string);
            list2.add(n2, n);
        }
    }

    public void deleteAssetReferences(String string) {
        if (string != null) {
            Cloneable cloneable;
            int n;
            for (n = 0; n < this.arrows.size(); ++n) {
                cloneable = this.arrows.get(n);
                if (((CustomArrow)cloneable).getPath() == null || !((CustomArrow)cloneable).getPath().equals(string)) continue;
                this.arrows.remove(n);
                --n;
            }
            for (n = 0; n < this.buttons.size(); ++n) {
                cloneable = this.buttons.get(n);
                if (((CustomButton)cloneable).getPath() == null || !((CustomButton)cloneable).getPath().equals(string)) continue;
                this.buttons.remove(n);
                --n;
            }
            for (n = 0; n < this.cursors.size(); ++n) {
                cloneable = this.cursors.get(n);
                if (((CustomCursor)cloneable).getPath() == null || !((CustomCursor)cloneable).getPath().equals(string)) continue;
                this.cursors.remove(n);
                --n;
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DescriptorData descriptorData = (DescriptorData)super.clone();
        if (this.buttons != null) {
            descriptorData.buttons = new ArrayList<CustomButton>();
            for (CustomButton cloneable : this.buttons) {
                descriptorData.buttons.add((CustomButton)cloneable.clone());
            }
        }
        descriptorData.commentaries = this.commentaries;
        if (this.contents != null) {
            descriptorData.contents = new ArrayList<ChapterSummary>();
            for (ChapterSummary chapterSummary : this.contents) {
                descriptorData.contents.add((ChapterSummary)chapterSummary.clone());
            }
        }
        if (this.cursors != null) {
            descriptorData.cursors = new ArrayList<CustomCursor>();
            for (CustomCursor customCursor : this.cursors) {
                descriptorData.cursors.add((CustomCursor)customCursor.clone());
            }
        }
        if (this.arrows != null) {
            descriptorData.arrows = new ArrayList<CustomArrow>();
            for (CustomArrow customArrow : this.arrows) {
                descriptorData.arrows.add((CustomArrow)customArrow.clone());
            }
        }
        descriptorData.description = this.description != null ? new String(this.description) : null;
        descriptorData.graphicConfig = this.graphicConfig;
        descriptorData.guiCustomized = this.guiCustomized;
        descriptorData.guiType = this.guiType;
        descriptorData.playerMode = this.playerMode;
        descriptorData.playerName = this.playerName != null ? new String(this.playerName) : null;
        descriptorData.title = this.title != null ? new String(this.title) : null;
        descriptorData.inventoryPosition = new Integer(this.inventoryPosition);
        return descriptorData;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(String string) {
        this.versionNumber = string;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String string) {
        this.projectName = string;
    }

    public Boolean isKeepShowing() {
        return this.keepShowing;
    }

    public void setKeepShowing(Boolean bl) {
        this.keepShowing = bl;
    }

    public void setDeafultClickAction(DefaultClickAction defaultClickAction) {
        this.defaultClickAction = defaultClickAction;
    }

    public DefaultClickAction getDefaultClickAction() {
        return this.defaultClickAction;
    }

    public void setPerspective(Perspective perspective) {
        this.perspective = perspective;
    }

    public Perspective getPerspective() {
        return this.perspective;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Perspective {
        REGULAR,
        ISOMETRIC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DefaultClickAction {
        SHOW_DETAILS,
        SHOW_ACTIONS;

    }
}

