/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.adventure;

import es.eucm.eadventure.common.data.Described;
import es.eucm.eadventure.common.data.Titled;
import es.eucm.eadventure.common.data.adaptation.AdaptationProfile;
import es.eucm.eadventure.common.data.assessment.AssessmentProfile;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChapterSummary
implements Cloneable,
Titled,
Described {
    private String title = null;
    private String description = "";
    private String adaptationName = "";
    private String assessmentName = "";
    protected List<AssessmentProfile> assessmentProfiles = new ArrayList<AssessmentProfile>();
    protected List<AdaptationProfile> adaptationProfiles = new ArrayList<AdaptationProfile>();
    private String path;

    public ChapterSummary() {
    }

    public ChapterSummary(String string) {
        this();
        this.title = string;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getAdaptationName() {
        return this.adaptationName;
    }

    public String getAssessmentName() {
        return this.assessmentName;
    }

    @Override
    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    public void setAdaptationName(String string) {
        this.adaptationName = string;
    }

    public void setAssessmentName(String string) {
        this.assessmentName = string;
    }

    public String getChapterPath() {
        return this.path;
    }

    public void setChapterPath(String string) {
        this.path = string;
    }

    public boolean hasAssessmentProfile() {
        return this.assessmentName != null && !this.assessmentName.equals("");
    }

    public boolean hasAdaptationProfile() {
        return this.adaptationName != null && !this.adaptationName.equals("");
    }

    public void addAssessmentProfile(AssessmentProfile assessmentProfile) {
        this.assessmentProfiles.add(assessmentProfile);
    }

    public void addAdaptationProfile(AdaptationProfile adaptationProfile) {
        this.adaptationProfiles.add(adaptationProfile);
    }

    public Object clone() throws CloneNotSupportedException {
        ChapterSummary chapterSummary = (ChapterSummary)super.clone();
        chapterSummary.adaptationName = this.adaptationName != null ? new String(this.adaptationName) : null;
        chapterSummary.assessmentName = this.assessmentName != null ? new String(this.assessmentName) : null;
        chapterSummary.description = this.description != null ? new String(this.description) : null;
        chapterSummary.path = this.path != null ? new String(this.path) : null;
        chapterSummary.title = this.title != null ? new String(this.title) : null;
        chapterSummary.adaptationProfiles = this.adaptationProfiles != null ? new ArrayList() : null;
        chapterSummary.assessmentProfiles = this.assessmentProfiles != null ? new ArrayList() : null;
        return chapterSummary;
    }

    public List<AssessmentProfile> getAssessmentProfiles() {
        return this.assessmentProfiles;
    }

    public List<AdaptationProfile> getAdaptationProfiles() {
        return this.adaptationProfiles;
    }

    public AssessmentProfile getSelectedAssessmentProfile() {
        for (AssessmentProfile assessmentProfile : this.assessmentProfiles) {
            if (!assessmentProfile.getName().equals(this.assessmentName)) continue;
            return assessmentProfile;
        }
        return null;
    }

    public AdaptationProfile getSelectedAdaptationProfile() {
        for (AdaptationProfile adaptationProfile : this.adaptationProfiles) {
            if (!adaptationProfile.getName().equals(this.adaptationName)) continue;
            return adaptationProfile;
        }
        return null;
    }

    public String[] getAdaptationProfilesNames() {
        String[] stringArray = new String[this.adaptationProfiles.size()];
        for (int i = 0; i < this.adaptationProfiles.size(); ++i) {
            stringArray[i] = this.adaptationProfiles.get(i).getName();
        }
        return stringArray;
    }

    public String[] getAssessmentProfilesNames() {
        String[] stringArray = new String[this.assessmentProfiles.size()];
        for (int i = 0; i < this.assessmentProfiles.size(); ++i) {
            stringArray[i] = this.assessmentProfiles.get(i).getName();
        }
        return stringArray;
    }
}

