/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.adventure;

import es.eucm.eadventure.common.data.adventure.ChapterSummary;
import es.eucm.eadventure.common.data.adventure.CustomArrow;
import es.eucm.eadventure.common.data.adventure.CustomButton;
import es.eucm.eadventure.common.data.adventure.CustomCursor;
import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.common.data.chapter.Chapter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdventureData
extends DescriptorData {
    protected List<Chapter> chapters = new ArrayList<Chapter>();

    public AdventureData() {
        this.contents = null;
    }

    public void addChapter(Chapter chapter) {
        this.chapters.add(chapter);
    }

    public List<Chapter> getChapters() {
        return this.chapters;
    }

    public void setChapters(List<Chapter> list) {
        this.chapters = list;
    }

    @Override
    public void addChapterSummary(ChapterSummary chapterSummary) {
        if (chapterSummary instanceof Chapter) {
            this.chapters.add((Chapter)chapterSummary);
        }
    }

    public boolean hasAdapOrAssesData() {
        for (int i = 0; i < this.chapters.size(); ++i) {
            String[] stringArray = this.chapters.get(i).getAdaptationProfilesNames();
            if (stringArray.length > 0) {
                return true;
            }
            String[] stringArray2 = this.chapters.get(i).getAssessmentProfilesNames();
            if (stringArray2.length <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ChapterSummary> getChapterSummaries() {
        ArrayList<ChapterSummary> arrayList = new ArrayList<ChapterSummary>();
        for (Chapter chapter : this.chapters) {
            arrayList.add(chapter);
        }
        return arrayList;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AdventureData adventureData = (AdventureData)super.clone();
        adventureData.buttons = new ArrayList();
        for (Cloneable cloneable : this.buttons) {
            adventureData.buttons.add((CustomButton)((CustomButton)cloneable).clone());
        }
        for (Cloneable cloneable : this.arrows) {
            adventureData.arrows.add((CustomArrow)((CustomArrow)cloneable).clone());
        }
        adventureData.commentaries = this.commentaries;
        adventureData.contents = new ArrayList();
        for (Cloneable cloneable : this.contents) {
            adventureData.contents.add((ChapterSummary)((ChapterSummary)cloneable).clone());
        }
        adventureData.cursors = new ArrayList();
        for (Cloneable cloneable : this.cursors) {
            adventureData.cursors.add((CustomCursor)((CustomCursor)cloneable).clone());
        }
        adventureData.description = new String(this.description);
        adventureData.guiCustomized = this.guiCustomized;
        adventureData.guiType = this.guiType;
        adventureData.playerMode = this.playerMode;
        adventureData.playerName = this.playerName != null ? new String(this.playerName) : null;
        adventureData.title = this.title != null ? new String(this.title) : null;
        return adventureData;
    }
}

