/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.adaptation;

import es.eucm.eadventure.common.data.HasTargetId;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptedState
implements Cloneable,
HasTargetId {
    private String initialScene = null;
    public static final String ACTIVATE = "activate";
    public static final String DEACTIVATE = "deactivate";
    public static final String INCREMENT = "increment";
    public static final String DECREMENT = "decrement";
    public static final String VALUE = "set-value";
    private List<String> allFlagsVars = new ArrayList<String>();
    private List<String> actionsValues = new ArrayList<String>();

    @Override
    public String getTargetId() {
        return this.initialScene;
    }

    public List<String> getFlagsVars() {
        return this.allFlagsVars;
    }

    @Override
    public void setTargetId(String string) {
        this.initialScene = string;
    }

    public void addActivatedFlag(String string) {
        this.allFlagsVars.add(string);
        this.actionsValues.add(ACTIVATE);
    }

    public void addDeactivatedFlag(String string) {
        this.allFlagsVars.add(string);
        this.actionsValues.add(DEACTIVATE);
    }

    public void addVarValue(String string, String string2) {
        this.allFlagsVars.add(string);
        this.actionsValues.add(string2);
    }

    public void removeFlagVar(int n) {
        this.allFlagsVars.remove(n);
        this.actionsValues.remove(n);
    }

    public void changeFlag(int n, String string) {
        int n2 = this.actionsValues.size();
        this.allFlagsVars.remove(n);
        if (n < n2 - 1) {
            this.allFlagsVars.add(n, string);
        } else {
            this.allFlagsVars.add(string);
        }
    }

    public void changeAction(int n) {
        int n2 = this.actionsValues.size();
        if (this.actionsValues.get(n).equals(ACTIVATE)) {
            this.actionsValues.remove(n);
            if (n < n2 - 1) {
                this.actionsValues.add(n, DEACTIVATE);
            } else {
                this.actionsValues.add(DEACTIVATE);
            }
        } else if (this.actionsValues.get(n).equals(DEACTIVATE)) {
            this.actionsValues.remove(n);
            if (n < n2 - 1) {
                this.actionsValues.add(n, ACTIVATE);
            } else {
                this.actionsValues.add(ACTIVATE);
            }
        }
    }

    public void change(int n, String string) {
        if (this.isFlag(n)) {
            this.actionsValues.set(n, "increment 0");
            this.allFlagsVars.set(n, string);
        } else {
            this.actionsValues.set(n, ACTIVATE);
            this.allFlagsVars.set(n, string);
        }
    }

    public void changeAction(int n, String string) {
        if (n >= 0 && n <= this.actionsValues.size()) {
            this.actionsValues.remove(n);
            this.actionsValues.add(n, string);
        }
    }

    public String getAction(int n) {
        return this.actionsValues.get(n);
    }

    public String getValueForVar(int n) {
        String string = this.actionsValues.get(n);
        return Integer.toString(this.getValueToSet(n));
    }

    public int getValueToSet(int n) {
        String string = this.actionsValues.get(n);
        int n2 = string.indexOf(" ");
        if (n2 != -1) {
            string = string.substring(n2 + 1);
            return Integer.parseInt(string);
        }
        return Integer.MIN_VALUE;
    }

    public int getValue(int n) {
        return Integer.parseInt(this.actionsValues.get(n));
    }

    public String getFlagVar(int n) {
        return this.allFlagsVars.get(n);
    }

    public boolean isEmpty() {
        return this.allFlagsVars.size() == 0 && (this.initialScene == null || this.initialScene.equals(""));
    }

    public List<String> getActivatedFlags() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.actionsValues.size(); ++i) {
            if (!this.actionsValues.get(i).equals(ACTIVATE)) continue;
            arrayList.add(this.allFlagsVars.get(i));
        }
        return arrayList;
    }

    public List<String> getDeactivatedFlags() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.actionsValues.size(); ++i) {
            if (!this.actionsValues.get(i).equals(DEACTIVATE)) continue;
            arrayList.add(this.allFlagsVars.get(i));
        }
        return arrayList;
    }

    public void getVarsValues(List<String> list, List<String> list2) {
        for (int i = 0; i < this.actionsValues.size(); ++i) {
            if (this.actionsValues.get(i).equals(ACTIVATE) || this.actionsValues.get(i).equals(DEACTIVATE)) continue;
            list.add(this.allFlagsVars.get(i));
            list2.add(this.actionsValues.get(i));
        }
    }

    public void merge(AdaptedState adaptedState) {
        if (adaptedState.initialScene != null) {
            this.initialScene = adaptedState.initialScene;
        }
        if (this.allFlagsVars.size() == 0) {
            this.allFlagsVars = adaptedState.allFlagsVars;
            this.actionsValues = adaptedState.actionsValues;
        } else {
            for (int i = 0; i < adaptedState.allFlagsVars.size(); ++i) {
                this.allFlagsVars.add(adaptedState.allFlagsVars.get(i));
                this.actionsValues.add(adaptedState.allFlagsVars.get(i));
            }
        }
    }

    public boolean isFlag(int n) {
        String string = this.actionsValues.get(n);
        return string.equals(ACTIVATE) || string.equals(DEACTIVATE);
    }

    public boolean isFlag(String string) {
        boolean bl = false;
        for (int i = 0; i < this.allFlagsVars.size(); ++i) {
            if (!this.allFlagsVars.get(i).equals(string)) continue;
            return this.isFlag(i);
        }
        return bl;
    }

    public Object clone() throws CloneNotSupportedException {
        AdaptedState adaptedState = (AdaptedState)super.clone();
        adaptedState.actionsValues = new ArrayList<String>();
        for (String string : this.actionsValues) {
            adaptedState.actionsValues.add(string != null ? new String(string) : null);
        }
        adaptedState.allFlagsVars = new ArrayList<String>();
        for (String string : this.allFlagsVars) {
            adaptedState.allFlagsVars.add(string != null ? new String(string) : null);
        }
        adaptedState.initialScene = this.initialScene != null ? new String(this.initialScene) : null;
        return adaptedState;
    }

    public List<String> getActionsValues() {
        return this.actionsValues;
    }

    public static boolean isActivateOp(String string) {
        return string.contains(ACTIVATE);
    }

    public static boolean isDeactivateOp(String string) {
        return string.contains(DEACTIVATE);
    }

    public static boolean isSetValueOp(String string) {
        return string.contains(VALUE);
    }

    public static boolean isIncrementOp(String string) {
        return string.contains(INCREMENT);
    }

    public static boolean isDecrementOp(String string) {
        return string.contains(DECREMENT);
    }

    public static String getSetValueData(String string) {
        int n = string.indexOf(" ");
        if (n != -1) {
            string = string.substring(n + 1);
            return string;
        }
        return null;
    }
}

