/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.adaptation;

import es.eucm.eadventure.common.data.Described;
import es.eucm.eadventure.common.data.adaptation.AdaptedState;
import es.eucm.eadventure.common.data.adaptation.ContainsAdaptedState;
import es.eucm.eadventure.common.data.adaptation.UOLProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptationRule
implements Cloneable,
Described,
ContainsAdaptedState {
    private String id;
    private AdaptedState gameState;
    private List<UOLProperty> uolState = new ArrayList<UOLProperty>();
    private String description;

    public AdaptationRule() {
        this.gameState = new AdaptedState();
    }

    public void addUOLProperty(UOLProperty uOLProperty) {
        this.uolState.add(uOLProperty);
    }

    public void addUOLProperty(String string, String string2, String string3) {
        this.addUOLProperty(new UOLProperty(string, string2, string3));
    }

    public List<UOLProperty> getUOLProperties() {
        return this.uolState;
    }

    public void setInitialScene(String string) {
        this.gameState.setTargetId(string);
    }

    public void addActivatedFlag(String string) {
        this.gameState.addActivatedFlag(string);
    }

    public void addDeactivatedFlag(String string) {
        this.gameState.addDeactivatedFlag(string);
    }

    public void addVarValue(String string, String string2) {
        this.gameState.addVarValue(string, string2);
    }

    @Override
    public AdaptedState getAdaptedState() {
        return this.gameState;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public Set<String> getPropertyNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (UOLProperty uOLProperty : this.uolState) {
            hashSet.add(uOLProperty.getId());
        }
        return hashSet;
    }

    public String getPropertyValue(String string) {
        for (UOLProperty uOLProperty : this.uolState) {
            if (!uOLProperty.getId().equals(string)) continue;
            return uOLProperty.getValue();
        }
        return new String("");
    }

    public String getPropertyOp(String string) {
        for (UOLProperty uOLProperty : this.uolState) {
            if (!uOLProperty.getId().equals(string)) continue;
            return uOLProperty.getOperation();
        }
        return new String("");
    }

    public Object clone() throws CloneNotSupportedException {
        AdaptationRule adaptationRule = (AdaptationRule)super.clone();
        adaptationRule.description = this.description != null ? new String(this.description) : null;
        adaptationRule.gameState = (AdaptedState)this.gameState.clone();
        adaptationRule.id = this.id != null ? new String(this.id) : null;
        adaptationRule.uolState = new ArrayList<UOLProperty>();
        for (UOLProperty uOLProperty : this.uolState) {
            adaptationRule.uolState.add((UOLProperty)uOLProperty.clone());
        }
        return adaptationRule;
    }

    @Override
    public void setAdaptedState(AdaptedState adaptedState) {
        this.gameState = adaptedState;
    }
}

