/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.auxiliar;

import es.eucm.eadventure.common.auxiliar.File;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.engine.core.data.SaveGameException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontFormatException;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.InvalidPropertiesFormatException;
import java.util.MissingResourceException;
import java.util.zip.ZipException;
import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.media.NoPlayerException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ReportDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static int PANEL_WIDTH = 500;
    private static int PANEL_HEIGHT = 500;
    private JTextField nameTextField;
    private JTextField emailTextField;
    private JTextArea descriptionTextArea;
    private JButton sendButton;
    private JButton dontSendButton;
    private boolean askName;
    private String exception = "";
    private String message = "";
    private String os;
    private String java;
    private String release;

    public static void GenerateErrorReport(Exception exception, boolean bl, String string) {
        if (ReportDialog.isInterestingException(exception)) {
            new ReportDialog(exception, bl, string);
        } else {
            exception.printStackTrace();
        }
    }

    public static void GenerateCommentsReport() {
        new ReportDialog();
    }

    private static boolean isInterestingException(Exception exception) {
        if (exception instanceof NullPointerException) {
            return true;
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return true;
        }
        if (exception instanceof IOException) {
            return false;
        }
        if (exception instanceof AuthenticationFailedException) {
            return false;
        }
        if (exception instanceof MessagingException) {
            return true;
        }
        if (exception instanceof MalformedURLException) {
            return true;
        }
        if (exception instanceof FileNotFoundException) {
            return true;
        }
        if (exception instanceof ParserConfigurationException) {
            return true;
        }
        if (exception instanceof SAXException) {
            return true;
        }
        if (exception instanceof InvalidPropertiesFormatException) {
            return true;
        }
        if (exception instanceof SAXParseException) {
            return true;
        }
        if (exception instanceof ParseException) {
            return true;
        }
        if (exception instanceof UnsupportedEncodingException) {
            return true;
        }
        if (exception instanceof TransformerConfigurationException) {
            return true;
        }
        if (exception instanceof TransformerException) {
            return true;
        }
        if (exception instanceof InterruptedException) {
            return true;
        }
        if (exception instanceof HeadlessException) {
            return true;
        }
        if (exception instanceof InvalidMidiDataException) {
            return false;
        }
        if (exception instanceof MidiUnavailableException) {
            return false;
        }
        if (exception instanceof LineUnavailableException) {
            return false;
        }
        if (exception instanceof UnsupportedAudioFileException) {
            return false;
        }
        if (exception instanceof BadLocationException) {
            return false;
        }
        if (exception instanceof RuntimeException) {
            return true;
        }
        if (exception instanceof NumberFormatException) {
            return true;
        }
        if (exception instanceof MissingResourceException) {
            return true;
        }
        if (exception instanceof NoPlayerException) {
            return true;
        }
        if (exception instanceof ZipException) {
            return true;
        }
        if (exception instanceof SecurityException) {
            return true;
        }
        if (exception instanceof SaveGameException) {
            return true;
        }
        if (exception instanceof FontFormatException) {
            return true;
        }
        return true;
    }

    private ReportDialog(Exception exception, boolean bl, String string) {
        Object object;
        JComponent jComponent;
        Object object2;
        Object object3;
        this.setSize(PANEL_WIDTH, PANEL_HEIGHT);
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        String string2 = TC.get("ErrorReport.Title");
        this.setTitle(!string2.equals("Error") ? string2 : "Error Report");
        this.setLayout(new GridBagLayout());
        this.askName = bl;
        this.message = string;
        double d = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        double d2 = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        int n = Math.round((float)((int)d - PANEL_WIDTH) / 2.0f);
        int n2 = Math.round((float)((int)d2 - PANEL_HEIGHT) / 2.0f);
        this.setLocation(n, n2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 2;
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        this.add((Component)jTextArea, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        if (bl) {
            this.add((Component)this.createNamePanel(), gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        this.os = "OS: " + System.getProperty("os.name");
        JLabel jLabel = new JLabel(this.os);
        this.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.java = "JAVA: " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor");
        JLabel jLabel2 = new JLabel(this.java);
        this.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        File file = new File("RELEASE");
        this.release = null;
        if (file.exists()) {
            try {
                object3 = new FileInputStream(file);
                object2 = new BufferedInputStream((InputStream)object3);
                int n3 = -1;
                while ((n3 = ((BufferedInputStream)object2).read()) != -1) {
                    if (this.release == null) {
                        this.release = "RELEASE: " + (char)n3;
                        continue;
                    }
                    this.release = this.release + (char)n3;
                }
                if (this.release != null) {
                    jComponent = new JLabel(this.release);
                    this.add((Component)jComponent, gridBagConstraints);
                    ++gridBagConstraints.gridy;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        object3 = new JPanel();
        ((Container)object3).setLayout(new BorderLayout());
        object2 = TC.get("ErrorReport.ShortDescription");
        ((Container)object3).add((Component)new JLabel((String)(!((String)object2).equals("Error") ? object2 : "Short description")), "North");
        this.descriptionTextArea = new JTextArea();
        this.descriptionTextArea.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this.descriptionTextArea);
        jScrollPane.setSize(PANEL_WIDTH, PANEL_HEIGHT / 2 - 100);
        ((Container)object3).add((Component)jScrollPane, "Center");
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)object3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jComponent = new JPanel();
        jComponent.setLayout(new BorderLayout());
        String string3 = TC.get("ErrorReport.FoundException");
        jComponent.add((Component)new JLabel(!string3.equals("Error") ? string3 : "Found exception"), "North");
        JTextArea jTextArea2 = new JTextArea();
        if (exception != null) {
            object = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)object, true);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            ((StringWriter)object).flush();
            this.exception = ((StringWriter)object).toString();
        }
        jTextArea2.setText(this.exception);
        jTextArea2.setEditable(false);
        object = new JScrollPane(jTextArea2);
        jComponent.add((Component)object, "Center");
        this.add((Component)jComponent, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 0;
        this.add((Component)this.createButtonPanel(true), gridBagConstraints);
        this.setVisible(true);
    }

    private ReportDialog() {
        Object object;
        Object object2;
        this.setSize(PANEL_WIDTH, PANEL_HEIGHT);
        this.setResizable(false);
        this.setTitle(TC.get("ErrorReport.TitleComments"));
        this.setLayout(new GridBagLayout());
        double d = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        double d2 = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        int n = Math.round((float)((int)d - PANEL_WIDTH) / 2.0f);
        int n2 = Math.round((float)((int)d2 - PANEL_HEIGHT) / 2.0f);
        this.setLocation(n, n2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 0;
        this.add((Component)this.createNamePanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.os = "OS: " + System.getProperty("os.name");
        JLabel jLabel = new JLabel(this.os);
        this.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.java = "JAVA: " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor");
        JLabel jLabel2 = new JLabel(this.java);
        this.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        File file = new File("RELEASE");
        this.release = null;
        if (file.exists()) {
            try {
                object2 = new FileInputStream(file);
                object = new BufferedInputStream((InputStream)object2);
                int n3 = -1;
                while ((n3 = ((BufferedInputStream)object).read()) != -1) {
                    if (this.release == null) {
                        this.release = "RELEASE: " + (char)n3;
                        continue;
                    }
                    this.release = this.release + (char)n3;
                }
                if (this.release != null) {
                    JLabel jLabel3 = new JLabel(this.release);
                    this.add((Component)jLabel3, gridBagConstraints);
                    ++gridBagConstraints.gridy;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object2 = new JPanel();
        ((Container)object2).setLayout(new BorderLayout());
        ((Container)object2).add((Component)new JLabel(TC.get("ErrorReport.Comments")), "North");
        this.descriptionTextArea = new JTextArea();
        this.descriptionTextArea.setLineWrap(true);
        object = new JScrollPane(this.descriptionTextArea);
        ((Component)object).setSize(PANEL_WIDTH, PANEL_HEIGHT / 2 - 100);
        ((Container)object2).add((Component)object, "Center");
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)object2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 0;
        this.add((Component)this.createButtonPanel(false), gridBagConstraints);
        this.setVisible(true);
    }

    private JPanel createButtonPanel(final boolean bl) {
        JPanel jPanel = new JPanel();
        String string = TC.get("ErrorReport.Send");
        this.sendButton = new JButton(!string.equals("Error") ? string : "Send");
        this.sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportDialog.this.sendReport(bl);
                ReportDialog.this.setVisible(false);
            }
        });
        jPanel.add(this.sendButton);
        String string2 = TC.get("ErrorReport.Cancel");
        this.dontSendButton = new JButton(!string2.equals("Error") ? string2 : "Cancel");
        this.dontSendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportDialog.this.setVisible(false);
            }
        });
        jPanel.add(this.dontSendButton);
        return jPanel;
    }

    protected void sendReport(boolean bl) {
        String string;
        if (bl) {
            string = "ERROR REPORT\n" + this.message + "\n\n";
            if (this.askName) {
                string = string + "USER: " + this.nameTextField.getText() + "\n";
                string = string + "EMAIL: " + this.emailTextField.getText() + "\n\n";
            }
            string = string + this.os + "\n";
            string = string + this.java + "\n";
            if (this.release != null) {
                string = string + this.release + "\n";
            }
            string = string + "\n";
            string = string + "DESCRIPTION:\n" + this.descriptionTextArea.getText() + "\n\n\n";
            string = string + "STACK TRACE:\n" + this.exception + "\n";
        } else {
            string = "USER COMMENTS\n\n";
            string = string + "USER: " + this.nameTextField.getText() + "\n";
            string = string + "EMAIL: " + this.emailTextField.getText() + "\n\n";
            string = string + this.os + "\n";
            string = string + this.java + "\n";
            if (this.release != null) {
                string = string + this.release + "\n";
            }
            string = string + "\n";
            string = string + "COMMENTS AND SUGGESTIONS:\n" + this.descriptionTextArea.getText() + "\n";
        }
        try {
            URL uRL = new URL("http://backend-ea.e-ucm.es/reports.php");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setAllowUserInteraction(true);
            HttpURLConnection.setFollowRedirects(true);
            httpURLConnection.setInstanceFollowRedirects(true);
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            String string2 = "type=" + (bl ? "bug" : "comment") + "&version=" + this.release + "&file=" + string;
            dataOutputStream.writeBytes(string2);
            dataOutputStream.flush();
            dataOutputStream.close();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            bufferedReader.readLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendReport(String string) {
        try {
            URL uRL = new URL("http://backend-ea.e-ucm.es/reports.php");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setAllowUserInteraction(true);
            HttpURLConnection.setFollowRedirects(true);
            httpURLConnection.setInstanceFollowRedirects(true);
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            String string2 = "type=comment&version=medicina_informe&file=" + string;
            dataOutputStream.writeBytes(string2);
            dataOutputStream.flush();
            dataOutputStream.close();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            bufferedReader.readLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JPanel createNamePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        String string = TC.get("ErrorReport.Name");
        jPanel.add((Component)new JLabel(!string.equals("Error") ? string : "Name"), gridBagConstraints);
        this.nameTextField = new JTextField(25){
            private static final long serialVersionUID = 1L;

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.nameTextField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        String string2 = TC.get("ErrorReport.Email");
        jPanel.add((Component)new JLabel(!string2.equals("Error") ? string2 : "e-mail"), gridBagConstraints);
        this.emailTextField = new JTextField(200);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.emailTextField, gridBagConstraints);
        return jPanel;
    }

    public static void main(String[] stringArray) {
        ReportDialog.GenerateErrorReport(new Exception(), false, "ERROR MESSAGE");
    }
}

